/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.projectnessie.model.Content;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.types.ContentTypes;
import org.projectnessie.model.types.RepositoryConfigTypes;

final class Util {
    private static final char DOT = '.';
    private static final char STAR = '*';
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private static final char PERCENT = '%';
    private static final char ESCAPE_FOR_DOT = '.';
    private static final char ESCAPE_FOR_STAR = '*';
    private static final char ESCAPE_FOR_SLASH = '{';
    private static final char ESCAPE_FOR_BACKSLASH = '}';
    private static final char ESCAPE_FOR_PERCENT = '[';
    private static final String ESCAPE_STRING_FOR_DOT = "*.";
    private static final String ESCAPE_STRING_FOR_STAR = "**";
    private static final String ESCAPE_STRING_FOR_SLASH = "*{";
    private static final String ESCAPE_STRING_FOR_BACKSLASH = "*}";
    private static final String ESCAPE_STRING_FOR_PERCENT = "*[";
    public static final int FIRST_ALLOWED_KEY_CHAR = 32;
    public static final char ZERO_BYTE = '\u0000';
    public static final char GROUP_SEPARATOR = '\u001d';
    public static final char URL_PATH_SEPARATOR = '/';
    public static final String DOT_STRING = ".";
    public static final char REF_HASH_SEPARATOR = '@';

    private Util() {
    }

    public static List<String> fromPathString(String encoded) {
        ArrayList<String> elements = new ArrayList<String>();
        int l = encoded.length();
        StringBuilder e = new StringBuilder();
        block4: for (int i = 0; i < l; ++i) {
            char c = encoded.charAt(i);
            switch (c) {
                case '.': {
                    if (e.length() == 0) {
                        return Util.fromPathStringEscaped(elements, encoded);
                    }
                    elements.add(e.toString());
                    e.setLength(0);
                    continue block4;
                }
                case '\u0000': 
                case '\u001d': {
                    e.append('.');
                    continue block4;
                }
                default: {
                    e.append(c);
                }
            }
        }
        if (e.length() > 0) {
            elements.add(e.toString());
        }
        return elements;
    }

    private static List<String> fromPathStringEscaped(List<String> elements, String encoded) {
        int l = encoded.length();
        StringBuilder e = new StringBuilder();
        block11: for (int i = 1; i < l; ++i) {
            char c = encoded.charAt(i);
            switch (c) {
                case '.': {
                    elements.add(e.toString());
                    e.setLength(0);
                    continue block11;
                }
                case '*': {
                    if (++i == l) {
                        throw new IllegalArgumentException("Illegal escaping sequence at the end of encoded path: " + encoded);
                    }
                    c = encoded.charAt(i);
                    switch (c) {
                        case '.': {
                            e.append('.');
                            continue block11;
                        }
                        case '{': {
                            e.append('/');
                            continue block11;
                        }
                        case '}': {
                            e.append('\\');
                            continue block11;
                        }
                        case '[': {
                            e.append('%');
                            continue block11;
                        }
                        case '*': {
                            e.append('*');
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException("Illegal escaping sequence *" + c + " in encoded path: " + encoded);
                }
                default: {
                    e.append(c);
                }
            }
        }
        if (e.length() > 0) {
            elements.add(e.toString());
        }
        return elements;
    }

    public static String toPathString(List<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            int l = element.length();
            for (int i = 0; i < l; ++i) {
                char c = element.charAt(i);
                sb.append(c == '.' || c == '\u0000' ? (char)'\u001d' : (char)c);
            }
        }
        return sb.toString();
    }

    public static String toPathStringEscaped(List<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            int l = element.length();
            for (int i = 0; i < l; ++i) {
                char c = element.charAt(i);
                switch (c) {
                    case '%': 
                    case '.': 
                    case '/': 
                    case '\\': {
                        sb.setLength(0);
                        return Util.toPathStringEscaped(elements, sb);
                    }
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String toCanonicalString(List<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            int l = element.length();
            for (int i = 0; i < l; ++i) {
                char c = element.charAt(i);
                if (c == '.') {
                    sb.setLength(0);
                    return Util.toPathStringCanonical(elements, sb);
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private static String toPathStringEscaped(List<String> elements, StringBuilder sb) {
        for (String element : elements) {
            sb.append('.');
            int l = element.length();
            block8: for (int i = 0; i < l; ++i) {
                char c = element.charAt(i);
                switch (c) {
                    case '.': {
                        sb.append(ESCAPE_STRING_FOR_DOT);
                        continue block8;
                    }
                    case '/': {
                        sb.append(ESCAPE_STRING_FOR_SLASH);
                        continue block8;
                    }
                    case '\\': {
                        sb.append(ESCAPE_STRING_FOR_BACKSLASH);
                        continue block8;
                    }
                    case '%': {
                        sb.append(ESCAPE_STRING_FOR_PERCENT);
                        continue block8;
                    }
                    case '*': {
                        sb.append(ESCAPE_STRING_FOR_STAR);
                        continue block8;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
        }
        return sb.toString();
    }

    private static String toPathStringCanonical(List<String> elements, StringBuilder sb) {
        for (String element : elements) {
            sb.append('.');
            int l = element.length();
            block5: for (int i = 0; i < l; ++i) {
                char c = element.charAt(i);
                switch (c) {
                    case '.': {
                        sb.append(ESCAPE_STRING_FOR_DOT);
                        continue block5;
                    }
                    case '*': {
                        sb.append(ESCAPE_STRING_FOR_STAR);
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String toPathStringRef(String name, String hash) {
        boolean separatorRequired;
        StringBuilder builder = new StringBuilder();
        boolean bl = separatorRequired = hash != null && !hash.isEmpty() && Util.isHexChar(hash.charAt(0));
        if (name != null) {
            builder.append(name);
            separatorRequired |= name.indexOf(47) >= 0;
        }
        if (separatorRequired) {
            builder.append('@');
        }
        if (hash != null) {
            builder.append(hash);
        }
        return builder.toString();
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    static class DurationDeserializer
    extends StdDeserializer<Duration> {
        public DurationDeserializer() {
            this(null);
        }

        protected DurationDeserializer(Class<?> vc) {
            super(vc);
        }

        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Duration.parse(p.getText());
        }
    }

    static class DurationSerializer
    extends StdSerializer<Duration> {
        public DurationSerializer() {
            this(Duration.class);
        }

        protected DurationSerializer(Class<Duration> t) {
            super(t);
        }

        public void serialize(Duration value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }

    static final class RepositoryConfigTypeSerializer
    extends JsonSerializer<RepositoryConfig.Type> {
        RepositoryConfigTypeSerializer() {
        }

        public void serialize(RepositoryConfig.Type value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.name());
            }
        }
    }

    static final class RepositoryConfigTypeDeserializer
    extends JsonDeserializer<RepositoryConfig.Type> {
        RepositoryConfigTypeDeserializer() {
        }

        public RepositoryConfig.Type deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String name = (String)p.readValueAs(String.class);
            return name != null ? RepositoryConfigTypes.forName(name) : null;
        }
    }

    static final class ContentTypeSerializer
    extends JsonSerializer<Content.Type> {
        ContentTypeSerializer() {
        }

        public void serialize(Content.Type value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.name());
            }
        }
    }

    static final class ContentTypeDeserializer
    extends JsonDeserializer<Content.Type> {
        ContentTypeDeserializer() {
        }

        public Content.Type deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String name = (String)p.readValueAs(String.class);
            return name != null ? ContentTypes.forName(name) : null;
        }
    }
}

