/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.value.Value;
import org.projectnessie.model.Elements;
import org.projectnessie.model.ImmutableContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Util;

@JsonSerialize(as=ImmutableContentKey.class)
@JsonDeserialize(as=ImmutableContentKey.class)
@Value.Immutable
public abstract class ContentKey
implements Comparable<ContentKey>,
Elements {
    public static final int MAX_LENGTH = 500;
    public static final int MAX_ELEMENTS = 20;

    @Override
    @NotNull
    @jakarta.validation.constraints.NotNull
    @Size
    @jakarta.validation.constraints.Size(min=1)
    @Value.Parameter(order=1)
    public abstract @NotNull @jakarta.validation.constraints.NotNull @Size @jakarta.validation.constraints.Size(min=1) List<String> getElements();

    @Override
    @JsonIgnore
    @Value.Redacted
    public String[] getElementsArray() {
        return this.getElements().toArray(new String[0]);
    }

    @Override
    @JsonIgnore
    @Value.Redacted
    public int getElementCount() {
        return this.getElements().size();
    }

    @JsonIgnore
    @Value.Redacted
    public Namespace getNamespace() {
        return Namespace.of(this.getElements().subList(0, this.getElementCount() - 1));
    }

    @JsonIgnore
    @Value.Redacted
    public String getName() {
        return this.getElements().get(this.getElementCount() - 1);
    }

    @JsonIgnore
    @Value.Redacted
    public ContentKey getParent() {
        List<String> elements = this.getElements();
        if (elements.size() <= 1) {
            throw new IllegalArgumentException("ContentKey has no parent");
        }
        return ContentKey.of(elements.subList(0, elements.size() - 1));
    }

    public ContentKey truncateToLength(int targetMaxLength) {
        List<String> elements = this.getElements();
        List<String> truncated = ContentKey.truncateToLengthElements(elements, targetMaxLength);
        if (truncated == elements) {
            return this;
        }
        return ContentKey.of(truncated);
    }

    private static List<String> truncateToLengthElements(List<String> elements, int targetMaxLength) {
        int len = elements.size();
        if (len <= targetMaxLength) {
            return elements;
        }
        return elements.subList(0, targetMaxLength);
    }

    public boolean startsWith(ContentKey other) {
        List<String> elements = this.getElements();
        List<String> otherElements = other.getElements();
        return ContentKey.startsWith(elements, otherElements);
    }

    public boolean startsWith(Namespace other) {
        List<String> elements = this.getElements();
        List<String> otherElements = other.getElements();
        return ContentKey.startsWith(elements, otherElements);
    }

    private static boolean startsWith(List<String> elements, List<String> otherElements) {
        int len = elements.size();
        int otherLen = otherElements.size();
        if (otherLen > len) {
            return false;
        }
        for (int i = 0; i < otherLen; ++i) {
            if (elements.get(i).equals(otherElements.get(i))) continue;
            return false;
        }
        return true;
    }

    public static ContentKey of(Namespace namespace, String name) {
        ImmutableContentKey.Builder b = ImmutableContentKey.builder();
        if (namespace != null && !namespace.isEmpty()) {
            b.elements(namespace.getElements());
        }
        return b.addElements(name).build();
    }

    public static ContentKey of(String ... elements) {
        Objects.requireNonNull(elements, "Elements array must not be null");
        return ImmutableContentKey.of(Arrays.asList(elements));
    }

    @JsonCreator
    public static ContentKey of(@JsonProperty(value="elements") List<String> elements) {
        Objects.requireNonNull(elements, "elements argument is null");
        return ImmutableContentKey.of(elements);
    }

    @Value.Check
    protected void validate() {
        Elements.super.validate("Content key");
    }

    public static ContentKey fromPathString(String encoded) {
        return ContentKey.of(Util.fromPathString(encoded));
    }

    @Override
    @JsonIgnore
    @Value.NonAttribute
    public String toPathString() {
        return Elements.super.toPathString();
    }

    @Override
    @JsonIgnore
    @Value.NonAttribute
    public String toPathStringEscaped() {
        return Elements.super.toPathStringEscaped();
    }

    @Override
    @JsonIgnore
    @Value.NonAttribute
    public String toCanonicalString() {
        return Elements.super.toCanonicalString();
    }

    public String toString() {
        return String.join((CharSequence)".", this.getElements());
    }

    public int hashCode() {
        int h = 1;
        for (String element : this.getElements()) {
            h = 31 * h + element.hashCode();
        }
        return h;
    }

    @Override
    public final int compareTo(ContentKey that) {
        List<String> a = this.getElements();
        List<String> b = that.getElements();
        int max = Math.min(a.size(), b.size());
        for (int i = 0; i < max; ++i) {
            int cmp = a.get(i).compareTo(b.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return a.size() - b.size();
    }
}

