/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.testworker;

import com.google.protobuf.ByteString;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.testworker.OnRefOnly;
import org.projectnessie.versioned.testworker.TestContentSerializer;

public class OnRefOnlySerializer
extends TestContentSerializer<OnRefOnly> {
    public Content.Type contentType() {
        return OnRefOnly.ON_REF_ONLY;
    }

    public byte payload() {
        return 127;
    }

    public ByteString toStoreOnReferenceState(OnRefOnly content, Consumer<ContentAttachment> attachmentConsumer) {
        return content.serialized();
    }

    public OnRefOnly applyId(OnRefOnly content, String id) {
        return OnRefOnly.onRef(content.getOnRef(), id);
    }

    @Override
    protected OnRefOnly valueFromStore(String contentId, String onRef, ByteString global, Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> attachmentsRetriever) {
        Assertions.assertThat((Iterable)global).isNull();
        return OnRefOnly.onRef(onRef, contentId);
    }
}

