/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;

public class CommitBuilder {
    private final List<Operation> operations = new ArrayList<Operation>();
    private final VersionStore store;
    private CommitMeta metadata = null;
    private Optional<Hash> referenceHash = Optional.empty();
    private boolean fromLatest = false;

    public CommitBuilder(VersionStore store) {
        this.store = store;
    }

    public CommitBuilder put(String key, Content value) {
        return this.put(Key.of((String[])new String[]{key}), value);
    }

    public CommitBuilder put(Key key, Content value) {
        return this.add((Operation)Put.of((Key)key, (Content)value));
    }

    public CommitBuilder delete(String key) {
        return this.delete(Key.of((String[])new String[]{key}));
    }

    public CommitBuilder delete(Key key) {
        return this.add((Operation)Delete.of((Key)key));
    }

    public CommitBuilder unchanged(String key) {
        return this.unchanged(Key.of((String[])new String[]{key}));
    }

    public CommitBuilder unchanged(Key key) {
        return this.add((Operation)Unchanged.of((Key)key));
    }

    public CommitBuilder add(Operation operation) {
        this.operations.add(operation);
        return this;
    }

    public CommitBuilder withMetadata(CommitMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public CommitBuilder fromReference(Hash reference) {
        this.referenceHash = Optional.of(reference);
        this.fromLatest = false;
        return this;
    }

    public CommitBuilder fromLatest() {
        this.fromLatest = true;
        return this;
    }

    public Hash toBranch(BranchName branchName) throws ReferenceNotFoundException, ReferenceConflictException {
        Optional<Hash> reference = this.fromLatest ? Optional.of(this.store.hashOnReference((NamedRef)branchName, Optional.empty())) : this.referenceHash;
        Hash commitHash = this.store.commit(branchName, reference, this.metadata, this.operations);
        Hash storeHash = this.store.hashOnReference((NamedRef)branchName, Optional.empty());
        Assertions.assertEquals((Object)storeHash, (Object)commitHash);
        return commitHash;
    }
}

