/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.RefLogDetails;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RefLogDetails", generator="Immutables")
@Immutable
public final class ImmutableRefLogDetails
implements RefLogDetails {
    private final Hash refLogId;
    private final String refName;
    private final String refType;
    private final Hash commitHash;
    private final Hash parentRefLogId;
    private final long operationTime;
    private final String operation;
    private final ImmutableList<Hash> sourceHashes;

    private ImmutableRefLogDetails(Hash refLogId, String refName, String refType, Hash commitHash, Hash parentRefLogId, long operationTime, String operation, ImmutableList<Hash> sourceHashes) {
        this.refLogId = refLogId;
        this.refName = refName;
        this.refType = refType;
        this.commitHash = commitHash;
        this.parentRefLogId = parentRefLogId;
        this.operationTime = operationTime;
        this.operation = operation;
        this.sourceHashes = sourceHashes;
    }

    @Override
    public Hash getRefLogId() {
        return this.refLogId;
    }

    @Override
    public String getRefName() {
        return this.refName;
    }

    @Override
    public String getRefType() {
        return this.refType;
    }

    @Override
    public Hash getCommitHash() {
        return this.commitHash;
    }

    @Override
    public Hash getParentRefLogId() {
        return this.parentRefLogId;
    }

    @Override
    public long getOperationTime() {
        return this.operationTime;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    public ImmutableList<Hash> getSourceHashes() {
        return this.sourceHashes;
    }

    public final ImmutableRefLogDetails withRefLogId(Hash value) {
        if (this.refLogId == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "refLogId");
        return new ImmutableRefLogDetails(newValue, this.refName, this.refType, this.commitHash, this.parentRefLogId, this.operationTime, this.operation, this.sourceHashes);
    }

    public final ImmutableRefLogDetails withRefName(String value) {
        String newValue = Objects.requireNonNull(value, "refName");
        if (this.refName.equals(newValue)) {
            return this;
        }
        return new ImmutableRefLogDetails(this.refLogId, newValue, this.refType, this.commitHash, this.parentRefLogId, this.operationTime, this.operation, this.sourceHashes);
    }

    public final ImmutableRefLogDetails withRefType(String value) {
        String newValue = Objects.requireNonNull(value, "refType");
        if (this.refType.equals(newValue)) {
            return this;
        }
        return new ImmutableRefLogDetails(this.refLogId, this.refName, newValue, this.commitHash, this.parentRefLogId, this.operationTime, this.operation, this.sourceHashes);
    }

    public final ImmutableRefLogDetails withCommitHash(Hash value) {
        if (this.commitHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "commitHash");
        return new ImmutableRefLogDetails(this.refLogId, this.refName, this.refType, newValue, this.parentRefLogId, this.operationTime, this.operation, this.sourceHashes);
    }

    public final ImmutableRefLogDetails withParentRefLogId(Hash value) {
        if (this.parentRefLogId == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "parentRefLogId");
        return new ImmutableRefLogDetails(this.refLogId, this.refName, this.refType, this.commitHash, newValue, this.operationTime, this.operation, this.sourceHashes);
    }

    public final ImmutableRefLogDetails withOperationTime(long value) {
        if (this.operationTime == value) {
            return this;
        }
        return new ImmutableRefLogDetails(this.refLogId, this.refName, this.refType, this.commitHash, this.parentRefLogId, value, this.operation, this.sourceHashes);
    }

    public final ImmutableRefLogDetails withOperation(String value) {
        String newValue = Objects.requireNonNull(value, "operation");
        if (this.operation.equals(newValue)) {
            return this;
        }
        return new ImmutableRefLogDetails(this.refLogId, this.refName, this.refType, this.commitHash, this.parentRefLogId, this.operationTime, newValue, this.sourceHashes);
    }

    public final ImmutableRefLogDetails withSourceHashes(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRefLogDetails(this.refLogId, this.refName, this.refType, this.commitHash, this.parentRefLogId, this.operationTime, this.operation, (ImmutableList<Hash>)newValue);
    }

    public final ImmutableRefLogDetails withSourceHashes(Iterable<? extends Hash> elements) {
        if (this.sourceHashes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRefLogDetails(this.refLogId, this.refName, this.refType, this.commitHash, this.parentRefLogId, this.operationTime, this.operation, (ImmutableList<Hash>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefLogDetails && this.equalTo(0, (ImmutableRefLogDetails)another);
    }

    private boolean equalTo(int synthetic, ImmutableRefLogDetails another) {
        return this.refLogId.equals(another.refLogId) && this.refName.equals(another.refName) && this.refType.equals(another.refType) && this.commitHash.equals(another.commitHash) && this.parentRefLogId.equals(another.parentRefLogId) && this.operationTime == another.operationTime && this.operation.equals(another.operation) && this.sourceHashes.equals(another.sourceHashes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.refLogId.hashCode();
        h += (h << 5) + this.refName.hashCode();
        h += (h << 5) + this.refType.hashCode();
        h += (h << 5) + this.commitHash.hashCode();
        h += (h << 5) + this.parentRefLogId.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.operationTime);
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + this.sourceHashes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RefLogDetails").omitNullValues().add("refLogId", (Object)this.refLogId).add("refName", (Object)this.refName).add("refType", (Object)this.refType).add("commitHash", (Object)this.commitHash).add("parentRefLogId", (Object)this.parentRefLogId).add("operationTime", this.operationTime).add("operation", (Object)this.operation).add("sourceHashes", this.sourceHashes).toString();
    }

    public static ImmutableRefLogDetails copyOf(RefLogDetails instance) {
        if (instance instanceof ImmutableRefLogDetails) {
            return (ImmutableRefLogDetails)instance;
        }
        return ImmutableRefLogDetails.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RefLogDetails", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REF_LOG_ID = 1L;
        private static final long INIT_BIT_REF_NAME = 2L;
        private static final long INIT_BIT_REF_TYPE = 4L;
        private static final long INIT_BIT_COMMIT_HASH = 8L;
        private static final long INIT_BIT_PARENT_REF_LOG_ID = 16L;
        private static final long INIT_BIT_OPERATION_TIME = 32L;
        private static final long INIT_BIT_OPERATION = 64L;
        private long initBits = 127L;
        @Nullable
        private Hash refLogId;
        @Nullable
        private String refName;
        @Nullable
        private String refType;
        @Nullable
        private Hash commitHash;
        @Nullable
        private Hash parentRefLogId;
        private long operationTime;
        @Nullable
        private String operation;
        private ImmutableList.Builder<Hash> sourceHashes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RefLogDetails instance) {
            Objects.requireNonNull(instance, "instance");
            this.refLogId(instance.getRefLogId());
            this.refName(instance.getRefName());
            this.refType(instance.getRefType());
            this.commitHash(instance.getCommitHash());
            this.parentRefLogId(instance.getParentRefLogId());
            this.operationTime(instance.getOperationTime());
            this.operation(instance.getOperation());
            this.addAllSourceHashes(instance.getSourceHashes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refLogId(Hash refLogId) {
            this.refLogId = Objects.requireNonNull(refLogId, "refLogId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refName(String refName) {
            this.refName = Objects.requireNonNull(refName, "refName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refType(String refType) {
            this.refType = Objects.requireNonNull(refType, "refType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitHash(Hash commitHash) {
            this.commitHash = Objects.requireNonNull(commitHash, "commitHash");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentRefLogId(Hash parentRefLogId) {
            this.parentRefLogId = Objects.requireNonNull(parentRefLogId, "parentRefLogId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder operationTime(long operationTime) {
            this.operationTime = operationTime;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder operation(String operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSourceHashes(Hash element) {
            this.sourceHashes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSourceHashes(Hash ... elements) {
            this.sourceHashes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceHashes(Iterable<? extends Hash> elements) {
            this.sourceHashes = ImmutableList.builder();
            return this.addAllSourceHashes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSourceHashes(Iterable<? extends Hash> elements) {
            this.sourceHashes.addAll(elements);
            return this;
        }

        public ImmutableRefLogDetails build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefLogDetails(this.refLogId, this.refName, this.refType, this.commitHash, this.parentRefLogId, this.operationTime, this.operation, this.sourceHashes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("refLogId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("refName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("refType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("commitHash");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("parentRefLogId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("operationTime");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("operation");
            }
            return "Cannot build RefLogDetails, some of required attributes are not set " + attributes;
        }
    }
}

