/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.ContentAttachmentKey;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentAttachmentKey", generator="Immutables")
@Immutable
public final class ImmutableContentAttachmentKey
implements ContentAttachmentKey {
    private final String contentId;
    private final String attachmentType;
    private final String attachmentId;

    private ImmutableContentAttachmentKey(String contentId, String attachmentType, String attachmentId) {
        this.contentId = contentId;
        this.attachmentType = attachmentType;
        this.attachmentId = attachmentId;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    public String getAttachmentId() {
        return this.attachmentId;
    }

    public final ImmutableContentAttachmentKey withContentId(String value) {
        String newValue = Objects.requireNonNull(value, "contentId");
        if (this.contentId.equals(newValue)) {
            return this;
        }
        return ImmutableContentAttachmentKey.validate(new ImmutableContentAttachmentKey(newValue, this.attachmentType, this.attachmentId));
    }

    public final ImmutableContentAttachmentKey withAttachmentType(String value) {
        String newValue = Objects.requireNonNull(value, "attachmentType");
        if (this.attachmentType.equals(newValue)) {
            return this;
        }
        return ImmutableContentAttachmentKey.validate(new ImmutableContentAttachmentKey(this.contentId, newValue, this.attachmentId));
    }

    public final ImmutableContentAttachmentKey withAttachmentId(String value) {
        String newValue = Objects.requireNonNull(value, "attachmentId");
        if (this.attachmentId.equals(newValue)) {
            return this;
        }
        return ImmutableContentAttachmentKey.validate(new ImmutableContentAttachmentKey(this.contentId, this.attachmentType, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentAttachmentKey && this.equalTo(0, (ImmutableContentAttachmentKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentAttachmentKey another) {
        return this.contentId.equals(another.contentId) && this.attachmentType.equals(another.attachmentType) && this.attachmentId.equals(another.attachmentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.contentId.hashCode();
        h += (h << 5) + this.attachmentType.hashCode();
        h += (h << 5) + this.attachmentId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentAttachmentKey").omitNullValues().add("contentId", (Object)this.contentId).add("attachmentType", (Object)this.attachmentType).add("attachmentId", (Object)this.attachmentId).toString();
    }

    private static ImmutableContentAttachmentKey validate(ImmutableContentAttachmentKey instance) {
        instance.check();
        return instance;
    }

    public static ImmutableContentAttachmentKey copyOf(ContentAttachmentKey instance) {
        if (instance instanceof ImmutableContentAttachmentKey) {
            return (ImmutableContentAttachmentKey)instance;
        }
        return ImmutableContentAttachmentKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentAttachmentKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_ID = 1L;
        private static final long INIT_BIT_ATTACHMENT_TYPE = 2L;
        private static final long INIT_BIT_ATTACHMENT_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private String contentId;
        @Nullable
        private String attachmentType;
        @Nullable
        private String attachmentId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentAttachmentKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.contentId(instance.getContentId());
            this.attachmentType(instance.getAttachmentType());
            this.attachmentId(instance.getAttachmentId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(String contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attachmentType(String attachmentType) {
            this.attachmentType = Objects.requireNonNull(attachmentType, "attachmentType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = Objects.requireNonNull(attachmentId, "attachmentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableContentAttachmentKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableContentAttachmentKey.validate(new ImmutableContentAttachmentKey(this.contentId, this.attachmentType, this.attachmentId));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("attachmentType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("attachmentId");
            }
            return "Cannot build ContentAttachmentKey, some of required attributes are not set " + attributes;
        }
    }
}

