/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.store;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.store.ContentSerializer;
import org.projectnessie.versioned.store.ContentSerializerBundle;

public class DefaultStoreWorker
implements StoreWorker {
    public static StoreWorker instance() {
        return Lazy.INSTANCE;
    }

    public static byte payloadForContent(Content c) {
        return DefaultStoreWorker.serializer(c).payload();
    }

    public static byte payloadForContent(Content.Type contentType) {
        return DefaultStoreWorker.serializer(contentType).payload();
    }

    public static Content.Type contentTypeForPayload(byte payload) {
        Content.Type contentType;
        Content.Type type = contentType = payload >= 0 && payload < Registry.BY_PAYLOAD.length ? Registry.BY_PAYLOAD[payload].contentType() : null;
        if (contentType == null) {
            throw new IllegalArgumentException("Unknown payload " + payload);
        }
        return contentType;
    }

    @Nonnull
    private static <C extends Content> ContentSerializer<C> serializer(C content) {
        return DefaultStoreWorker.serializer(content.getType());
    }

    @Nonnull
    private static <C extends Content> ContentSerializer<C> serializer(Content.Type contentType) {
        ContentSerializer serializer = (ContentSerializer)Registry.BY_TYPE.get(contentType);
        if (serializer == null) {
            throw new IllegalArgumentException("No type registered for " + contentType);
        }
        return serializer;
    }

    @Nonnull
    private static <C extends Content> ContentSerializer<C> serializer(byte payload) {
        ContentSerializer serializer;
        ContentSerializer contentSerializer = serializer = payload >= 0 && payload < Registry.BY_PAYLOAD.length ? Registry.BY_PAYLOAD[payload] : null;
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown payload " + payload);
        }
        return serializer;
    }

    @Override
    public ByteString toStoreOnReferenceState(Content content, Consumer<ContentAttachment> attachmentConsumer) {
        return DefaultStoreWorker.serializer(content).toStoreOnReferenceState(content, attachmentConsumer);
    }

    @Override
    public Content applyId(Content content, String id) {
        return DefaultStoreWorker.serializer(content).applyId(content, id);
    }

    @Override
    public boolean requiresGlobalState(Content content) {
        return DefaultStoreWorker.serializer(content).requiresGlobalState(content);
    }

    @Override
    public Content valueFromStore(byte payload, ByteString onReferenceValue, Supplier<ByteString> globalState, Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> attachmentsRetriever) {
        return DefaultStoreWorker.serializer(payload).valueFromStore(payload, onReferenceValue, globalState, attachmentsRetriever);
    }

    @Override
    public boolean requiresGlobalState(byte payload, ByteString onReferenceValue) {
        return DefaultStoreWorker.serializer(payload).requiresGlobalState(onReferenceValue);
    }

    @Override
    public Content.Type getType(byte payload, ByteString onReferenceValue) {
        return DefaultStoreWorker.serializer(payload).getType(onReferenceValue);
    }

    private static final class Registry {
        private static final ContentSerializer<?>[] BY_PAYLOAD;
        private static final Map<Content.Type, ContentSerializer<?>> BY_TYPE;

        private Registry() {
        }

        static {
            HashMap byName = new HashMap();
            HashMap byType = new HashMap();
            ArrayList byPayload = new ArrayList();
            for (ContentSerializerBundle bundle : ServiceLoader.load(ContentSerializerBundle.class)) {
                bundle.register(contentTypeSerializer -> {
                    Content.Type contentType = contentTypeSerializer.contentType();
                    if (byName.put(contentType.name(), contentTypeSerializer) != null) {
                        throw new IllegalStateException("Found more than one ContentTypeSerializer for name " + contentType.name());
                    }
                    if (contentTypeSerializer.payload() != 0 && byType.put(contentType, (ContentSerializer<?>)contentTypeSerializer) != null) {
                        throw new IllegalStateException("Found more than one ContentTypeSerializer for content type " + contentType.type());
                    }
                    while (byPayload.size() <= contentTypeSerializer.payload()) {
                        byPayload.add(null);
                    }
                    if (byPayload.set(contentTypeSerializer.payload(), contentTypeSerializer) != null) {
                        throw new IllegalStateException("Found more than one ContentTypeSerializer for content payload " + contentTypeSerializer.payload());
                    }
                });
            }
            BY_PAYLOAD = byPayload.toArray(new ContentSerializer[0]);
            BY_TYPE = byType;
        }
    }

    private static final class Lazy {
        private static final DefaultStoreWorker INSTANCE = new DefaultStoreWorker();

        private Lazy() {
        }
    }
}

