/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.tx.DefaultTxConnectionConfig;
import org.projectnessie.versioned.persist.tx.TxConnectionConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DefaultTxConnectionConfig", generator="Immutables")
@Immutable
public final class ImmutableDefaultTxConnectionConfig
implements DefaultTxConnectionConfig {
    @Nullable
    private final String catalog;
    @Nullable
    private final String schema;

    private ImmutableDefaultTxConnectionConfig(@Nullable String catalog, @Nullable String schema) {
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    @Nullable
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Nullable
    public String getSchema() {
        return this.schema;
    }

    @Override
    public final ImmutableDefaultTxConnectionConfig withCatalog(@Nullable String value) {
        if (Objects.equals(this.catalog, value)) {
            return this;
        }
        return new ImmutableDefaultTxConnectionConfig(value, this.schema);
    }

    @Override
    public final ImmutableDefaultTxConnectionConfig withSchema(@Nullable String value) {
        if (Objects.equals(this.schema, value)) {
            return this;
        }
        return new ImmutableDefaultTxConnectionConfig(this.catalog, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultTxConnectionConfig && this.equalTo(0, (ImmutableDefaultTxConnectionConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableDefaultTxConnectionConfig another) {
        return Objects.equals(this.catalog, another.catalog) && Objects.equals(this.schema, another.schema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.catalog);
        h += (h << 5) + Objects.hashCode(this.schema);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefaultTxConnectionConfig").omitNullValues().add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).toString();
    }

    public static ImmutableDefaultTxConnectionConfig copyOf(DefaultTxConnectionConfig instance) {
        if (instance instanceof ImmutableDefaultTxConnectionConfig) {
            return (ImmutableDefaultTxConnectionConfig)instance;
        }
        return ImmutableDefaultTxConnectionConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DefaultTxConnectionConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String catalog;
        @Nullable
        private String schema;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultTxConnectionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TxConnectionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String catalogValue;
            String schemaValue;
            TxConnectionConfig instance;
            long bits = 0L;
            if (object instanceof DefaultTxConnectionConfig) {
                instance = (DefaultTxConnectionConfig)object;
                if ((bits & 1L) == 0L) {
                    schemaValue = instance.getSchema();
                    if (schemaValue != null) {
                        this.schema(schemaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    catalogValue = instance.getCatalog();
                    if (catalogValue != null) {
                        this.catalog(catalogValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof TxConnectionConfig) {
                instance = (TxConnectionConfig)object;
                if ((bits & 1L) == 0L) {
                    schemaValue = instance.getSchema();
                    if (schemaValue != null) {
                        this.schema(schemaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    catalogValue = instance.getCatalog();
                    if (catalogValue != null) {
                        this.catalog(catalogValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder catalog(@Nullable String catalog) {
            this.catalog = catalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schema(@Nullable String schema) {
            this.schema = schema;
            return this;
        }

        public ImmutableDefaultTxConnectionConfig build() {
            return new ImmutableDefaultTxConnectionConfig(this.catalog, this.schema);
        }
    }
}

