/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UnsafeByteOperations;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.adapter.RepoMaintenanceParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.persist.adapter.events.AdapterEvent;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.events.CommitEvent;
import org.projectnessie.versioned.persist.adapter.events.MergeEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceAssignedEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceCreatedEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceDeletedEvent;
import org.projectnessie.versioned.persist.adapter.events.RepositoryErasedEvent;
import org.projectnessie.versioned.persist.adapter.events.RepositoryInitializedEvent;
import org.projectnessie.versioned.persist.adapter.events.TransplantEvent;
import org.projectnessie.versioned.persist.adapter.serialize.ProtoSerialization;
import org.projectnessie.versioned.persist.adapter.spi.AbstractDatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.adapter.spi.Traced;
import org.projectnessie.versioned.persist.adapter.spi.TryLoopState;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.projectnessie.versioned.persist.tx.ConnectionWrapper;
import org.projectnessie.versioned.persist.tx.ImmutableRefLogHead;
import org.projectnessie.versioned.persist.tx.JdbcSelectSpliterator;
import org.projectnessie.versioned.persist.tx.RefLogHead;
import org.projectnessie.versioned.persist.tx.RetryTransactionException;
import org.projectnessie.versioned.persist.tx.SqlStatements;
import org.projectnessie.versioned.persist.tx.TxConnectionProvider;
import org.projectnessie.versioned.persist.tx.TxDatabaseAdapterConfig;

public abstract class TxDatabaseAdapter
extends AbstractDatabaseAdapter<ConnectionWrapper, TxDatabaseAdapterConfig> {
    protected static final String REF_TYPE_BRANCH = "b";
    protected static final String REF_TYPE_TAG = "t";
    private final TxConnectionProvider<?> db;
    protected static final String DEADLOCK_SQL_STATE_POSTGRES = "40P01";
    protected static final String RETRY_SQL_STATE_COCKROACH = "40001";
    protected static final String CONSTRAINT_VIOLATION_SQL_STATE = "23505";
    protected static final int CONSTRAINT_VIOLATION_SQL_CODE = 23505;

    public TxDatabaseAdapter(TxDatabaseAdapterConfig config, TxConnectionProvider<?> db, AdapterEventConsumer eventConsumer) {
        super((DatabaseAdapterConfig)config, eventConsumer);
        Objects.requireNonNull(db, "TxDatabaseAdapter requires a non-null TxConnectionProvider via TxDatabaseAdapterConfig.getConnectionProvider()");
        this.db = db;
        db.setupDatabase(this);
    }

    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        try (ConnectionWrapper conn = this.borrowConnection();){
            Hash hash = this.hashOnRef(conn, namedReference, hashOnReference);
            return hash;
        }
    }

    public Map<Key, ContentAndState> values(Hash commit, Collection<Key> keys, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        try (ConnectionWrapper conn = this.borrowConnection();){
            Map map = this.fetchValues(conn, commit, keys, keyFilter);
            return map;
        }
    }

    @MustBeClosed
    public Stream<CommitLogEntry> commitLog(Hash offset) throws ReferenceNotFoundException {
        return this.withConnectionWrapper(conn -> this.readCommitLogStream(conn, offset));
    }

    public ReferenceInfo<ByteString> namedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameter for GetNamedRefsParams must not be null");
        try (ConnectionWrapper conn = this.borrowConnection();){
            ReferenceInfo referenceInfo;
            block12: {
                ReferenceInfo<ByteString> refInfo = this.fetchNamedRef(conn, ref);
                Hash defaultBranchHead = this.namedRefsDefaultBranchHead(conn, params);
                Stream<ReferenceInfo<ByteString>> refs = Stream.of(refInfo);
                Stream namedRefs = this.namedRefsFilterAndEnhance(conn, params, defaultBranchHead, refs);
                try {
                    referenceInfo = (ReferenceInfo)namedRefs.findFirst().orElseThrow(() -> DatabaseAdapterUtil.referenceNotFound((String)ref));
                    if (namedRefs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (namedRefs != null) {
                        try {
                            namedRefs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                namedRefs.close();
            }
            return referenceInfo;
        }
    }

    @MustBeClosed
    public Stream<ReferenceInfo<ByteString>> namedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameter for GetNamedRefsParams must not be null.");
        Preconditions.checkArgument((boolean)TxDatabaseAdapter.namedRefsAnyRetrieves((GetNamedRefsParams)params), (Object)"Must retrieve branches or tags or both.");
        return this.withConnectionWrapper(conn -> {
            Hash defaultBranchHead = this.namedRefsDefaultBranchHead(conn, params);
            Stream<ReferenceInfo<ByteString>> refs = this.fetchNamedRefs(conn);
            return this.namedRefsFilterAndEnhance(conn, params, defaultBranchHead, refs);
        });
    }

    @MustBeClosed
    public Stream<KeyListEntry> keys(Hash commit, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.withConnectionWrapper(conn -> this.keysForCommitEntry(conn, commit, keyFilter));
    }

    public MergeResult<CommitLogEntry> merge(MergeParams mergeParams) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            AtomicReference mergeResultHolder = new AtomicReference();
            Hash result = this.opLoop("merge", (NamedRef)mergeParams.getToBranch(), false, (conn, currentHead) -> {
                long timeInMicros = ((TxDatabaseAdapterConfig)this.config).currentTimeInMicros();
                ImmutableMergeResult.Builder mergeResult = MergeResult.builder();
                mergeResultHolder.set(mergeResult);
                ArrayList writtenCommits = new ArrayList();
                Hash toHead = this.mergeAttempt(conn, timeInMicros, currentHead, h -> {}, h -> {}, writtenCommits::add, mergeParams, mergeResult);
                if (toHead.equals(currentHead)) {
                    return OpResult.opResult(currentHead, null);
                }
                Hash resultHash = this.tryMoveNamedReference(conn, (NamedRef)mergeParams.getToBranch(), currentHead, toHead);
                return OpResult.opResult(resultHash, () -> ((MergeEvent.Builder)((MergeEvent.Builder)((MergeEvent.Builder)MergeEvent.builder().previousHash(currentHead)).hash(resultHash)).branch(mergeParams.getToBranch())).commits((Iterable)writtenCommits));
            }, () -> DatabaseAdapterUtil.mergeConflictMessage((String)"Conflict", (MergeParams)mergeParams), () -> DatabaseAdapterUtil.mergeConflictMessage((String)"Retry-failure", (MergeParams)mergeParams));
            ImmutableMergeResult.Builder mergeResult = Objects.requireNonNull((ImmutableMergeResult.Builder)mergeResultHolder.get(), "Internal error, merge-result builder not set.");
            if (!mergeParams.isDryRun()) {
                mergeResult.wasApplied(true);
            }
            return mergeResult.resultantTargetHash(result).build();
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MergeResult<CommitLogEntry> transplant(TransplantParams transplantParams) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            AtomicReference mergeResultHolder = new AtomicReference();
            Hash result = this.opLoop("transplant", (NamedRef)transplantParams.getToBranch(), false, (conn, currentHead) -> {
                long timeInMicros = ((TxDatabaseAdapterConfig)this.config).currentTimeInMicros();
                ImmutableMergeResult.Builder mergeResult = MergeResult.builder();
                mergeResultHolder.set(mergeResult);
                ArrayList writtenCommits = new ArrayList();
                Hash targetHead = this.transplantAttempt(conn, timeInMicros, currentHead, h -> {}, h -> {}, writtenCommits::add, transplantParams, mergeResult);
                Hash resultHash = this.tryMoveNamedReference(conn, (NamedRef)transplantParams.getToBranch(), currentHead, targetHead);
                return OpResult.opResult(resultHash, () -> ((TransplantEvent.Builder)((TransplantEvent.Builder)((TransplantEvent.Builder)TransplantEvent.builder().previousHash(currentHead)).hash(resultHash)).branch(transplantParams.getToBranch())).commits((Iterable)writtenCommits));
            }, () -> DatabaseAdapterUtil.transplantConflictMessage((String)"Conflict", (TransplantParams)transplantParams), () -> DatabaseAdapterUtil.transplantConflictMessage((String)"Retry-failure", (TransplantParams)transplantParams));
            ImmutableMergeResult.Builder mergeResult = Objects.requireNonNull((ImmutableMergeResult.Builder)mergeResultHolder.get(), "Internal error, merge-result builder not set.");
            if (!transplantParams.isDryRun()) {
                mergeResult.wasApplied(true);
            }
            return mergeResult.resultantTargetHash(result).build();
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Hash commit(CommitParams commitParams) throws ReferenceConflictException, ReferenceNotFoundException {
        try {
            return this.opLoop("commit", (NamedRef)commitParams.getToBranch(), false, (conn, branchHead) -> {
                long timeInMicros = ((TxDatabaseAdapterConfig)this.config).currentTimeInMicros();
                CommitLogEntry newBranchCommit = this.commitAttempt(conn, timeInMicros, branchHead, commitParams, h -> {});
                Hash resultHash = this.tryMoveNamedReference(conn, (NamedRef)commitParams.getToBranch(), branchHead, newBranchCommit.getHash());
                return OpResult.opResult(resultHash, () -> ((CommitEvent.Builder)((CommitEvent.Builder)((CommitEvent.Builder)CommitEvent.builder().previousHash(branchHead)).hash(resultHash)).branch(commitParams.getToBranch())).addCommits(newBranchCommit));
            }, () -> DatabaseAdapterUtil.commitConflictMessage((String)"Conflict", (BranchName)commitParams.getToBranch(), (Optional)commitParams.getExpectedHead()), () -> DatabaseAdapterUtil.commitConflictMessage((String)"Retry-Failure", (BranchName)commitParams.getToBranch(), (Optional)commitParams.getExpectedHead()));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Hash create(NamedRef ref, Hash target) throws ReferenceAlreadyExistsException, ReferenceNotFoundException {
        try {
            return this.opLoop("createRef", ref, true, (conn, nullHead) -> {
                if (this.checkNamedRefExistence(conn, ref.getName())) {
                    throw DatabaseAdapterUtil.referenceAlreadyExists((NamedRef)ref);
                }
                Hash hash = target != null ? target : NO_ANCESTOR;
                this.validateHashExists(conn, hash);
                this.insertNewReference(conn, ref, hash);
                this.commitRefLog(conn, ((TxDatabaseAdapterConfig)this.config).currentTimeInMicros(), hash, ref, AdapterTypes.RefLogEntry.Operation.CREATE_REFERENCE, Collections.emptyList());
                return OpResult.opResult(hash, () -> ((ReferenceCreatedEvent.Builder)ReferenceCreatedEvent.builder().currentHash(hash)).ref(ref));
            }, () -> DatabaseAdapterUtil.createConflictMessage((String)"Conflict", (NamedRef)ref, (Hash)target), () -> DatabaseAdapterUtil.createConflictMessage((String)"Retry-Failure", (NamedRef)ref, (Hash)target));
        }
        catch (RuntimeException | ReferenceAlreadyExistsException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(NamedRef reference, Optional<Hash> expectedHead) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            this.opLoop("deleteRef", reference, false, (conn, pointer) -> {
                DatabaseAdapterUtil.verifyExpectedHash((Hash)pointer, (NamedRef)reference, (Optional)expectedHead);
                Hash commitHash = this.fetchNamedRefHead(conn, reference);
                try (Traced ignore = Traced.trace((String)"deleteRefInDb");
                     PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.DELETE_NAMED_REFERENCE);){
                    ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                    ps.setString(2, reference.getName());
                    ps.setString(3, pointer.asString());
                    if (ps.executeUpdate() != 1) {
                        OpResult opResult = null;
                        return opResult;
                    }
                }
                this.commitRefLog(conn, ((TxDatabaseAdapterConfig)this.config).currentTimeInMicros(), commitHash, reference, AdapterTypes.RefLogEntry.Operation.DELETE_REFERENCE, Collections.emptyList());
                return OpResult.opResult(pointer, () -> ((ReferenceDeletedEvent.Builder)ReferenceDeletedEvent.builder().currentHash(commitHash)).ref(reference));
            }, () -> DatabaseAdapterUtil.deleteConflictMessage((String)"Conflict", (NamedRef)reference, (Optional)expectedHead), () -> DatabaseAdapterUtil.deleteConflictMessage((String)"Retry-Failure", (NamedRef)reference, (Optional)expectedHead));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assign(NamedRef assignee, Optional<Hash> expectedHead, Hash assignTo) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            this.opLoop("assignRef", assignee, false, (conn, assigneeHead) -> {
                DatabaseAdapterUtil.verifyExpectedHash((Hash)assigneeHead, (NamedRef)assignee, (Optional)expectedHead);
                this.validateHashExists(conn, assignTo);
                Hash resultHash = this.tryMoveNamedReference(conn, assignee, assigneeHead, assignTo);
                this.commitRefLog(conn, ((TxDatabaseAdapterConfig)this.config).currentTimeInMicros(), assignTo, assignee, AdapterTypes.RefLogEntry.Operation.ASSIGN_REFERENCE, Collections.singletonList(assigneeHead));
                return OpResult.opResult(resultHash, () -> ((ReferenceAssignedEvent.Builder)((ReferenceAssignedEvent.Builder)ReferenceAssignedEvent.builder().currentHash(assignTo)).ref(assignee)).previousHash(assigneeHead));
            }, () -> DatabaseAdapterUtil.assignConflictMessage((String)"Conflict", (NamedRef)assignee, (Optional)expectedHead, (Hash)assignTo), () -> DatabaseAdapterUtil.assignConflictMessage((String)"Retry-Failure", (NamedRef)assignee, (Optional)expectedHead, (Hash)assignTo));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @MustBeClosed
    public Stream<Difference> diff(Hash from, Hash to, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.withConnectionWrapper(conn -> this.buildDiff(conn, from, to, keyFilter));
    }

    public void initializeRepo(String defaultBranchName) {
        try (ConnectionWrapper conn = this.borrowConnection();){
            BranchName defaultBranch = BranchName.of((String)defaultBranchName);
            if (!this.checkNamedRefExistence(conn, (NamedRef)defaultBranch)) {
                this.insertNewReference(conn, (NamedRef)defaultBranch, NO_ANCESTOR);
                AdapterTypes.RefLogEntry newRefLog = this.writeRefLogEntry(conn, (NamedRef)defaultBranch, RefLogHead.builder().refLogHead(NO_ANCESTOR).addRefLogParentsInclHead(NO_ANCESTOR).build(), NO_ANCESTOR, AdapterTypes.RefLogEntry.Operation.CREATE_REFERENCE, ((TxDatabaseAdapterConfig)this.config).currentTimeInMicros(), Collections.emptyList());
                this.insertRefLogHead(newRefLog, conn);
                conn.commit();
                this.repositoryEvent(() -> RepositoryInitializedEvent.builder().defaultBranch(defaultBranchName));
                this.repositoryEvent(() -> ((ReferenceCreatedEvent.Builder)ReferenceCreatedEvent.builder().ref((NamedRef)defaultBranch)).currentHash(NO_ANCESTOR));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void eraseRepo() {
        try (ConnectionWrapper conn = this.borrowConnection();){
            try (PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.DELETE_NAMED_REFERENCE_ALL);){
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            ps = conn.conn().prepareStatement(SqlStatements.DELETE_GLOBAL_STATE_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.conn().prepareStatement(SqlStatements.DELETE_COMMIT_LOG_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.conn().prepareStatement(SqlStatements.DELETE_KEY_LIST_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.conn().prepareStatement(SqlStatements.DELETE_REF_LOG_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.conn().prepareStatement(SqlStatements.DELETE_REF_LOG_HEAD_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.conn().prepareStatement(SqlStatements.DELETE_REPO_DESCRIPTIONE_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = conn.conn().prepareStatement(SqlStatements.DELETE_ATTACHMENTS_ALL);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            conn.commit();
            this.repositoryEvent(RepositoryErasedEvent::builder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<ContentIdAndBytes> globalContent(ContentId contentId) {
        try (ConnectionWrapper conn = this.borrowConnection();){
            try (Traced ignore = Traced.trace((String)"globalContent");
                 PreparedStatement ps = conn.conn().prepareStatement(String.format(SqlStatements.SELECT_GLOBAL_STATE_MANY, "?"));){
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(2, contentId.getId());
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        Optional<ContentIdAndBytes> optional = Optional.of(TxDatabaseAdapter.globalContentFromRow(rs));
                        return optional;
                    }
                }
            }
            Optional<ContentIdAndBytes> optional = Optional.empty();
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @MustBeClosed
    public Stream<RefLog> refLog(Hash offset) throws RefLogNotFoundException {
        return this.withConnectionWrapper(conn -> this.readRefLogStream(conn, offset));
    }

    public Map<String, Map<String, String>> repoMaintenance(RepoMaintenanceParams repoMaintenanceParams) {
        return Collections.emptyMap();
    }

    public void assertCleanStateForTests() {
        if (ConnectionWrapper.threadHasOpenConnection()) {
            try {
                throw new IllegalStateException("Current thread has unclosed database connection");
            }
            catch (Throwable throwable) {
                ConnectionWrapper.borrow(() -> null).forceClose();
                throw throwable;
            }
        }
    }

    private static ContentIdAndBytes globalContentFromRow(ResultSet rs) throws SQLException {
        ContentId cid = ContentId.of((String)rs.getString(1));
        ByteString value = UnsafeByteOperations.unsafeWrap((byte[])rs.getBytes(2));
        return ContentIdAndBytes.of((ContentId)cid, (ByteString)value);
    }

    public void writeMultipleCommits(List<CommitLogEntry> commitLogEntries) throws ReferenceConflictException {
        try (ConnectionWrapper conn = this.borrowConnection();){
            this.doWriteMultipleCommits(conn, commitLogEntries);
            conn.commit();
        }
    }

    public void updateMultipleCommits(List<CommitLogEntry> commitLogEntries) throws ReferenceNotFoundException {
        try (ConnectionWrapper conn = this.borrowConnection();){
            this.doUpdateMultipleCommits(conn, commitLogEntries);
            conn.commit();
        }
    }

    protected Hash hashOnRef(ConnectionWrapper conn, NamedRef reference, Optional<Hash> hashOnRef) throws ReferenceNotFoundException {
        return this.hashOnRef(conn, reference, hashOnRef, this.fetchNamedRefHead(conn, reference));
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyListEntry entry) {
        return ProtoSerialization.toProto((KeyListEntry)entry).getSerializedSize();
    }

    public ConnectionWrapper borrowConnection() {
        return ConnectionWrapper.borrow(this::newConnection);
    }

    protected Connection newConnection() {
        try {
            return this.db.borrowConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected Hash opLoop(String opName, NamedRef namedReference, boolean createRef, LoopOp loopOp, Supplier<String> conflictErrorMessage, Supplier<String> retryErrorMessage) throws VersionStoreException {
        try (ConnectionWrapper conn = this.borrowConnection();
             TryLoopState tryState = TryLoopState.newTryLoopState((String)opName, ts -> String.format("%s after %d retries, %d ms", retryErrorMessage.get(), ts.getRetries(), ts.getDuration(TimeUnit.MILLISECONDS)), (arg_0, arg_1) -> ((TxDatabaseAdapter)this).tryLoopStateCompletion(arg_0, arg_1), (DatabaseAdapterConfig)this.config);){
            while (true) {
                Hash pointer = createRef ? null : this.fetchNamedRefHead(conn, namedReference);
                try {
                    OpResult opResult = loopOp.apply(conn, pointer);
                    this.repositoryEvent(opResult.adapterEventBuilder);
                    if (opResult.head != null) {
                        conn.commit();
                        Hash hash = tryState.success(opResult.head);
                        return hash;
                    }
                }
                catch (RetryTransactionException e) {
                    conn.rollback();
                    tryState.retry();
                    continue;
                }
                catch (SQLException e) {
                    if (this.isRetryTransaction(e)) {
                        conn.rollback();
                        tryState.retry();
                        continue;
                    }
                    this.throwIfReferenceConflictException(e, conflictErrorMessage);
                    throw new RuntimeException(e);
                }
                conn.rollback();
                tryState.retry();
            }
        }
    }

    @MustBeClosed
    protected Stream<ReferenceInfo<ByteString>> fetchNamedRefs(ConnectionWrapper conn) {
        return JdbcSelectSpliterator.buildStream(conn.conn(), SqlStatements.SELECT_NAMED_REFERENCES, ps -> ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId()), rs -> {
            String type = rs.getString(1);
            String ref = rs.getString(2);
            Hash head = Hash.of((String)rs.getString(3));
            NamedRef namedRef = TxDatabaseAdapter.namedRefFromRow(type, ref);
            if (namedRef != null) {
                return ReferenceInfo.of((Hash)head, (NamedRef)namedRef);
            }
            return null;
        });
    }

    protected boolean checkNamedRefExistence(ConnectionWrapper c, NamedRef ref) {
        try {
            this.fetchNamedRefHead(c, ref);
            return true;
        }
        catch (ReferenceNotFoundException e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean checkNamedRefExistence(ConnectionWrapper c, String refName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Hash fetchNamedRefHead(ConnectionWrapper c, NamedRef ref) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace((String)"fetchNamedRefHead");
             PreparedStatement ps = c.conn().prepareStatement(SqlStatements.SELECT_NAMED_REFERENCE);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, ref.getName());
            ps.setString(3, TxDatabaseAdapter.referenceTypeDiscriminator(ref));
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) throw DatabaseAdapterUtil.referenceNotFound((NamedRef)ref);
                Hash hash = Hash.of((String)rs.getString(1));
                return hash;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReferenceInfo<ByteString> fetchNamedRef(ConnectionWrapper c, String ref) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace((String)"fetchNamedRef");
             PreparedStatement ps = c.conn().prepareStatement(SqlStatements.SELECT_NAMED_REFERENCE_ANY);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, ref);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) throw DatabaseAdapterUtil.referenceNotFound((String)ref);
                Hash hash = Hash.of((String)rs.getString(2));
                NamedRef namedRef = TxDatabaseAdapter.namedRefFromRow(rs.getString(1), ref);
                ReferenceInfo referenceInfo = ReferenceInfo.of((Hash)hash, (NamedRef)namedRef);
                return referenceInfo;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static NamedRef namedRefFromRow(String type, String ref) {
        switch (type) {
            case "b": {
                return BranchName.of((String)ref);
            }
            case "t": {
                return TagName.of((String)ref);
            }
        }
        return null;
    }

    protected void insertNewReference(ConnectionWrapper conn, NamedRef ref, Hash hash) throws ReferenceAlreadyExistsException, SQLException {
        try (Traced ignore = Traced.trace((String)"insertNewReference");
             PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.INSERT_NAMED_REFERENCE);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, ref.getName());
            ps.setString(3, TxDatabaseAdapter.referenceTypeDiscriminator(ref));
            ps.setString(4, hash.asString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            if (this.isIntegrityConstraintViolation(e)) {
                throw DatabaseAdapterUtil.referenceAlreadyExists((NamedRef)ref);
            }
            throw e;
        }
    }

    protected static String referenceTypeDiscriminator(NamedRef ref) {
        String refType;
        if (ref instanceof BranchName) {
            refType = REF_TYPE_BRANCH;
        } else if (ref instanceof TagName) {
            refType = REF_TYPE_TAG;
        } else {
            throw new IllegalArgumentException();
        }
        return refType;
    }

    private Hash namedRefsDefaultBranchHead(ConnectionWrapper conn, GetNamedRefsParams params) throws ReferenceNotFoundException {
        if (TxDatabaseAdapter.namedRefsRequiresBaseReference((GetNamedRefsParams)params)) {
            Preconditions.checkNotNull((Object)params.getBaseReference(), (Object)"Base reference name missing.");
            return this.fetchNamedRefHead(conn, params.getBaseReference());
        }
        return null;
    }

    protected String sqlForManyPlaceholders(String sql, int num) {
        String placeholders = IntStream.range(0, num).mapToObj(x -> "?").collect(Collectors.joining(", "));
        return String.format(sql, placeholders);
    }

    protected Map<ContentId, ByteString> doFetchGlobalStates(ConnectionWrapper conn, Set<ContentId> contentIds) {
        HashMap<ContentId, ByteString> hashMap;
        block18: {
            HashMap<ContentId, ByteString> result = new HashMap<ContentId, ByteString>();
            if (contentIds.isEmpty()) {
                return result;
            }
            String sql = this.sqlForManyPlaceholders(SqlStatements.SELECT_GLOBAL_STATE_MANY, contentIds.size());
            PreparedStatement ps = conn.conn().prepareStatement(sql);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                int i = 2;
                for (ContentId cid : contentIds) {
                    ps.setString(i++, cid.getId());
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        ContentId contentId = ContentId.of((String)rs.getString(1));
                        if (!contentIds.contains(contentId)) continue;
                        byte[] data = rs.getBytes(2);
                        ByteString val = UnsafeByteOperations.unsafeWrap((byte[])data);
                        result.put(contentId, val);
                    }
                }
                hashMap = result;
                if (ps == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return hashMap;
    }

    protected Stream<CommitLogEntry> doScanAllCommitLogEntries(ConnectionWrapper c) {
        return JdbcSelectSpliterator.buildStream(c.conn(), SqlStatements.SELECT_COMMIT_LOG_FULL, ps -> ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId()), rs -> ProtoSerialization.protoToCommitLogEntry((byte[])rs.getBytes(1)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected CommitLogEntry doFetchFromCommitLog(ConnectionWrapper c, Hash hash) {
        try (PreparedStatement ps = c.conn().prepareStatement(SqlStatements.SELECT_COMMIT_LOG);){
            CommitLogEntry commitLogEntry;
            block14: {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(2, hash.asString());
                ResultSet rs = ps.executeQuery();
                try {
                    CommitLogEntry commitLogEntry2 = commitLogEntry = rs.next() ? ProtoSerialization.protoToCommitLogEntry((byte[])rs.getBytes(1)) : null;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return commitLogEntry;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<CommitLogEntry> doFetchMultipleFromCommitLog(ConnectionWrapper c, List<Hash> hashes) {
        List<CommitLogEntry> list;
        block18: {
            if (hashes.isEmpty()) {
                return Collections.emptyList();
            }
            String sql = this.sqlForManyPlaceholders(SqlStatements.SELECT_COMMIT_LOG_MANY, hashes.size());
            PreparedStatement ps = c.conn().prepareStatement(sql);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                for (int i = 0; i < hashes.size(); ++i) {
                    ps.setString(2 + i, hashes.get(i).asString());
                }
                HashMap<Hash, CommitLogEntry> result = new HashMap<Hash, CommitLogEntry>(hashes.size() * 2);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        CommitLogEntry entry = ProtoSerialization.protoToCommitLogEntry((byte[])rs.getBytes(1));
                        result.put(entry.getHash(), entry);
                    }
                }
                list = hashes.stream().map(result::get).collect(Collectors.toList());
                if (ps == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return list;
    }

    protected void doWriteIndividualCommit(ConnectionWrapper c, CommitLogEntry entry) throws ReferenceConflictException {
        try (PreparedStatement ps = c.conn().prepareStatement(SqlStatements.INSERT_COMMIT_LOG);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, entry.getHash().asString());
            ps.setBytes(3, ProtoSerialization.toProto((CommitLogEntry)entry).toByteArray());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            if (this.isRetryTransaction(e)) {
                throw new RetryTransactionException();
            }
            this.throwIfReferenceConflictException(e, () -> String.format("Hash collision for '%s' in commit-log", entry.getHash()));
            throw new RuntimeException(e);
        }
    }

    protected void doWriteMultipleCommits(ConnectionWrapper c, List<CommitLogEntry> entries) throws ReferenceConflictException {
        try {
            this.writeMany(c, SqlStatements.INSERT_COMMIT_LOG, entries, e -> e.getHash().asString(), e -> ProtoSerialization.toProto((CommitLogEntry)e).toByteArray(), false);
        }
        catch (ReferenceNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void doUpdateMultipleCommits(ConnectionWrapper c, List<CommitLogEntry> entries) throws ReferenceNotFoundException {
        try {
            this.writeMany(c, SqlStatements.UPDATE_COMMIT_LOG, entries, e -> e.getHash().asString(), e -> ProtoSerialization.toProto((CommitLogEntry)e).toByteArray(), true);
        }
        catch (ReferenceConflictException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void doWriteKeyListEntities(ConnectionWrapper c, List<KeyListEntity> newKeyListEntities) {
        try {
            this.writeMany(c, SqlStatements.INSERT_KEY_LIST, newKeyListEntities, e -> e.getId().asString(), e -> ProtoSerialization.toProto((KeyList)e.getKeys()).toByteArray(), false);
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected <T> void writeMany(ConnectionWrapper c, String sqlInsert, List<T> entries, Function<T, String> idRetriever, Function<T, byte[]> serializer, boolean update) throws ReferenceConflictException, ReferenceNotFoundException {
        int cnt = 0;
        try (PreparedStatement ps = c.conn().prepareStatement(sqlInsert);){
            for (T e : entries) {
                if (update) {
                    ps.setBytes(1, serializer.apply(e));
                    ps.setString(2, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                    ps.setString(3, idRetriever.apply(e));
                } else {
                    ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                    ps.setString(2, idRetriever.apply(e));
                    ps.setBytes(3, serializer.apply(e));
                }
                ps.addBatch();
                if (++cnt != ((TxDatabaseAdapterConfig)this.config).getBatchSize()) continue;
                int[] result = ps.executeBatch();
                if (update) {
                    for (int i : result) {
                        if (i == 1) continue;
                        throw new ReferenceNotFoundException("");
                    }
                }
                cnt = 0;
            }
            if (cnt > 0) {
                int[] result = ps.executeBatch();
                if (update) {
                    for (int i : result) {
                        if (i == 1) continue;
                        throw new ReferenceNotFoundException("");
                    }
                }
            }
        }
        catch (SQLException e) {
            if (this.isRetryTransaction(e)) {
                throw new RetryTransactionException();
            }
            this.throwIfReferenceConflictException(e, () -> String.format("Hash collision for one of the hashes %s in commit-log", entries.stream().map(x -> "'" + (String)idRetriever.apply(x) + "'").collect(Collectors.joining(", "))));
            throw new RuntimeException(e);
        }
    }

    protected Stream<KeyListEntity> doFetchKeyLists(ConnectionWrapper c, List<Hash> keyListsIds) {
        if (keyListsIds.isEmpty()) {
            return Stream.empty();
        }
        try (Traced ignore = Traced.trace((String)"doFetchKeyLists.stream");){
            Stream<KeyListEntity> stream = JdbcSelectSpliterator.buildStream(c.conn(), this.sqlForManyPlaceholders(SqlStatements.SELECT_KEY_LIST_MANY, keyListsIds.size()), ps -> {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                int i = 2;
                for (Hash id : keyListsIds) {
                    ps.setString(i++, id.asString());
                }
            }, rs -> KeyListEntity.of((Hash)Hash.of((String)rs.getString(1)), (KeyList)ProtoSerialization.protoToKeyList((byte[])rs.getBytes(2))));
            return stream;
        }
    }

    protected void throwIfReferenceConflictException(SQLException e, Supplier<String> message) throws ReferenceConflictException {
        if (this.isIntegrityConstraintViolation(e)) {
            throw new ReferenceConflictException(message.get(), (Throwable)e);
        }
    }

    protected SQLException newIntegrityConstraintViolationException() {
        return new SQLIntegrityConstraintViolationException();
    }

    protected boolean isIntegrityConstraintViolation(Throwable e) {
        if (e instanceof SQLException) {
            SQLException sqlException = (SQLException)e;
            return sqlException instanceof SQLIntegrityConstraintViolationException || 23505 == sqlException.getErrorCode() || CONSTRAINT_VIOLATION_SQL_STATE.equals(sqlException.getSQLState());
        }
        return false;
    }

    protected boolean isRetryTransaction(SQLException e) {
        if (e.getSQLState() == null) {
            return false;
        }
        switch (e.getSQLState()) {
            case "40P01": 
            case "40001": {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Hash tryMoveNamedReference(ConnectionWrapper conn, NamedRef ref, Hash expectedHead, Hash newHead) {
        try (Traced ignore = Traced.trace((String)"tryMoveNamedReference");){
            Hash hash;
            block15: {
                PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.UPDATE_NAMED_REFERENCE);
                try {
                    ps.setString(1, newHead.asString());
                    ps.setString(2, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                    ps.setString(3, ref.getName());
                    ps.setString(4, expectedHead.asString());
                    Object object = hash = ps.executeUpdate() == 1 ? newHead : null;
                    if (ps == null) break block15;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return hash;
        }
        catch (SQLException e) {
            if (this.isRetryTransaction(e)) {
                throw new RetryTransactionException();
            }
            throw new RuntimeException(e);
        }
    }

    public RepoDescription fetchRepositoryDescription() {
        try (ConnectionWrapper conn = this.borrowConnection();){
            RepoDescription repoDescription = this.fetchRepositoryDescription(conn);
            return repoDescription;
        }
    }

    private RepoDescription fetchRepositoryDescription(ConnectionWrapper conn) {
        try {
            return ProtoSerialization.protoToRepoDescription((byte[])this.fetchRepositoryDescriptionInternal(conn));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    private byte[] fetchRepositoryDescriptionInternal(ConnectionWrapper conn) throws SQLException {
        try (Traced ignore = Traced.trace((String)"fetchRepositoryDescriptionInternal");){
            byte[] byArray;
            block23: {
                ResultSet rs;
                PreparedStatement ps;
                block20: {
                    byte[] byArray2;
                    block22: {
                        block21: {
                            ps = conn.conn().prepareStatement(SqlStatements.SELECT_REPO_DESCRIPTION);
                            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                            rs = ps.executeQuery();
                            if (!rs.next()) break block20;
                            byArray2 = rs.getBytes(1);
                            if (rs == null) break block21;
                            rs.close();
                        }
                        if (ps == null) break block22;
                        ps.close();
                    }
                    return byArray2;
                }
                try {
                    block24: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block24;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    byArray = null;
                    if (ps == null) break block23;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return byArray;
        }
    }

    public void updateRepositoryDescription(Function<RepoDescription, RepoDescription> updater) throws ReferenceConflictException {
        try {
            this.opLoop("updateRepositoryDescription", null, true, (conn, x) -> {
                block16: {
                    byte[] currentBytes = this.fetchRepositoryDescriptionInternal(conn);
                    RepoDescription current = ProtoSerialization.protoToRepoDescription((byte[])currentBytes);
                    RepoDescription updated = (RepoDescription)updater.apply(current);
                    if (updated != null) {
                        if (currentBytes == null) {
                            try (PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.INSERT_REPO_DESCRIPTION);){
                                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                                ps.setBytes(2, ProtoSerialization.toProto((RepoDescription)updated).toByteArray());
                                if (ps.executeUpdate() == 0) {
                                    OpResult opResult = null;
                                    return opResult;
                                }
                                break block16;
                            }
                        }
                        try (PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.UPDATE_REPO_DESCRIPTION);){
                            ps.setBytes(1, ProtoSerialization.toProto((RepoDescription)updated).toByteArray());
                            ps.setString(2, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                            ps.setBytes(3, currentBytes);
                            if (ps.executeUpdate() == 0) {
                                OpResult opResult = null;
                                return opResult;
                            }
                        }
                    }
                }
                return OpResult.opResult(NO_ANCESTOR, null);
            }, () -> DatabaseAdapterUtil.repoDescUpdateConflictMessage((String)"Conflict"), () -> DatabaseAdapterUtil.repoDescUpdateConflictMessage((String)"Retry-failure"));
        }
        catch (RuntimeException | ReferenceConflictException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, List<String>> allCreateTableDDL() {
        return ImmutableMap.builder().put((Object)"repo_desc", Collections.singletonList(SqlStatements.CREATE_TABLE_REPO_DESCRIPTION)).put((Object)"global_state", Collections.singletonList(SqlStatements.CREATE_TABLE_GLOBAL_STATE)).put((Object)"named_refs", Collections.singletonList(SqlStatements.CREATE_TABLE_NAMED_REFERENCES)).put((Object)"commit_log", Collections.singletonList(SqlStatements.CREATE_TABLE_COMMIT_LOG)).put((Object)"key_list", Collections.singletonList(SqlStatements.CREATE_TABLE_KEY_LIST)).put((Object)"ref_log", Collections.singletonList(SqlStatements.CREATE_TABLE_REF_LOG)).put((Object)"ref_log_head", Collections.singletonList(SqlStatements.CREATE_TABLE_REF_LOG_HEAD)).put((Object)"atts", Collections.singletonList(SqlStatements.CREATE_TABLE_ATTACHMENTS)).build();
    }

    protected abstract Map<NessieSqlDataType, String> databaseSqlFormatParameters();

    protected String insertOnConflictDoNothing(String insertSql) {
        return insertSql;
    }

    protected boolean metadataUpperCase() {
        return true;
    }

    protected boolean batchDDL() {
        return false;
    }

    protected void updateRefLogHead(AdapterTypes.RefLogEntry newRefLog, ConnectionWrapper conn) throws SQLException {
        try (Traced ignore = Traced.trace((String)"updateRefLogHead");
             PreparedStatement psUpdate = conn.conn().prepareStatement(SqlStatements.UPDATE_REF_LOG_HEAD);){
            psUpdate.setString(1, Hash.of((ByteString)newRefLog.getRefLogId()).asString());
            psUpdate.setBytes(2, this.refLogHeadParents(newRefLog).toByteArray());
            psUpdate.setString(3, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            psUpdate.setString(4, Hash.of((ByteString)newRefLog.getParents(0)).asString());
            if (psUpdate.executeUpdate() != 1) {
                throw new RetryTransactionException();
            }
        }
    }

    protected void insertRefLogHead(AdapterTypes.RefLogEntry newRefLog, ConnectionWrapper conn) throws SQLException {
        block25: {
            try (Traced ignore = Traced.trace((String)"insertRefLogHead");
                 PreparedStatement selectStatement = conn.conn().prepareStatement(SqlStatements.SELECT_REF_LOG_HEAD);){
                selectStatement.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                try (ResultSet result = selectStatement.executeQuery();){
                    if (result.next()) break block25;
                    try (PreparedStatement psUpdate = conn.conn().prepareStatement(SqlStatements.INSERT_REF_LOG_HEAD);){
                        psUpdate.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                        psUpdate.setString(2, Hash.of((ByteString)newRefLog.getRefLogId()).asString());
                        psUpdate.setBytes(3, this.refLogHeadParents(newRefLog).toByteArray());
                        if (psUpdate.executeUpdate() != 1) {
                            throw this.newIntegrityConstraintViolationException();
                        }
                    }
                }
            }
        }
    }

    private AdapterTypes.RefLogParents refLogHeadParents(AdapterTypes.RefLogEntry newRefLog) {
        AdapterTypes.RefLogParents.Builder refLogParents = AdapterTypes.RefLogParents.newBuilder();
        refLogParents.addRefLogParentsInclHead(newRefLog.getRefLogId());
        newRefLog.getParentsList().stream().limit(((TxDatabaseAdapterConfig)this.config).getParentsPerRefLogEntry()).forEach(arg_0 -> ((AdapterTypes.RefLogParents.Builder)refLogParents).addRefLogParentsInclHead(arg_0));
        return refLogParents.build();
    }

    protected Spliterator<RefLog> readRefLog(ConnectionWrapper ctx, Hash initialHash) throws RefLogNotFoundException {
        if (NO_ANCESTOR.equals(initialHash)) {
            return Spliterators.emptySpliterator();
        }
        RefLog initial = this.fetchFromRefLog(ctx, initialHash);
        if (initial == null) {
            throw RefLogNotFoundException.forRefLogId((String)initialHash.asString());
        }
        return this.logFetcher(ctx, initial, (arg_0, arg_1) -> ((TxDatabaseAdapter)this).fetchPageFromRefLog(arg_0, arg_1), RefLog::getParents);
    }

    /*
     * Exception decompiling
     */
    protected RefLogHead getRefLogHead(ConnectionWrapper conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected RefLog doFetchFromRefLog(ConnectionWrapper connection, Hash refLogId) {
        if (refLogId == null) {
            try {
                RefLogHead head = this.getRefLogHead(connection);
                refLogId = head != null ? head.getRefLogHead() : null;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try (PreparedStatement ps = connection.conn().prepareStatement(SqlStatements.SELECT_REF_LOG);){
            RefLog refLog;
            block17: {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                ps.setString(2, refLogId.asString());
                ResultSet rs = ps.executeQuery();
                try {
                    RefLog refLog2 = refLog = rs.next() ? ProtoSerialization.protoToRefLog((byte[])rs.getBytes(1)) : null;
                    if (rs == null) break block17;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return refLog;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<RefLog> doFetchPageFromRefLog(ConnectionWrapper connection, List<Hash> hashes) {
        List<RefLog> list;
        block18: {
            if (hashes.isEmpty()) {
                return Collections.emptyList();
            }
            String sql = this.sqlForManyPlaceholders(SqlStatements.SELECT_REF_LOG_MANY, hashes.size());
            PreparedStatement ps = connection.conn().prepareStatement(sql);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                for (int i = 0; i < hashes.size(); ++i) {
                    ps.setString(2 + i, hashes.get(i).asString());
                }
                HashMap<Hash, RefLog> result = new HashMap<Hash, RefLog>(hashes.size() * 2);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        RefLog entry = ProtoSerialization.protoToRefLog((byte[])rs.getBytes(1));
                        result.put(Objects.requireNonNull(entry).getRefLogId(), entry);
                    }
                }
                list = hashes.stream().map(result::get).collect(Collectors.toList());
                if (ps == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return list;
    }

    private void commitRefLog(ConnectionWrapper conn, long timeInMicros, Hash commitHash, NamedRef ref, AdapterTypes.RefLogEntry.Operation operation, List<Hash> sourceHashes) throws SQLException, ReferenceConflictException {
        RefLogHead refLogHead = this.getRefLogHead(conn);
        AdapterTypes.RefLogEntry newRefLog = this.writeRefLogEntry(conn, ref, refLogHead, commitHash, operation, timeInMicros, sourceHashes);
        this.updateRefLogHead(newRefLog, conn);
    }

    private AdapterTypes.RefLogEntry writeRefLogEntry(ConnectionWrapper connection, NamedRef ref, RefLogHead refLogHead, Hash commitHash, AdapterTypes.RefLogEntry.Operation operation, long timeInMicros, List<Hash> sourceHashes) throws ReferenceConflictException {
        Stream<ByteString> newParents;
        ByteString newId = DatabaseAdapterUtil.randomHash().asBytes();
        if (refLogHead.getRefLogParentsInclHead().isEmpty() || !refLogHead.getRefLogParentsInclHead().get(0).equals(refLogHead.getRefLogHead())) {
            newParents = Stream.of(refLogHead.getRefLogHead().asBytes());
            RefLog parentEntry = this.fetchFromRefLog(connection, refLogHead.getRefLogHead());
            if (parentEntry != null) {
                newParents = Stream.concat(newParents, parentEntry.getParents().stream().limit(((TxDatabaseAdapterConfig)this.config).getParentsPerRefLogEntry() - 1).map(Hash::asBytes));
            }
        } else {
            newParents = refLogHead.getRefLogParentsInclHead().stream().map(Hash::asBytes);
        }
        AdapterTypes.RefType refType = ref instanceof TagName ? AdapterTypes.RefType.Tag : AdapterTypes.RefType.Branch;
        AdapterTypes.RefLogEntry.Builder entry = AdapterTypes.RefLogEntry.newBuilder().setRefLogId(newId).setRefName(ByteString.copyFromUtf8((String)ref.getName())).setRefType(refType).setCommitHash(commitHash.asBytes()).setOperationTime(timeInMicros).setOperation(operation);
        sourceHashes.forEach(hash -> entry.addSourceHashes(hash.asBytes()));
        newParents.forEach(arg_0 -> ((AdapterTypes.RefLogEntry.Builder)entry).addParents(arg_0));
        AdapterTypes.RefLogEntry refLogEntry = entry.build();
        this.writeRefLog(connection, refLogEntry);
        return refLogEntry;
    }

    private void writeRefLog(ConnectionWrapper connection, AdapterTypes.RefLogEntry entry) throws ReferenceConflictException {
        try (PreparedStatement ps = connection.conn().prepareStatement(SqlStatements.INSERT_REF_LOG);){
            ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
            ps.setString(2, Hash.of((ByteString)entry.getRefLogId()).asString());
            ps.setBytes(3, entry.toByteArray());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            if (this.isRetryTransaction(e)) {
                throw new RetryTransactionException();
            }
            this.throwIfReferenceConflictException(e, () -> String.format("Hash collision for '%s' in ref-log", entry.getRefLogId()));
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Stream<ContentAttachmentKey> getAttachmentKeys(String contentId) {
        try (ConnectionWrapper conn = this.borrowConnection();){
            Stream<ContentAttachmentKey> stream;
            block23: {
                PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.SELECT_ATTACHMENTS_KEYS);
                try {
                    ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                    ps.setString(2, ProtoSerialization.attachmentKeyContentIdAsString((String)contentId));
                    ArrayList<ContentAttachmentKey> result = new ArrayList<ContentAttachmentKey>();
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            ContentAttachmentKey key = ProtoSerialization.attachmentKey((AdapterTypes.AttachmentKey)ProtoSerialization.attachmentKeyFromString((String)rs.getString(1)));
                            if (!contentId.equals(key.getContentId())) {
                                break;
                            }
                            result.add(key);
                        }
                    }
                    stream = result.stream();
                    if (ps == null) break block23;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return stream;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @MustBeClosed
    public Stream<ContentAttachment> mapToAttachment(Stream<ContentAttachmentKey> keys) {
        Iterator keysIter = keys.iterator();
        if (!keysIter.hasNext()) {
            return Stream.empty();
        }
        return this.withConnectionWrapper(conn -> {
            Stream<Object> result = Stream.empty();
            int chunkSize = ((TxDatabaseAdapterConfig)this.config).getAttachmentKeysBatchSize();
            ArrayList<ContentAttachmentKey> batch = new ArrayList<ContentAttachmentKey>(chunkSize);
            while (keysIter.hasNext()) {
                batch.add((ContentAttachmentKey)keysIter.next());
                if (batch.size() != chunkSize) continue;
                result = Stream.concat(result, this.mapToAttachmentChunk(batch, conn));
                batch.clear();
            }
            if (!batch.isEmpty()) {
                result = Stream.concat(result, this.mapToAttachmentChunk(batch, conn));
            }
            return result;
        });
    }

    private Stream<ContentAttachment> mapToAttachmentChunk(List<ContentAttachmentKey> batch, ConnectionWrapper conn) {
        ArrayList<ContentAttachmentKey> chunk = new ArrayList<ContentAttachmentKey>(batch);
        return Stream.of("").flatMap(x -> this.mapToAttachmentChunk(conn, chunk));
    }

    private Stream<ContentAttachment> mapToAttachmentChunk(ConnectionWrapper conn, List<ContentAttachmentKey> keysList) {
        Stream<ContentAttachment> stream;
        block17: {
            String sql = this.sqlForManyPlaceholders(SqlStatements.SELECT_ATTACHMENTS, keysList.size());
            PreparedStatement ps = conn.conn().prepareStatement(sql);
            try {
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                int paramIndex = 2;
                for (ContentAttachmentKey key : keysList) {
                    String keyAsString = key.asString();
                    ps.setString(paramIndex++, keyAsString);
                }
                HashMap<AdapterTypes.AttachmentKey, AdapterTypes.AttachmentValue> fetched = new HashMap<AdapterTypes.AttachmentKey, AdapterTypes.AttachmentValue>();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        AdapterTypes.AttachmentKey key = ProtoSerialization.attachmentKeyFromString((String)rs.getString(1));
                        byte[] value = rs.getBytes(2);
                        fetched.put(key, AdapterTypes.AttachmentValue.parseFrom((byte[])value));
                    }
                }
                stream = keysList.stream().map(ProtoSerialization::attachmentKey).filter(fetched::containsKey).map(k -> {
                    AdapterTypes.AttachmentValue value = (AdapterTypes.AttachmentValue)fetched.get(k);
                    return ProtoSerialization.attachmentContent((AdapterTypes.AttachmentKey)k, (AdapterTypes.AttachmentValue)value);
                });
                if (ps == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidProtocolBufferException | SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            ps.close();
        }
        return stream;
    }

    public void putAttachments(Stream<ContentAttachment> attachments) {
        try (ConnectionWrapper conn = this.borrowConnection();){
            this.persistAttachments(conn, attachments);
            conn.commit();
        }
    }

    protected void persistAttachments(ConnectionWrapper connection, Stream<ContentAttachment> attachments) {
        try (PreparedStatement ps = connection.conn().prepareStatement(this.insertOnConflictDoNothing(SqlStatements.INSERT_ATTACHMENT));){
            attachments.forEach(bc -> {
                block2: {
                    try {
                        this.attachmentInsert(ps, (ContentAttachment)bc);
                    }
                    catch (SQLException e) {
                        if (this.isIntegrityConstraintViolation(e)) break block2;
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void attachmentInsert(PreparedStatement ps, ContentAttachment attachment) throws SQLException {
        ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
        ps.setString(2, attachment.getKey().asString());
        ps.setBytes(3, ProtoSerialization.toProtoValue((ContentAttachment)attachment).toByteArray());
        ps.setString(4, attachment.getVersion());
        ps.executeUpdate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean consistentPutAttachment(ContentAttachment attachment, Optional<String> expectedVersion) {
        try (ConnectionWrapper conn = this.borrowConnection();){
            block23: {
                if (expectedVersion.isPresent()) {
                    try (PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.UPDATE_ATTACHMENT);){
                        ps.setBytes(1, ProtoSerialization.toProtoValue((ContentAttachment)attachment).toByteArray());
                        ps.setString(2, attachment.getVersion());
                        ps.setString(3, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                        ps.setString(4, attachment.getKey().asString());
                        ps.setString(5, expectedVersion.get());
                        if (ps.executeUpdate() != 1) {
                            boolean bl = false;
                            return bl;
                        }
                        break block23;
                    }
                }
                try (PreparedStatement ps = conn.conn().prepareStatement(SqlStatements.INSERT_ATTACHMENT);){
                    this.attachmentInsert(ps, attachment);
                }
            }
            conn.commit();
            return true;
        }
        catch (SQLException e) {
            if (!this.isIntegrityConstraintViolation(e)) throw new RuntimeException(e);
            return false;
        }
    }

    public void deleteAttachments(Stream<ContentAttachmentKey> keys) {
        List keysList = keys.collect(Collectors.toList());
        if (keysList.isEmpty()) {
            return;
        }
        try (ConnectionWrapper conn = this.borrowConnection();){
            String sql = this.sqlForManyPlaceholders(SqlStatements.DELETE_ATTACHMENTS, keysList.size());
            try (PreparedStatement ps = conn.conn().prepareStatement(sql);){
                ps.setString(1, ((TxDatabaseAdapterConfig)this.config).getRepositoryId());
                int paramIndex = 2;
                for (ContentAttachmentKey key : keysList) {
                    ps.setString(paramIndex++, key.asString());
                }
                ps.executeUpdate();
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MustBeClosed
    private <R, E extends Exception> Stream<R> withConnectionWrapper(ThrowingStreamResult<R, E> x) throws E {
        ConnectionWrapper conn = this.borrowConnection();
        boolean failed = true;
        try {
            Stream<R> r = x.process(conn);
            failed = false;
            Stream stream = (Stream)r.onClose(conn::close);
            return stream;
        }
        finally {
            if (failed) {
                conn.close();
            }
        }
    }

    private static /* synthetic */ void lambda$getRefLogHead$58(ImmutableRefLogHead.Builder refLogHead, ByteString b) {
        refLogHead.addRefLogParentsInclHead(Hash.of((ByteString)b));
    }

    @FunctionalInterface
    static interface ThrowingStreamResult<R, E extends Exception> {
        @MustBeClosed
        public Stream<R> process(ConnectionWrapper var1) throws E;
    }

    protected static enum NessieSqlDataType {
        BLOB,
        HASH,
        KEY_PREFIX,
        KEY,
        NAMED_REF,
        NAMED_REF_TYPE,
        CONTENT_ID,
        INTEGER;

    }

    static final class OpResult {
        final Hash head;
        final Supplier<? extends AdapterEvent.Builder<?, ?>> adapterEventBuilder;

        private OpResult(Hash head, Supplier<? extends AdapterEvent.Builder<?, ?>> adapterEventBuilder) {
            this.head = head;
            this.adapterEventBuilder = adapterEventBuilder;
        }

        public static OpResult opResult(Hash head, Supplier<? extends AdapterEvent.Builder<?, ?>> adapterEventBuilder) {
            return new OpResult(head, adapterEventBuilder);
        }
    }

    @FunctionalInterface
    public static interface LoopOp {
        public OpResult apply(ConnectionWrapper var1, Hash var2) throws VersionStoreException, SQLException;
    }
}

