/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx;

import java.sql.Connection;
import java.util.function.Supplier;

public final class ConnectionWrapper
implements AutoCloseable {
    private static final ThreadLocal<ConnectionWrapper> INHERITED = new ThreadLocal();
    private final Connection connection;
    private int useCount;

    public ConnectionWrapper(Connection connection) {
        this.connection = connection;
    }

    public static ConnectionWrapper borrow(Supplier<Connection> newConnectionProducer) {
        ConnectionWrapper current = INHERITED.get();
        if (current != null) {
            ++current.useCount;
        } else {
            current = new ConnectionWrapper(newConnectionProducer.get());
            INHERITED.set(current);
        }
        return current;
    }

    public static boolean threadHasOpenConnection() {
        return INHERITED.get() != null;
    }

    public Connection conn() {
        return this.connection;
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.useCount > 0) {
            --this.useCount;
            return;
        }
        this.forceClose();
    }

    public void forceClose() {
        try {
            try {
                this.connection.rollback();
            }
            finally {
                INHERITED.set(null);
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

