/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx.postgres;

import java.util.function.Consumer;
import org.projectnessie.versioned.persist.tx.local.GenericJdbcTestConnectionProviderSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

abstract class ContainerTestConnectionProviderSource
extends GenericJdbcTestConnectionProviderSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerTestConnectionProviderSource.class);
    private JdbcDatabaseContainer<?> container;

    ContainerTestConnectionProviderSource() {
    }

    public void start() throws Exception {
        if (this.container != null) {
            throw new IllegalStateException("Already started");
        }
        this.container = (JdbcDatabaseContainer)this.createContainer().withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.container.start();
        this.configureConnectionProviderConfigFromDefaults(c -> c.withJdbcUrl(this.container.getJdbcUrl()).withJdbcUser(this.container.getUsername()).withJdbcPass(this.container.getPassword()));
        super.start();
    }

    public void stop() throws Exception {
        try {
            super.stop();
        }
        finally {
            try {
                if (this.container != null) {
                    this.container.stop();
                }
            }
            finally {
                this.container = null;
            }
        }
    }

    protected abstract JdbcDatabaseContainer<?> createContainer();
}

