/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx.local;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.sql.DataSource;
import org.projectnessie.versioned.persist.tx.TxConnectionProvider;
import org.projectnessie.versioned.persist.tx.local.LocalTxConnectionConfig;

public class LocalConnectionProvider
extends TxConnectionProvider<LocalTxConnectionConfig> {
    private DataSource dataSource;

    public void initialize() throws SQLException {
        if (this.dataSource == null) {
            AgroalDataSourceConfigurationSupplier dataSourceConfiguration = new AgroalDataSourceConfigurationSupplier();
            AgroalConnectionPoolConfigurationSupplier poolConfiguration = dataSourceConfiguration.connectionPoolConfiguration();
            AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = poolConfiguration.connectionFactoryConfiguration();
            poolConfiguration.initialSize(((LocalTxConnectionConfig)this.config).getPoolInitialSize()).maxSize(((LocalTxConnectionConfig)this.config).getPoolMaxSize()).minSize(((LocalTxConnectionConfig)this.config).getPoolMinSize()).maxLifetime(Duration.of(((LocalTxConnectionConfig)this.config).getPoolConnectionLifetimeMinutes(), ChronoUnit.MINUTES)).acquisitionTimeout(Duration.of(((LocalTxConnectionConfig)this.config).getPoolAcquisitionTimeoutSeconds(), ChronoUnit.SECONDS));
            connectionFactoryConfiguration.jdbcUrl(((LocalTxConnectionConfig)this.config).getJdbcUrl());
            if (((LocalTxConnectionConfig)this.config).getJdbcUser() != null) {
                connectionFactoryConfiguration.credential((Object)new NamePrincipal(((LocalTxConnectionConfig)this.config).getJdbcUser()));
                connectionFactoryConfiguration.credential((Object)new SimplePassword(((LocalTxConnectionConfig)this.config).getJdbcPass()));
            }
            connectionFactoryConfiguration.jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation.valueOf((String)((LocalTxConnectionConfig)this.config).getPoolTransactionIsolation()));
            connectionFactoryConfiguration.autoCommit(false);
            this.dataSource = AgroalDataSource.from((AgroalDataSourceConfiguration)dataSourceConfiguration.get(), (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
        }
    }

    public void close() throws Exception {
        if (this.dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    public Connection borrowConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

