/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tx.local;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.tx.TxConnectionConfig;
import org.projectnessie.versioned.persist.tx.local.LocalTxConnectionConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LocalTxConnectionConfig", generator="Immutables")
@Immutable
public final class ImmutableLocalTxConnectionConfig
implements LocalTxConnectionConfig {
    @Nullable
    private final String catalog;
    @Nullable
    private final String schema;
    @Nullable
    private final String jdbcUrl;
    @Nullable
    private final String jdbcUser;
    @Nullable
    private final String jdbcPass;
    private final int poolMinSize;
    private final int poolMaxSize;
    private final int poolInitialSize;
    private final int poolAcquisitionTimeoutSeconds;
    private final int poolConnectionLifetimeMinutes;
    private final String poolTransactionIsolation;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLocalTxConnectionConfig(Builder builder) {
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.jdbcUrl = builder.jdbcUrl;
        this.jdbcUser = builder.jdbcUser;
        this.jdbcPass = builder.jdbcPass;
        if (builder.poolMinSizeIsSet()) {
            this.initShim.poolMinSize(builder.poolMinSize);
        }
        if (builder.poolMaxSizeIsSet()) {
            this.initShim.poolMaxSize(builder.poolMaxSize);
        }
        if (builder.poolInitialSizeIsSet()) {
            this.initShim.poolInitialSize(builder.poolInitialSize);
        }
        if (builder.poolAcquisitionTimeoutSecondsIsSet()) {
            this.initShim.poolAcquisitionTimeoutSeconds(builder.poolAcquisitionTimeoutSeconds);
        }
        if (builder.poolConnectionLifetimeMinutesIsSet()) {
            this.initShim.poolConnectionLifetimeMinutes(builder.poolConnectionLifetimeMinutes);
        }
        if (builder.poolTransactionIsolation != null) {
            this.initShim.poolTransactionIsolation(builder.poolTransactionIsolation);
        }
        this.poolMinSize = this.initShim.getPoolMinSize();
        this.poolMaxSize = this.initShim.getPoolMaxSize();
        this.poolInitialSize = this.initShim.getPoolInitialSize();
        this.poolAcquisitionTimeoutSeconds = this.initShim.getPoolAcquisitionTimeoutSeconds();
        this.poolConnectionLifetimeMinutes = this.initShim.getPoolConnectionLifetimeMinutes();
        this.poolTransactionIsolation = this.initShim.getPoolTransactionIsolation();
        this.initShim = null;
    }

    private ImmutableLocalTxConnectionConfig(@Nullable String catalog, @Nullable String schema, @Nullable String jdbcUrl, @Nullable String jdbcUser, @Nullable String jdbcPass, int poolMinSize, int poolMaxSize, int poolInitialSize, int poolAcquisitionTimeoutSeconds, int poolConnectionLifetimeMinutes, String poolTransactionIsolation) {
        this.catalog = catalog;
        this.schema = schema;
        this.jdbcUrl = jdbcUrl;
        this.jdbcUser = jdbcUser;
        this.jdbcPass = jdbcPass;
        this.poolMinSize = poolMinSize;
        this.poolMaxSize = poolMaxSize;
        this.poolInitialSize = poolInitialSize;
        this.poolAcquisitionTimeoutSeconds = poolAcquisitionTimeoutSeconds;
        this.poolConnectionLifetimeMinutes = poolConnectionLifetimeMinutes;
        this.poolTransactionIsolation = poolTransactionIsolation;
        this.initShim = null;
    }

    private int getPoolMinSizeInitialize() {
        return LocalTxConnectionConfig.super.getPoolMinSize();
    }

    private int getPoolMaxSizeInitialize() {
        return LocalTxConnectionConfig.super.getPoolMaxSize();
    }

    private int getPoolInitialSizeInitialize() {
        return LocalTxConnectionConfig.super.getPoolInitialSize();
    }

    private int getPoolAcquisitionTimeoutSecondsInitialize() {
        return LocalTxConnectionConfig.super.getPoolAcquisitionTimeoutSeconds();
    }

    private int getPoolConnectionLifetimeMinutesInitialize() {
        return LocalTxConnectionConfig.super.getPoolConnectionLifetimeMinutes();
    }

    private String getPoolTransactionIsolationInitialize() {
        return LocalTxConnectionConfig.super.getPoolTransactionIsolation();
    }

    @Nullable
    public String getCatalog() {
        return this.catalog;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    @Nullable
    public String getJdbcUser() {
        return this.jdbcUser;
    }

    @Override
    @Nullable
    public String getJdbcPass() {
        return this.jdbcPass;
    }

    @Override
    public int getPoolMinSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPoolMinSize() : this.poolMinSize;
    }

    @Override
    public int getPoolMaxSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPoolMaxSize() : this.poolMaxSize;
    }

    @Override
    public int getPoolInitialSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPoolInitialSize() : this.poolInitialSize;
    }

    @Override
    public int getPoolAcquisitionTimeoutSeconds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPoolAcquisitionTimeoutSeconds() : this.poolAcquisitionTimeoutSeconds;
    }

    @Override
    public int getPoolConnectionLifetimeMinutes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPoolConnectionLifetimeMinutes() : this.poolConnectionLifetimeMinutes;
    }

    @Override
    public String getPoolTransactionIsolation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPoolTransactionIsolation() : this.poolTransactionIsolation;
    }

    public final ImmutableLocalTxConnectionConfig withCatalog(@Nullable String value) {
        if (Objects.equals(this.catalog, value)) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(value, this.schema, this.jdbcUrl, this.jdbcUser, this.jdbcPass, this.poolMinSize, this.poolMaxSize, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    public final ImmutableLocalTxConnectionConfig withSchema(@Nullable String value) {
        if (Objects.equals(this.schema, value)) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, value, this.jdbcUrl, this.jdbcUser, this.jdbcPass, this.poolMinSize, this.poolMaxSize, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withJdbcUrl(@Nullable String value) {
        if (Objects.equals(this.jdbcUrl, value)) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, value, this.jdbcUser, this.jdbcPass, this.poolMinSize, this.poolMaxSize, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withJdbcUser(@Nullable String value) {
        if (Objects.equals(this.jdbcUser, value)) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, this.jdbcUrl, value, this.jdbcPass, this.poolMinSize, this.poolMaxSize, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withJdbcPass(@Nullable String value) {
        if (Objects.equals(this.jdbcPass, value)) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, this.jdbcUrl, this.jdbcUser, value, this.poolMinSize, this.poolMaxSize, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withPoolMinSize(int value) {
        if (this.poolMinSize == value) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, this.jdbcUrl, this.jdbcUser, this.jdbcPass, value, this.poolMaxSize, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withPoolMaxSize(int value) {
        if (this.poolMaxSize == value) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, this.jdbcUrl, this.jdbcUser, this.jdbcPass, this.poolMinSize, value, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withPoolInitialSize(int value) {
        if (this.poolInitialSize == value) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, this.jdbcUrl, this.jdbcUser, this.jdbcPass, this.poolMinSize, this.poolMaxSize, value, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withPoolAcquisitionTimeoutSeconds(int value) {
        if (this.poolAcquisitionTimeoutSeconds == value) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, this.jdbcUrl, this.jdbcUser, this.jdbcPass, this.poolMinSize, this.poolMaxSize, this.poolInitialSize, value, this.poolConnectionLifetimeMinutes, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withPoolConnectionLifetimeMinutes(int value) {
        if (this.poolConnectionLifetimeMinutes == value) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, this.jdbcUrl, this.jdbcUser, this.jdbcPass, this.poolMinSize, this.poolMaxSize, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, value, this.poolTransactionIsolation);
    }

    @Override
    public final ImmutableLocalTxConnectionConfig withPoolTransactionIsolation(String value) {
        String newValue = Objects.requireNonNull(value, "poolTransactionIsolation");
        if (this.poolTransactionIsolation.equals(newValue)) {
            return this;
        }
        return new ImmutableLocalTxConnectionConfig(this.catalog, this.schema, this.jdbcUrl, this.jdbcUser, this.jdbcPass, this.poolMinSize, this.poolMaxSize, this.poolInitialSize, this.poolAcquisitionTimeoutSeconds, this.poolConnectionLifetimeMinutes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLocalTxConnectionConfig && this.equalTo(0, (ImmutableLocalTxConnectionConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableLocalTxConnectionConfig another) {
        return Objects.equals(this.catalog, another.catalog) && Objects.equals(this.schema, another.schema) && Objects.equals(this.jdbcUrl, another.jdbcUrl) && Objects.equals(this.jdbcUser, another.jdbcUser) && Objects.equals(this.jdbcPass, another.jdbcPass) && this.poolMinSize == another.poolMinSize && this.poolMaxSize == another.poolMaxSize && this.poolInitialSize == another.poolInitialSize && this.poolAcquisitionTimeoutSeconds == another.poolAcquisitionTimeoutSeconds && this.poolConnectionLifetimeMinutes == another.poolConnectionLifetimeMinutes && this.poolTransactionIsolation.equals(another.poolTransactionIsolation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.catalog);
        h += (h << 5) + Objects.hashCode(this.schema);
        h += (h << 5) + Objects.hashCode(this.jdbcUrl);
        h += (h << 5) + Objects.hashCode(this.jdbcUser);
        h += (h << 5) + Objects.hashCode(this.jdbcPass);
        h += (h << 5) + this.poolMinSize;
        h += (h << 5) + this.poolMaxSize;
        h += (h << 5) + this.poolInitialSize;
        h += (h << 5) + this.poolAcquisitionTimeoutSeconds;
        h += (h << 5) + this.poolConnectionLifetimeMinutes;
        h += (h << 5) + this.poolTransactionIsolation.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LocalTxConnectionConfig").omitNullValues().add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("jdbcUrl", (Object)this.jdbcUrl).add("jdbcUser", (Object)this.jdbcUser).add("jdbcPass", (Object)this.jdbcPass).add("poolMinSize", this.poolMinSize).add("poolMaxSize", this.poolMaxSize).add("poolInitialSize", this.poolInitialSize).add("poolAcquisitionTimeoutSeconds", this.poolAcquisitionTimeoutSeconds).add("poolConnectionLifetimeMinutes", this.poolConnectionLifetimeMinutes).add("poolTransactionIsolation", (Object)this.poolTransactionIsolation).toString();
    }

    public static ImmutableLocalTxConnectionConfig copyOf(LocalTxConnectionConfig instance) {
        if (instance instanceof ImmutableLocalTxConnectionConfig) {
            return (ImmutableLocalTxConnectionConfig)instance;
        }
        return ImmutableLocalTxConnectionConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LocalTxConnectionConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_POOL_MIN_SIZE = 1L;
        private static final long OPT_BIT_POOL_MAX_SIZE = 2L;
        private static final long OPT_BIT_POOL_INITIAL_SIZE = 4L;
        private static final long OPT_BIT_POOL_ACQUISITION_TIMEOUT_SECONDS = 8L;
        private static final long OPT_BIT_POOL_CONNECTION_LIFETIME_MINUTES = 16L;
        private long optBits;
        @Nullable
        private String catalog;
        @Nullable
        private String schema;
        @Nullable
        private String jdbcUrl;
        @Nullable
        private String jdbcUser;
        @Nullable
        private String jdbcPass;
        private int poolMinSize;
        private int poolMaxSize;
        private int poolInitialSize;
        private int poolAcquisitionTimeoutSeconds;
        private int poolConnectionLifetimeMinutes;
        @Nullable
        private String poolTransactionIsolation;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LocalTxConnectionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TxConnectionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String schemaValue;
            LocalTxConnectionConfig instance;
            long bits = 0L;
            if (object instanceof LocalTxConnectionConfig) {
                String jdbcUserValue;
                instance = (LocalTxConnectionConfig)object;
                if ((bits & 1L) == 0L) {
                    schemaValue = instance.getSchema();
                    if (schemaValue != null) {
                        this.schema(schemaValue);
                    }
                    bits |= 1L;
                }
                this.poolMaxSize(instance.getPoolMaxSize());
                String jdbcPassValue = instance.getJdbcPass();
                if (jdbcPassValue != null) {
                    this.jdbcPass(jdbcPassValue);
                }
                if ((jdbcUserValue = instance.getJdbcUser()) != null) {
                    this.jdbcUser(jdbcUserValue);
                }
                this.poolMinSize(instance.getPoolMinSize());
                this.poolAcquisitionTimeoutSeconds(instance.getPoolAcquisitionTimeoutSeconds());
                if ((bits & 2L) == 0L) {
                    String catalogValue = instance.getCatalog();
                    if (catalogValue != null) {
                        this.catalog(catalogValue);
                    }
                    bits |= 2L;
                }
                this.poolTransactionIsolation(instance.getPoolTransactionIsolation());
                String jdbcUrlValue = instance.getJdbcUrl();
                if (jdbcUrlValue != null) {
                    this.jdbcUrl(jdbcUrlValue);
                }
                this.poolInitialSize(instance.getPoolInitialSize());
                this.poolConnectionLifetimeMinutes(instance.getPoolConnectionLifetimeMinutes());
            }
            if (object instanceof TxConnectionConfig) {
                instance = (TxConnectionConfig)object;
                if ((bits & 1L) == 0L) {
                    schemaValue = instance.getSchema();
                    if (schemaValue != null) {
                        this.schema(schemaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    String catalogValue = instance.getCatalog();
                    if (catalogValue != null) {
                        this.catalog(catalogValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder catalog(@Nullable String catalog) {
            this.catalog = catalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schema(@Nullable String schema) {
            this.schema = schema;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jdbcUrl(@Nullable String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jdbcUser(@Nullable String jdbcUser) {
            this.jdbcUser = jdbcUser;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jdbcPass(@Nullable String jdbcPass) {
            this.jdbcPass = jdbcPass;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder poolMinSize(int poolMinSize) {
            this.poolMinSize = poolMinSize;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder poolMaxSize(int poolMaxSize) {
            this.poolMaxSize = poolMaxSize;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder poolInitialSize(int poolInitialSize) {
            this.poolInitialSize = poolInitialSize;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder poolAcquisitionTimeoutSeconds(int poolAcquisitionTimeoutSeconds) {
            this.poolAcquisitionTimeoutSeconds = poolAcquisitionTimeoutSeconds;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder poolConnectionLifetimeMinutes(int poolConnectionLifetimeMinutes) {
            this.poolConnectionLifetimeMinutes = poolConnectionLifetimeMinutes;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder poolTransactionIsolation(String poolTransactionIsolation) {
            this.poolTransactionIsolation = Objects.requireNonNull(poolTransactionIsolation, "poolTransactionIsolation");
            return this;
        }

        public ImmutableLocalTxConnectionConfig build() {
            return new ImmutableLocalTxConnectionConfig(this);
        }

        private boolean poolMinSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean poolMaxSizeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean poolInitialSizeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean poolAcquisitionTimeoutSecondsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean poolConnectionLifetimeMinutesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    @Generated(from="LocalTxConnectionConfig", generator="Immutables")
    private final class InitShim {
        private byte poolMinSizeBuildStage = 0;
        private int poolMinSize;
        private byte poolMaxSizeBuildStage = 0;
        private int poolMaxSize;
        private byte poolInitialSizeBuildStage = 0;
        private int poolInitialSize;
        private byte poolAcquisitionTimeoutSecondsBuildStage = 0;
        private int poolAcquisitionTimeoutSeconds;
        private byte poolConnectionLifetimeMinutesBuildStage = 0;
        private int poolConnectionLifetimeMinutes;
        private byte poolTransactionIsolationBuildStage = 0;
        private String poolTransactionIsolation;

        private InitShim() {
        }

        int getPoolMinSize() {
            if (this.poolMinSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.poolMinSizeBuildStage == 0) {
                this.poolMinSizeBuildStage = (byte)-1;
                this.poolMinSize = ImmutableLocalTxConnectionConfig.this.getPoolMinSizeInitialize();
                this.poolMinSizeBuildStage = 1;
            }
            return this.poolMinSize;
        }

        void poolMinSize(int poolMinSize) {
            this.poolMinSize = poolMinSize;
            this.poolMinSizeBuildStage = 1;
        }

        int getPoolMaxSize() {
            if (this.poolMaxSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.poolMaxSizeBuildStage == 0) {
                this.poolMaxSizeBuildStage = (byte)-1;
                this.poolMaxSize = ImmutableLocalTxConnectionConfig.this.getPoolMaxSizeInitialize();
                this.poolMaxSizeBuildStage = 1;
            }
            return this.poolMaxSize;
        }

        void poolMaxSize(int poolMaxSize) {
            this.poolMaxSize = poolMaxSize;
            this.poolMaxSizeBuildStage = 1;
        }

        int getPoolInitialSize() {
            if (this.poolInitialSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.poolInitialSizeBuildStage == 0) {
                this.poolInitialSizeBuildStage = (byte)-1;
                this.poolInitialSize = ImmutableLocalTxConnectionConfig.this.getPoolInitialSizeInitialize();
                this.poolInitialSizeBuildStage = 1;
            }
            return this.poolInitialSize;
        }

        void poolInitialSize(int poolInitialSize) {
            this.poolInitialSize = poolInitialSize;
            this.poolInitialSizeBuildStage = 1;
        }

        int getPoolAcquisitionTimeoutSeconds() {
            if (this.poolAcquisitionTimeoutSecondsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.poolAcquisitionTimeoutSecondsBuildStage == 0) {
                this.poolAcquisitionTimeoutSecondsBuildStage = (byte)-1;
                this.poolAcquisitionTimeoutSeconds = ImmutableLocalTxConnectionConfig.this.getPoolAcquisitionTimeoutSecondsInitialize();
                this.poolAcquisitionTimeoutSecondsBuildStage = 1;
            }
            return this.poolAcquisitionTimeoutSeconds;
        }

        void poolAcquisitionTimeoutSeconds(int poolAcquisitionTimeoutSeconds) {
            this.poolAcquisitionTimeoutSeconds = poolAcquisitionTimeoutSeconds;
            this.poolAcquisitionTimeoutSecondsBuildStage = 1;
        }

        int getPoolConnectionLifetimeMinutes() {
            if (this.poolConnectionLifetimeMinutesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.poolConnectionLifetimeMinutesBuildStage == 0) {
                this.poolConnectionLifetimeMinutesBuildStage = (byte)-1;
                this.poolConnectionLifetimeMinutes = ImmutableLocalTxConnectionConfig.this.getPoolConnectionLifetimeMinutesInitialize();
                this.poolConnectionLifetimeMinutesBuildStage = 1;
            }
            return this.poolConnectionLifetimeMinutes;
        }

        void poolConnectionLifetimeMinutes(int poolConnectionLifetimeMinutes) {
            this.poolConnectionLifetimeMinutes = poolConnectionLifetimeMinutes;
            this.poolConnectionLifetimeMinutesBuildStage = 1;
        }

        String getPoolTransactionIsolation() {
            if (this.poolTransactionIsolationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.poolTransactionIsolationBuildStage == 0) {
                this.poolTransactionIsolationBuildStage = (byte)-1;
                this.poolTransactionIsolation = Objects.requireNonNull(ImmutableLocalTxConnectionConfig.this.getPoolTransactionIsolationInitialize(), "poolTransactionIsolation");
                this.poolTransactionIsolationBuildStage = 1;
            }
            return this.poolTransactionIsolation;
        }

        void poolTransactionIsolation(String poolTransactionIsolation) {
            this.poolTransactionIsolation = poolTransactionIsolation;
            this.poolTransactionIsolationBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.poolMinSizeBuildStage == -1) {
                attributes.add("poolMinSize");
            }
            if (this.poolMaxSizeBuildStage == -1) {
                attributes.add("poolMaxSize");
            }
            if (this.poolInitialSizeBuildStage == -1) {
                attributes.add("poolInitialSize");
            }
            if (this.poolAcquisitionTimeoutSecondsBuildStage == -1) {
                attributes.add("poolAcquisitionTimeoutSeconds");
            }
            if (this.poolConnectionLifetimeMinutesBuildStage == -1) {
                attributes.add("poolConnectionLifetimeMinutes");
            }
            if (this.poolTransactionIsolationBuildStage == -1) {
                attributes.add("poolTransactionIsolation");
            }
            return "Cannot build LocalTxConnectionConfig, attribute initializers form cycle " + attributes;
        }
    }
}

