/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractReferences {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractReferences(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    @Test
    void createBranch() throws Exception {
        BranchName create = BranchName.of((String)"createBranch");
        this.createNamedRef((NamedRef)create, (NamedRef)TagName.of((String)create.getName()));
    }

    @Test
    void createTag() throws Exception {
        TagName create = TagName.of((String)"createTag");
        this.createNamedRef((NamedRef)create, (NamedRef)BranchName.of((String)create.getName()));
    }

    private void createNamedRef(NamedRef create, NamedRef opposite) throws Exception {
        BranchName branch = BranchName.of((String)"main");
        try (Stream refs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);){
            Assertions.assertThat(refs.map(ReferenceInfo::getNamedRef)).containsExactlyInAnyOrder((Object[])new NamedRef[]{branch});
        }
        Hash mainHash = this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty());
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference(create, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        Hash createHash = this.databaseAdapter.create(create, this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty()));
        Assertions.assertThat((Object)createHash).isEqualTo((Object)mainHash);
        try (Stream refs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);){
            Assertions.assertThat(refs.map(ReferenceInfo::getNamedRef)).containsExactlyInAnyOrder((Object[])new NamedRef[]{branch, create});
        }
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.create(create, this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty()))).isInstanceOf(ReferenceAlreadyExistsException.class);
        Assertions.assertThat((Object)this.databaseAdapter.hashOnReference(create, Optional.empty())).isEqualTo((Object)createHash);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference(opposite, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.create((NamedRef)BranchName.of((String)create.getName()), this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty()))).isInstanceOf(ReferenceAlreadyExistsException.class);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.delete(create, Optional.of(Hash.of((String)"dead00004242fee18eef")))).isInstanceOf(ReferenceConflictException.class);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.delete(opposite, Optional.of(createHash))).isInstanceOf(ReferenceNotFoundException.class);
        Assertions.assertThat((Object)this.databaseAdapter.delete(create, Optional.of(createHash))).isEqualTo((Object)createHash);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference(create, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        refs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);
        try {
            Assertions.assertThat(refs.map(ReferenceInfo::getNamedRef)).containsExactlyInAnyOrder((Object[])new NamedRef[]{branch});
        }
        finally {
            if (refs != null) {
                refs.close();
            }
        }
    }

    @Test
    void verifyNotFoundAndConflictExceptionsForUnreachableCommit() throws Exception {
        BranchName main = BranchName.of((String)"main");
        BranchName unreachable = BranchName.of((String)"unreachable");
        BranchName helper = BranchName.of((String)"helper");
        this.databaseAdapter.create((NamedRef)unreachable, this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()));
        Hash helperHead = this.databaseAdapter.create((NamedRef)helper, this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()));
        OnRefOnly hello = OnRefOnly.onRef((String)"hello", (String)"contentId");
        Hash unreachableHead = this.databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(unreachable).commitMetaSerialized(ByteString.copyFromUtf8((String)"commit meta")).addPuts(KeyWithBytes.of((Key)Key.of((String[])new String[]{"foo"}), (ContentId)ContentId.of((String)hello.getId()), (byte)DefaultStoreWorker.payloadForContent((Content)hello), (ByteString)hello.serialized())).build());
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference((NamedRef)main, Optional.of(unreachableHead))).isInstanceOf(ReferenceNotFoundException.class)).hasMessage(String.format("Could not find commit '%s' in reference '%s'.", unreachableHead.asString(), main.getName())), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            OnRefOnly noNo = OnRefOnly.onRef((String)"hello", (String)"contentId-no-no");
            this.databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(helper).expectedHead(Optional.of(unreachableHead)).commitMetaSerialized(ByteString.copyFromUtf8((String)"commit meta")).addPuts(KeyWithBytes.of((Key)Key.of((String[])new String[]{"bar"}), (ContentId)ContentId.of((String)noNo.getId()), (byte)DefaultStoreWorker.payloadForContent((Content)noNo), (ByteString)noNo.serialized())).build());
        }).isInstanceOf(ReferenceNotFoundException.class)).hasMessage(String.format("Could not find commit '%s' in reference '%s'.", unreachableHead.asString(), helper.getName())), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.databaseAdapter.assign((NamedRef)helper, Optional.of(unreachableHead), this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()))).isInstanceOf(ReferenceConflictException.class)).hasMessage(String.format("Named-reference '%s' is not at expected hash '%s', but at '%s'.", helper.getName(), unreachableHead.asString(), helperHead.asString()))});
    }

    @Test
    void assign() throws Exception {
        BranchName main = BranchName.of((String)"main");
        TagName tag = TagName.of((String)"tag");
        TagName branch = TagName.of((String)"branch");
        this.databaseAdapter.create((NamedRef)branch, this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()));
        this.databaseAdapter.create((NamedRef)tag, this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()));
        Hash beginning = this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty());
        Hash[] commits = new Hash[3];
        for (int i = 0; i < commits.length; ++i) {
            OnRefOnly hello = OnRefOnly.onRef((String)("hello " + i), (String)("contentId-" + i));
            commits[i] = this.databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(main).commitMetaSerialized(ByteString.copyFromUtf8((String)("commit meta " + i))).addPuts(KeyWithBytes.of((Key)Key.of((String[])new String[]{"bar", Integer.toString(i)}), (ContentId)ContentId.of((String)hello.getId()), (byte)DefaultStoreWorker.payloadForContent((Content)hello), (ByteString)hello.serialized())).build());
        }
        Hash expect = beginning;
        for (Hash commit : commits) {
            Assertions.assertThat(Arrays.asList(this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty()), this.databaseAdapter.hashOnReference((NamedRef)tag, Optional.empty()))).containsExactly((Object[])new Hash[]{expect, expect});
            this.databaseAdapter.assign((NamedRef)tag, Optional.of(expect), commit);
            this.databaseAdapter.assign((NamedRef)branch, Optional.of(expect), commit);
            expect = commit;
        }
        Assertions.assertThat(Arrays.asList(this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty()), this.databaseAdapter.hashOnReference((NamedRef)tag, Optional.empty()))).containsExactly((Object[])new Hash[]{commits[commits.length - 1], commits[commits.length - 1]});
    }

    @Test
    void recreateDefaultBranch() throws Exception {
        BranchName main = BranchName.of((String)"main");
        Hash mainHead = this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty());
        Assertions.assertThat((Object)this.databaseAdapter.delete((NamedRef)main, Optional.of(mainHead))).isEqualTo((Object)mainHead);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        this.databaseAdapter.create((NamedRef)main, null);
        this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty());
    }

    @Test
    void deleteReferences() throws Exception {
        BranchName main = BranchName.of((String)"main");
        Hash mainHead = this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty());
        BranchName delete1 = BranchName.of((String)"delete1");
        TagName delete2 = TagName.of((String)"delete2");
        BranchName delete3 = BranchName.of((String)"delete3");
        TagName delete4 = TagName.of((String)"delete4");
        this.databaseAdapter.create((NamedRef)delete1, mainHead);
        this.databaseAdapter.create((NamedRef)delete2, mainHead);
        this.databaseAdapter.create((NamedRef)delete3, mainHead);
        this.databaseAdapter.create((NamedRef)delete4, mainHead);
        Assertions.assertThat((Object)this.databaseAdapter.delete((NamedRef)delete1, Optional.of(mainHead))).isEqualTo((Object)mainHead);
        Assertions.assertThat((Object)this.databaseAdapter.delete((NamedRef)delete2, Optional.of(mainHead))).isEqualTo((Object)mainHead);
        Assertions.assertThat((Object)this.databaseAdapter.delete((NamedRef)delete3, Optional.empty())).isEqualTo((Object)mainHead);
        Assertions.assertThat((Object)this.databaseAdapter.delete((NamedRef)delete4, Optional.empty())).isEqualTo((Object)mainHead);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference((NamedRef)delete1, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference((NamedRef)delete2, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference((NamedRef)delete3, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.hashOnReference((NamedRef)delete4, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    void manyReferences() throws Exception {
        IntFunction<NamedRef> refGen = i -> {
            StringBuilder sb = new StringBuilder(120);
            sb.append("manyReferencesTest-").append(i).append('-');
            while (sb.length() < 100) {
                sb.append('x');
            }
            String name = sb.toString();
            return (i & 1) == 1 ? TagName.of((String)name) : BranchName.of((String)name);
        };
        HashMap<NamedRef, Hash> refHeads = new HashMap<NamedRef, Hash>();
        for (int i2 = 0; i2 < 50; ++i2) {
            NamedRef ref2 = refGen.apply(i2);
            Assertions.assertThat((Object)this.databaseAdapter.create(ref2, this.databaseAdapter.noAncestorHash())).isEqualTo((Object)this.databaseAdapter.noAncestorHash());
            refHeads.put(ref2, this.databaseAdapter.noAncestorHash());
            Assertions.assertThat((Object)this.databaseAdapter.namedRef(ref2.getName(), GetNamedRefsParams.DEFAULT).getNamedRef()).isEqualTo((Object)ref2);
        }
        try (Stream refs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);){
            Assertions.assertThat(refs.filter(ri -> ri.getNamedRef().getName().startsWith("manyReferencesTest-"))).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.range(0, 50).mapToObj(refGen).map(ref -> ReferenceInfo.of((Hash)this.databaseAdapter.noAncestorHash(), (NamedRef)ref)).collect(Collectors.toList()));
        }
        for (int commit = 0; commit < 50; ++commit) {
            for (int i3 = 0; i3 < 50; ++i3) {
                NamedRef ref3 = refGen.apply(i3);
                if (!(ref3 instanceof BranchName)) continue;
                Hash newHead = this.databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch((BranchName)ref3).commitMetaSerialized(ByteString.copyFromUtf8((String)("foo on " + ref3.getName()))).expectedHead(Optional.of((Hash)refHeads.get(ref3))).addPuts(KeyWithBytes.of((Key)Key.of((String[])new String[]{"table", "c" + commit}), (ContentId)ContentId.of((String)("c" + commit)), (byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.newOnRef((String)("c" + commit)), att -> {}))).build());
                refHeads.put(ref3, newHead);
            }
        }
        for (int i4 = 2; i4 < 50; i4 += 3) {
            NamedRef ref4 = refGen.apply(i4);
            this.databaseAdapter.delete(ref4, Optional.empty());
            Assertions.assertThatThrownBy(() -> this.databaseAdapter.namedRef(ref4.getName(), GetNamedRefsParams.DEFAULT)).isInstanceOf(ReferenceNotFoundException.class);
        }
        refs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);
        try {
            Assertions.assertThat(refs.filter(ri -> ri.getNamedRef().getName().startsWith("manyReferencesTest-"))).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.range(0, 50).filter(i -> (i - 2) % 3 != 0).mapToObj(refGen).map(ref -> ReferenceInfo.of((Hash)refHeads.getOrDefault(ref, this.databaseAdapter.noAncestorHash()), (NamedRef)ref)).collect(Collectors.toList()));
        }
        finally {
            if (refs != null) {
                refs.close();
            }
        }
    }
}

