/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableReferenceInfo;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractGetNamedReferences {
    public static final String MAIN_BRANCH = "main";
    private static final Key SOME_KEY = Key.of((String[])new String[]{"a", "b", "c"});
    private static final String SOME_CONTENT_ID = "abc";
    private final DatabaseAdapter databaseAdapter;
    static GetNamedRefsParams.RetrieveOptions COMPUTE_AHEAD_BEHIND = GetNamedRefsParams.RetrieveOptions.builder().isComputeAheadBehind(true).build();
    static GetNamedRefsParams.RetrieveOptions COMPUTE_COMMON_ANCESTOR = GetNamedRefsParams.RetrieveOptions.builder().isComputeAheadBehind(true).build();
    static GetNamedRefsParams.RetrieveOptions COMPUTE_ALL = GetNamedRefsParams.RetrieveOptions.builder().isComputeAheadBehind(true).isComputeCommonAncestor(true).build();
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractGetNamedReferences(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    @Test
    public void parameterValidationNamedRefs() throws Exception {
        BranchName main = BranchName.of((String)MAIN_BRANCH);
        BranchName parameterValidation = BranchName.of((String)"parameterValidation");
        TagName parameterValidationTag = TagName.of((String)"parameterValidationTag");
        Hash hash = this.databaseAdapter.noAncestorHash();
        this.soft.assertThat((Object)this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty())).isEqualTo((Object)hash);
        this.databaseAdapter.create((NamedRef)parameterValidation, hash);
        this.databaseAdapter.create((NamedRef)parameterValidationTag, hash);
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRefs(null)).isInstanceOf(NullPointerException.class)).hasMessage("Parameter for GetNamedRefsParams must not be null.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(COMPUTE_AHEAD_BEHIND).build())).isInstanceOf(NullPointerException.class)).hasMessage("Base reference name missing.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().tagRetrieveOptions(COMPUTE_AHEAD_BEHIND).build())).isInstanceOf(NullPointerException.class)).hasMessage("Base reference name missing.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(COMPUTE_COMMON_ANCESTOR).build())).isInstanceOf(NullPointerException.class)).hasMessage("Base reference name missing.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().tagRetrieveOptions(COMPUTE_COMMON_ANCESTOR).build())).isInstanceOf(NullPointerException.class)).hasMessage("Base reference name missing.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(COMPUTE_AHEAD_BEHIND).tagRetrieveOptions(COMPUTE_AHEAD_BEHIND).baseReference((NamedRef)BranchName.of((String)"no-no-no")).build())).isInstanceOf(ReferenceNotFoundException.class)).hasMessage("Named reference 'no-no-no' not found");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(COMPUTE_AHEAD_BEHIND).tagRetrieveOptions(COMPUTE_AHEAD_BEHIND).baseReference((NamedRef)TagName.of((String)"blah-no")).build())).isInstanceOf(ReferenceNotFoundException.class)).hasMessage("Named reference 'blah-no' not found");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.OMIT).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.OMIT).build())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Must retrieve branches or tags or both.");
    }

    @Test
    public void parameterValidationNamedRef() throws Exception {
        BranchName main = BranchName.of((String)MAIN_BRANCH);
        BranchName parameterValidation = BranchName.of((String)"parameterValidation");
        TagName parameterValidationTag = TagName.of((String)"parameterValidationTag");
        Hash hash = this.databaseAdapter.noAncestorHash();
        this.soft.assertThat((Object)this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty())).isEqualTo((Object)hash);
        this.databaseAdapter.create((NamedRef)parameterValidation, hash);
        this.databaseAdapter.create((NamedRef)parameterValidationTag, hash);
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(main.getName(), null)).isInstanceOf(NullPointerException.class)).hasMessage("Parameter for GetNamedRefsParams must not be null");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(parameterValidation.getName(), (GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(COMPUTE_AHEAD_BEHIND).build())).isInstanceOf(NullPointerException.class)).hasMessage("Base reference name missing.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(parameterValidation.getName(), (GetNamedRefsParams)GetNamedRefsParams.builder().tagRetrieveOptions(COMPUTE_AHEAD_BEHIND).build())).isInstanceOf(NullPointerException.class)).hasMessage("Base reference name missing.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(parameterValidation.getName(), (GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(COMPUTE_COMMON_ANCESTOR).build())).isInstanceOf(NullPointerException.class)).hasMessage("Base reference name missing.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(parameterValidation.getName(), (GetNamedRefsParams)GetNamedRefsParams.builder().tagRetrieveOptions(COMPUTE_COMMON_ANCESTOR).build())).isInstanceOf(NullPointerException.class)).hasMessage("Base reference name missing.");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(parameterValidation.getName(), (GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(COMPUTE_AHEAD_BEHIND).tagRetrieveOptions(COMPUTE_AHEAD_BEHIND).baseReference((NamedRef)BranchName.of((String)"no-no-no")).build())).isInstanceOf(ReferenceNotFoundException.class)).hasMessage("Named reference 'no-no-no' not found");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(parameterValidation.getName(), (GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(COMPUTE_AHEAD_BEHIND).tagRetrieveOptions(COMPUTE_AHEAD_BEHIND).baseReference((NamedRef)TagName.of((String)"blah-no")).build())).isInstanceOf(ReferenceNotFoundException.class)).hasMessage("Named reference 'blah-no' not found");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(parameterValidationTag.getName(), (GetNamedRefsParams)GetNamedRefsParams.builder().tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.OMIT).build())).isInstanceOf(ReferenceNotFoundException.class)).hasMessage("Named reference '" + parameterValidationTag.getName() + "' not found");
    }

    @Test
    public void fromNoAncestor() throws Exception {
        int i;
        int i2;
        Hash hash;
        BranchName main = BranchName.of((String)MAIN_BRANCH);
        BranchName branch = BranchName.of((String)"fromNoAncestorBranch");
        BranchName branch2 = BranchName.of((String)"fromNoAncestorBranch2");
        BranchName branch3 = BranchName.of((String)"fromNoAncestorBranch3");
        TagName tag = TagName.of((String)"fromNoAncestorTag");
        TagName tag2 = TagName.of((String)"fromNoAncestorTag2");
        TagName tag3 = TagName.of((String)"fromNoAncestorTag3");
        Hash mainHash = hash = this.databaseAdapter.noAncestorHash();
        Hash mainParent = null;
        Hash branchHash = hash;
        Hash branchParent = null;
        Hash tagParent = null;
        this.soft.assertThat((Object)this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty())).isEqualTo((Object)hash);
        this.databaseAdapter.create((NamedRef)branch, hash);
        this.databaseAdapter.create((NamedRef)tag, hash);
        this.verifyReferences(new ExpectedNamedReference((NamedRef)main, 0L, mainHash, mainParent, 0, 0, hash, null), new ExpectedNamedReference((NamedRef)branch, 0L, branchHash, branchParent, 0, 0, hash, null), new ExpectedNamedReference((NamedRef)tag, 0L, hash, tagParent, 0, 0, hash, null));
        for (i2 = 0; i2 < 10; ++i2) {
            mainParent = mainHash;
            mainHash = this.dummyCommit(main, mainHash, i2 + 1);
        }
        this.verifyReferences(new ExpectedNamedReference((NamedRef)main, 10L, mainHash, mainParent, 0, 0, hash, this.commitMetaFor((NamedRef)main, 10)), new ExpectedNamedReference((NamedRef)branch, 0L, branchHash, branchParent, 0, 10, hash, null), new ExpectedNamedReference((NamedRef)tag, 0L, hash, tagParent, 0, 10, hash, null));
        for (i2 = 0; i2 < 4; ++i2) {
            branchParent = branchHash;
            branchHash = this.dummyCommit(branch, branchHash, i2 + 1);
        }
        this.verifyReferences(new ExpectedNamedReference((NamedRef)main, 10L, mainHash, mainParent, 0, 0, hash, this.commitMetaFor((NamedRef)main, 10)), new ExpectedNamedReference((NamedRef)branch, 4L, branchHash, branchParent, 4, 10, hash, this.commitMetaFor((NamedRef)branch, 4)), new ExpectedNamedReference((NamedRef)tag, 0L, hash, tagParent, 0, 10, hash, null));
        Hash main10 = mainHash;
        Hash branch2Parent = mainParent;
        Hash branch2Hash = this.databaseAdapter.create((NamedRef)branch2, main10);
        Hash tag2Parent = mainParent;
        Hash tag2Hash = this.databaseAdapter.create((NamedRef)tag2, main10);
        this.verifyReferences(new ExpectedNamedReference((NamedRef)main, 10L, mainHash, mainParent, 0, 0, hash, this.commitMetaFor((NamedRef)main, 10)), new ExpectedNamedReference((NamedRef)branch, 4L, branchHash, branchParent, 4, 10, hash, this.commitMetaFor((NamedRef)branch, 4)), new ExpectedNamedReference((NamedRef)tag, 0L, hash, tagParent, 0, 10, hash, null), new ExpectedNamedReference((NamedRef)branch2, 10L, branch2Hash, branch2Parent, 0, 0, main10, this.commitMetaFor((NamedRef)main, 10)), new ExpectedNamedReference((NamedRef)tag2, 10L, tag2Hash, tag2Parent, 0, 0, main10, this.commitMetaFor((NamedRef)main, 10)));
        for (i = 10; i < 20; ++i) {
            mainParent = mainHash;
            mainHash = this.dummyCommit(main, mainHash, i + 1);
        }
        this.verifyReferences(new ExpectedNamedReference((NamedRef)main, 20L, mainHash, mainParent, 0, 0, hash, this.commitMetaFor((NamedRef)main, 20)), new ExpectedNamedReference((NamedRef)branch, 4L, branchHash, branchParent, 4, 20, hash, this.commitMetaFor((NamedRef)branch, 4)), new ExpectedNamedReference((NamedRef)tag, 0L, hash, tagParent, 0, 20, hash, null), new ExpectedNamedReference((NamedRef)branch2, 10L, branch2Hash, branch2Parent, 0, 10, main10, this.commitMetaFor((NamedRef)main, 10)), new ExpectedNamedReference((NamedRef)tag2, 10L, tag2Hash, tag2Parent, 0, 10, main10, this.commitMetaFor((NamedRef)main, 10)));
        for (i = 0; i < 4; ++i) {
            branch2Parent = branch2Hash;
            branch2Hash = this.dummyCommit(branch2, branch2Hash, i + 1);
        }
        this.verifyReferences(new ExpectedNamedReference((NamedRef)main, 20L, mainHash, mainParent, 0, 0, hash, this.commitMetaFor((NamedRef)main, 20)), new ExpectedNamedReference((NamedRef)branch, 4L, branchHash, branchParent, 4, 20, hash, this.commitMetaFor((NamedRef)branch, 4)), new ExpectedNamedReference((NamedRef)tag, 0L, hash, tagParent, 0, 20, hash, null), new ExpectedNamedReference((NamedRef)branch2, 14L, branch2Hash, branch2Parent, 4, 10, main10, this.commitMetaFor((NamedRef)branch2, 4)), new ExpectedNamedReference((NamedRef)tag2, 10L, tag2Hash, tag2Parent, 0, 10, main10, this.commitMetaFor((NamedRef)main, 10)));
        Hash branch2plus42 = branch2Hash;
        Hash branch3Hash = this.databaseAdapter.create((NamedRef)branch3, branch2plus42);
        Hash branch3Parent = branch2Parent;
        Hash tag3Hash = this.databaseAdapter.create((NamedRef)tag3, branch2plus42);
        Hash tag3Parent = branch2Parent;
        for (int i3 = 0; i3 < 4; ++i3) {
            branch3Parent = branch3Hash;
            branch3Hash = this.dummyCommit(branch3, branch3Hash, i3 + 1);
        }
        this.verifyReferences(new ExpectedNamedReference((NamedRef)main, 20L, mainHash, mainParent, 0, 0, hash, this.commitMetaFor((NamedRef)main, 20)), new ExpectedNamedReference((NamedRef)branch, 4L, branchHash, branchParent, 4, 20, hash, this.commitMetaFor((NamedRef)branch, 4)), new ExpectedNamedReference((NamedRef)tag, 0L, hash, tagParent, 0, 20, hash, null), new ExpectedNamedReference((NamedRef)branch2, 14L, branch2Hash, branch2Parent, 4, 10, main10, this.commitMetaFor((NamedRef)branch2, 4)), new ExpectedNamedReference((NamedRef)tag2, 10L, tag2Hash, tag2Parent, 0, 10, main10, this.commitMetaFor((NamedRef)main, 10)), new ExpectedNamedReference((NamedRef)branch3, 18L, branch3Hash, branch3Parent, 8, 10, main10, this.commitMetaFor((NamedRef)branch3, 4)), new ExpectedNamedReference((NamedRef)tag3, 14L, tag3Hash, tag3Parent, 4, 10, main10, this.commitMetaFor((NamedRef)branch2, 4)));
    }

    private ByteString commitMetaFor(NamedRef ref, int num) {
        return ByteString.copyFromUtf8((String)("dummy commit " + ref.getName() + " " + num));
    }

    private Hash dummyCommit(BranchName branch, Hash expectedHash, int num) throws Exception {
        return this.databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().commitMetaSerialized(this.commitMetaFor((NamedRef)branch, num)).toBranch(branch).expectedHead(Optional.of(expectedHash)).addPuts(KeyWithBytes.of((Key)SOME_KEY, (ContentId)ContentId.of((String)SOME_CONTENT_ID), (byte)42, (ByteString)ByteString.copyFromUtf8((String)"dummy content"))).build());
    }

    private void verifyReferences(ExpectedNamedReference ... references) throws ReferenceNotFoundException {
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).branchRetrieveOptions(COMPUTE_COMMON_ANCESTOR).tagRetrieveOptions(COMPUTE_COMMON_ANCESTOR).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).branchRetrieveOptions(COMPUTE_COMMON_ANCESTOR).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).tagRetrieveOptions(COMPUTE_COMMON_ANCESTOR).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).branchRetrieveOptions(COMPUTE_AHEAD_BEHIND).tagRetrieveOptions(COMPUTE_AHEAD_BEHIND).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).branchRetrieveOptions(COMPUTE_AHEAD_BEHIND).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).tagRetrieveOptions(COMPUTE_AHEAD_BEHIND).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).branchRetrieveOptions(COMPUTE_ALL).tagRetrieveOptions(COMPUTE_ALL).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).tagRetrieveOptions(COMPUTE_ALL).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)MAIN_BRANCH)).branchRetrieveOptions(COMPUTE_ALL).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.OMIT).build(), references);
        this.verifyReferences((GetNamedRefsParams)GetNamedRefsParams.builder().tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.OMIT).build(), references);
    }

    private void verifyReferences(GetNamedRefsParams params, ExpectedNamedReference ... references) throws ReferenceNotFoundException {
        List expectedRefs = Arrays.stream(references).map(expectedRef -> expectedRef.expected(params)).filter(Objects::nonNull).collect(Collectors.toList());
        try (Stream refs = this.databaseAdapter.namedRefs(params);){
            this.soft.assertThat(refs).describedAs("GetNamedRefsParams=%s - references=%s", new Object[]{params, references}).containsExactlyInAnyOrderElementsOf(expectedRefs);
        }
        for (ReferenceInfo expected : expectedRefs) {
            ((ObjectAssert)this.soft.assertThat((Object)this.databaseAdapter.namedRef(expected.getNamedRef().getName(), params)).describedAs("GetNamedRefsParams=%s - references=%s", new Object[]{params, references})).isEqualTo((Object)expected);
        }
        List failureRefs = Arrays.stream(references).map(expectedRef -> {
            ReferenceInfo<ByteString> expected = expectedRef.expected(params);
            if (expected == null) {
                return expectedRef.ref;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        for (NamedRef ref : failureRefs) {
            this.soft.assertThatThrownBy(() -> this.databaseAdapter.namedRef(ref.getName(), params)).describedAs("GetNamedRefsParams=%s - references=%s", new Object[]{params, references});
        }
        this.soft.assertAll();
    }

    static class ExpectedNamedReference {
        final NamedRef ref;
        final long commitSeq;
        final Hash hash;
        final Hash parentHash;
        final ReferenceInfo.CommitsAheadBehind aheadBehind;
        final Hash commonAncestor;
        final ByteString commitMeta;

        ExpectedNamedReference(NamedRef ref, long commitSeq, Hash hash, Hash parentHash, int ahead, int behind, Hash commonAncestor, ByteString commitMeta) {
            this.ref = ref;
            this.commitSeq = commitSeq;
            this.hash = hash;
            this.parentHash = parentHash;
            this.aheadBehind = ReferenceInfo.CommitsAheadBehind.of((int)ahead, (int)behind);
            this.commonAncestor = commonAncestor;
            this.commitMeta = commitMeta;
        }

        ReferenceInfo<ByteString> expected(GetNamedRefsParams params) {
            GetNamedRefsParams.RetrieveOptions opts;
            if (this.ref instanceof TagName) {
                opts = params.getTagRetrieveOptions();
            } else if (this.ref instanceof BranchName) {
                opts = params.getBranchRetrieveOptions();
            } else {
                throw new IllegalArgumentException("" + this.ref);
            }
            if (!opts.isRetrieve()) {
                return null;
            }
            ImmutableReferenceInfo.Builder builder = ReferenceInfo.builder().namedRef(this.ref).hash(this.hash);
            if (!this.ref.equals(params.getBaseReference())) {
                if (opts.isComputeAheadBehind()) {
                    builder.aheadBehind(this.aheadBehind);
                }
                if (opts.isComputeCommonAncestor()) {
                    builder.commonAncestor(this.commonAncestor);
                }
            }
            if (opts.isRetrieveCommitMetaForHead()) {
                builder.headCommitMeta((Object)this.commitMeta).commitSeq(this.commitSeq);
                if (this.parentHash != null) {
                    builder.addParentHashes(this.parentHash);
                }
            }
            return builder.build();
        }

        public String toString() {
            return "ExpectedNamedReference{ref=" + this.ref + ", hash=" + this.hash + ", aheadBehind=" + this.aheadBehind + ", commonAncestor=" + this.commonAncestor + '}';
        }
    }
}

