/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.ImmutableContentAttachment;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;

public abstract class AbstractContentAttachments {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractContentAttachments(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    @Test
    void consistentAttachmentsUpdateNotPresentSuccess() {
        ImmutableContentAttachment content = ContentAttachment.builder().key(ContentAttachmentKey.of((String)"cid-consistentNotPresentSuccess", (String)"snapshot", (String)"123")).format(ContentAttachment.Format.JSON).compression(ContentAttachment.Compression.NONE).data(ByteString.copyFromUtf8((String)"snapshot stuff")).version("new-hash-1").build();
        Assertions.assertThat((boolean)this.databaseAdapter.consistentPutAttachment((ContentAttachment)content, Optional.empty())).isTrue();
        Assertions.assertThat(this.attachments(Stream.of(content.getKey()))).containsExactly((Object[])new ContentAttachment[]{content});
    }

    @Test
    void consistentAttachmentsUpdateNotPresentFail() {
        String contentId = "cid-consistentNotPresentFail";
        ImmutableContentAttachment content = ContentAttachment.builder().key(ContentAttachmentKey.of((String)contentId, (String)"schema", (String)"42")).format(ContentAttachment.Format.JSON).compression(ContentAttachment.Compression.NONE).data(ByteString.copyFromUtf8((String)"schema stuff")).version("new-hash-2").build();
        Assertions.assertThat(this.attachmentKeys(contentId)).isEmpty();
        Assertions.assertThat((boolean)this.databaseAdapter.consistentPutAttachment((ContentAttachment)content, Optional.of("expected-not"))).isFalse();
        Assertions.assertThat(this.attachmentKeys(contentId)).isEmpty();
        Assertions.assertThat(this.attachments(Stream.of(content.getKey()))).isEmpty();
    }

    @Test
    void consistentAttachmentsUpdate() {
        String contentId = "cid-consistentUpdate";
        ContentAttachmentKey attachmentKey = ContentAttachmentKey.of((String)contentId, (String)"snapshot", (String)"777");
        ImmutableContentAttachment content = ContentAttachment.builder().key(attachmentKey).format(ContentAttachment.Format.JSON).compression(ContentAttachment.Compression.NONE).data(ByteString.copyFromUtf8((String)"snapshot stuff")).version("new-hash-1").build();
        Assertions.assertThat(this.attachmentKeys(contentId)).isEmpty();
        Assertions.assertThat((boolean)this.databaseAdapter.consistentPutAttachment((ContentAttachment)content, Optional.empty())).isTrue();
        Assertions.assertThat(this.attachmentKeys(contentId)).containsExactly((Object[])new ContentAttachmentKey[]{attachmentKey});
        Assertions.assertThat(this.attachments(Stream.of(content.getKey()))).containsExactly((Object[])new ContentAttachment[]{content});
        ImmutableContentAttachment contentUpdate = ContentAttachment.builder().from((ContentAttachment)content).version("update-hash").build();
        Assertions.assertThat((boolean)this.databaseAdapter.consistentPutAttachment((ContentAttachment)contentUpdate, Optional.empty())).isFalse();
        Assertions.assertThat(this.attachmentKeys(contentId)).containsExactly((Object[])new ContentAttachmentKey[]{attachmentKey});
        Assertions.assertThat(this.attachments(Stream.of(content.getKey()))).containsExactly((Object[])new ContentAttachment[]{content});
        Assertions.assertThat((boolean)this.databaseAdapter.consistentPutAttachment((ContentAttachment)contentUpdate, Optional.of("WRONG HASH"))).isFalse();
        Assertions.assertThat(this.attachmentKeys(contentId)).containsExactly((Object[])new ContentAttachmentKey[]{attachmentKey});
        Assertions.assertThat(this.attachments(Stream.of(content.getKey()))).containsExactly((Object[])new ContentAttachment[]{content});
        Assertions.assertThat((boolean)this.databaseAdapter.consistentPutAttachment((ContentAttachment)contentUpdate, Optional.of(content.getVersion()))).isTrue();
        Assertions.assertThat(this.attachmentKeys(contentId)).containsExactly((Object[])new ContentAttachmentKey[]{attachmentKey});
        Assertions.assertThat(this.attachments(Stream.of(content.getKey()))).containsExactly((Object[])new ContentAttachment[]{contentUpdate});
    }

    List<ContentAttachment> attachments(Stream<ContentAttachmentKey> keys) {
        try (Stream s = this.databaseAdapter.mapToAttachment(keys);){
            List<ContentAttachment> list = s.collect(Collectors.toList());
            return list;
        }
    }

    List<ContentAttachmentKey> attachmentKeys(String contentId) {
        try (Stream s = this.databaseAdapter.getAttachmentKeys(contentId);){
            List<ContentAttachmentKey> list = s.collect(Collectors.toList());
            return list;
        }
    }

    @Test
    void emptyGetAttachments() {
        Assertions.assertThat(this.attachments(Stream.empty())).isEmpty();
    }

    @Test
    void nonExistentAttachments() {
        Assertions.assertThat(this.attachments(Stream.of(ContentAttachmentKey.of((String)"foo", (String)"no", (String)"666")))).isEmpty();
        Assertions.assertThat(this.attachmentKeys("foo")).isEmpty();
    }

    private static String randomString(int num) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        StringBuilder sb = new StringBuilder(num);
        for (int i = 0; i < num; ++i) {
            char c = (char)rand.nextInt(32, 126);
            if (c == ':') {
                c = '_';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<ContentAttachment> createAttachments(int numAttachments, int attachmentSize) {
        String contentId = AbstractContentAttachments.randomString(15);
        return IntStream.range(0, numAttachments).mapToObj(i -> ContentAttachment.builder().key(ContentAttachmentKey.of((String)contentId, (String)("type-" + i), (String)AbstractContentAttachments.randomString(10))).format(ContentAttachment.Format.JSON).compression(ContentAttachment.Compression.NONE).objectId(Long.valueOf(ThreadLocalRandom.current().nextLong())).data(ByteString.copyFromUtf8((String)AbstractContentAttachments.randomString(attachmentSize))).build()).collect(Collectors.toList());
    }

    @Test
    void rewriteAttachments() {
        List<ContentAttachment> attachments1 = AbstractContentAttachments.createAttachments(4, 20);
        List keys1 = attachments1.stream().map(ContentAttachment::getKey).collect(Collectors.toList());
        String contentId1 = attachments1.get(0).getKey().getContentId();
        List<ContentAttachment> attachments2 = AbstractContentAttachments.createAttachments(4, 20);
        String contentId2 = attachments2.get(0).getKey().getContentId();
        List keys2 = attachments2.stream().map(ContentAttachment::getKey).collect(Collectors.toList());
        for (int i = 0; i < 3; ++i) {
            this.databaseAdapter.putAttachments(Stream.concat(attachments1.stream(), attachments2.stream()));
            Assertions.assertThat(this.attachments(Stream.concat(keys1.stream(), keys2.stream()))).containsExactlyElementsOf((Iterable)Stream.concat(attachments1.stream(), attachments2.stream()).collect(Collectors.toList()));
            Assertions.assertThat(this.attachmentKeys(contentId1)).containsExactlyInAnyOrderElementsOf(keys1);
            Assertions.assertThat(this.attachmentKeys(contentId2)).containsExactlyInAnyOrderElementsOf(keys2);
        }
    }

    @Test
    void mixedAttachments() {
        List<ContentAttachment> attachments = AbstractContentAttachments.createAttachments(3, 20);
        String contentId = attachments.get(0).getKey().getContentId();
        IntStream.rangeClosed(1, 3).forEach(i -> {
            this.databaseAdapter.putAttachments(attachments.stream().limit(i));
            Supplier<Stream> attStream = () -> attachments.stream().limit(i);
            Supplier<Stream> keyStream = () -> ((Stream)attStream.get()).map(ContentAttachment::getKey);
            Assertions.assertThat(this.attachments(keyStream.get())).containsExactlyElementsOf((Iterable)attStream.get().collect(Collectors.toList()));
            Assertions.assertThat(this.attachmentKeys(contentId)).containsExactlyInAnyOrderElementsOf((Iterable)keyStream.get().collect(Collectors.toList()));
        });
        IntStream.rangeClosed(0, 3).forEach(i -> {
            Supplier<Stream> deleteStream = () -> attachments.stream().limit(i).map(ContentAttachment::getKey);
            Supplier<Stream> remainAttStream = () -> attachments.stream().skip(i);
            Supplier<Stream> remainKeyStream = () -> ((Stream)remainAttStream.get()).map(ContentAttachment::getKey);
            this.databaseAdapter.deleteAttachments(deleteStream.get());
            Assertions.assertThat(this.attachments(remainKeyStream.get())).containsExactlyElementsOf((Iterable)remainAttStream.get().collect(Collectors.toList()));
            Assertions.assertThat(this.attachmentKeys(contentId)).containsExactlyInAnyOrderElementsOf((Iterable)remainKeyStream.get().collect(Collectors.toList()));
        });
    }

    @ParameterizedTest
    @ValueSource(ints={150, 250, 350, 1001})
    void manyAttachments(int numAttachments) {
        List<ContentAttachment> attachments = AbstractContentAttachments.createAttachments(numAttachments, 10240);
        String contentId = attachments.get(0).getKey().getContentId();
        Supplier<Stream> attStream = attachments::stream;
        Supplier<Stream> keyStream = () -> ((Stream)attStream.get()).map(ContentAttachment::getKey);
        this.databaseAdapter.putAttachments(attStream.get());
        Assertions.assertThat(this.attachments(keyStream.get())).containsExactlyElementsOf((Iterable)attStream.get().collect(Collectors.toList()));
        Assertions.assertThat(this.attachmentKeys(contentId)).containsExactlyInAnyOrderElementsOf((Iterable)keyStream.get().collect(Collectors.toList()));
    }

    @Test
    void manyAttachmentWriteReadCalls() {
        List<ContentAttachment> attachments = AbstractContentAttachments.createAttachments(1, 10);
        String contentId = attachments.get(0).getKey().getContentId();
        Supplier<Stream> attStream = attachments::stream;
        Supplier<Stream> keyStream = () -> ((Stream)attStream.get()).map(ContentAttachment::getKey);
        for (int i = 0; i < 20; ++i) {
            this.databaseAdapter.putAttachments(attStream.get());
            Assertions.assertThat(this.attachments(keyStream.get())).containsExactlyElementsOf((Iterable)attStream.get().collect(Collectors.toList()));
            Assertions.assertThat(this.attachmentKeys(contentId)).containsExactlyInAnyOrderElementsOf((Iterable)keyStream.get().collect(Collectors.toList()));
        }
    }
}

