/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.ReferencedAndUnreferencedHeads;
import org.projectnessie.versioned.persist.adapter.ReferencesUtil;
import org.projectnessie.versioned.persist.adapter.spi.AbstractDatabaseAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterConfigItem;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractCommitLogScan {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractCommitLogScan(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    static Stream<Arguments> commitsAndBranches() {
        return Stream.of(Arguments.of((Object[])new Object[]{5, 5}), Arguments.of((Object[])new Object[]{11, 3}));
    }

    @ParameterizedTest
    @MethodSource(value={"commitsAndBranches"})
    void scanCommits(int numBranches, int numCommits) throws Exception {
        IntFunction<BranchName> branch = branchNum -> BranchName.of((String)("scanCommits-" + branchNum));
        HashSet commits = new HashSet();
        this.prepareReferences(numCommits, numBranches, branch, (h, r) -> {}, h -> {}, (r, h) -> {}, commits::add);
        try (Stream entries = this.databaseAdapter.scanAllCommitLogEntries();){
            Assertions.assertThat((Stream)entries).map(CommitLogEntry::getHash).containsExactlyInAnyOrderElementsOf(commits);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"commitsAndBranches"})
    void identifyReferencedAndUnreferencedHeads(int numBranches, int numCommits, @NessieDbAdapter @NessieDbAdapterConfigItem(name="assumed.wall.clock.drift.micros", value="0") AbstractDatabaseAdapter<?, ?> databaseAdapter) throws Exception {
        IntFunction<BranchName> branch = branchNum -> BranchName.of((String)("collectAllHeads-" + branchNum));
        HashSet deletedHeads = new HashSet();
        HashMap<Hash, Set> liveHeads = new HashMap<Hash, Set>();
        HashMap<BranchName, Hash> refHeads = new HashMap<BranchName, Hash>();
        BiConsumer<Hash, NamedRef> addLive = (head, ref) -> liveHeads.computeIfAbsent((Hash)head, x -> new HashSet()).add(ref);
        this.prepareReferences(numCommits, numBranches, branch, addLive, deletedHeads::add, refHeads::put, h -> {});
        ReferencesUtil referencesUtil = ReferencesUtil.forDatabaseAdapter(databaseAdapter);
        HeadsAndForkPoints headsAndForkPoints = referencesUtil.identifyAllHeadsAndForkPoints(100, e -> {});
        ReferencedAndUnreferencedHeads refAndUnref = referencesUtil.identifyReferencedAndUnreferencedHeads(headsAndForkPoints);
        Assertions.assertThat((Collection)refAndUnref.getUnreferencedHeads()).isEqualTo(deletedHeads);
        Assertions.assertThat((Map)refAndUnref.getReferencedHeads()).isEqualTo(liveHeads);
        for (int branchNum2 = 0; branchNum2 < numBranches; ++branchNum2) {
            if ((branchNum2 & 3) != 1) continue;
            BranchName branchName = branch.apply(branchNum2);
            Hash head2 = (Hash)refHeads.get(branchName);
            ((Set)liveHeads.get(head2)).remove(branchName);
            if (((Set)liveHeads.get(head2)).isEmpty()) {
                liveHeads.remove(head2);
            }
            head2 = this.addCommits(numCommits, branchName, head2, h -> {});
            liveHeads.computeIfAbsent(head2, x -> new HashSet()).add(branchName);
            refHeads.put(branchName, head2);
        }
        refAndUnref = referencesUtil.identifyReferencedAndUnreferencedHeads(headsAndForkPoints);
        Assertions.assertThat((Collection)refAndUnref.getUnreferencedHeads()).isEqualTo(deletedHeads);
        Assertions.assertThat((Map)refAndUnref.getReferencedHeads()).isEqualTo(liveHeads);
    }

    private void prepareReferences(int numCommits, int numBranches, IntFunction<BranchName> branch, BiConsumer<Hash, NamedRef> addLiveHead, Consumer<Hash> addDeletedHead, BiConsumer<NamedRef, Hash> setRefHead, Consumer<Hash> committed) throws Exception {
        BranchName mainBranch = BranchName.of((String)"main");
        Hash root = this.addCommits(numCommits, mainBranch, this.databaseAdapter.noAncestorHash(), committed);
        addLiveHead.accept(root, (NamedRef)mainBranch);
        for (int branchNum = 0; branchNum < numBranches; ++branchNum) {
            BranchName branchName = branch.apply(branchNum);
            Hash head = this.databaseAdapter.create((NamedRef)branchName, root);
            head = this.addCommits(numCommits, branchName, head, committed);
            setRefHead.accept((NamedRef)branchName, head);
            try (Stream l = this.databaseAdapter.commitLog(head);){
                Hash tagHead = ((CommitLogEntry)l.skip(1L).limit(1L).findFirst().orElseThrow(IllegalStateException::new)).getHash();
                TagName tagName = TagName.of((String)("tag-" + branchName.getName()));
                this.databaseAdapter.create((NamedRef)tagName, tagHead);
                addLiveHead.accept(tagHead, (NamedRef)tagName);
                BranchName otherBranch = BranchName.of((String)("other-" + branchName.getName()));
                this.databaseAdapter.create((NamedRef)otherBranch, tagHead);
                addLiveHead.accept(tagHead, (NamedRef)otherBranch);
            }
            if ((branchNum & 1) == 0) {
                addDeletedHead.accept(head);
                this.databaseAdapter.delete((NamedRef)branchName, Optional.of(head));
                Assertions.assertThatThrownBy(() -> this.databaseAdapter.namedRef(branchName.getName(), GetNamedRefsParams.DEFAULT)).isInstanceOf(ReferenceNotFoundException.class);
                continue;
            }
            addLiveHead.accept(head, (NamedRef)branchName);
            Assertions.assertThatCode(() -> this.databaseAdapter.namedRef(branchName.getName(), GetNamedRefsParams.DEFAULT)).doesNotThrowAnyException();
        }
    }

    private Hash addCommits(int numCommits, BranchName branchName, Hash head, Consumer<Hash> committed) throws ReferenceConflictException, ReferenceNotFoundException {
        for (int commitNum = 0; commitNum < numCommits; ++commitNum) {
            Key key = Key.of((String[])new String[]{"many", "commits", Integer.toString(numCommits)});
            ContentId cid = ContentId.of((String)("cid-" + branchName.getName() + "-" + commitNum));
            OnRefOnly c = OnRefOnly.onRef((String)("value for #" + commitNum + " in " + branchName.getName()), (String)cid.getId());
            byte payload = DefaultStoreWorker.payloadForContent((Content)c);
            head = this.databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branchName).expectedHead(Optional.of(head)).commitMetaSerialized(ByteString.copyFromUtf8((String)("commit #" + commitNum + " in " + branchName.getName() + " of " + numCommits))).addPuts(KeyWithBytes.of((Key)key, (ContentId)cid, (byte)payload, (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)c, att -> {}))).build());
            committed.accept(head);
        }
        return head;
    }
}

