/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.tests.DatabaseAdapterTestUtils;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractManyCommits {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractManyCommits(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(ints={0, 1, 19, 20, 21, 49, 50, 51})
    void manyCommits(int numCommits) throws Exception {
        BranchName branch = BranchName.of((String)("manyCommits-" + numCommits));
        this.databaseAdapter.create((NamedRef)branch, this.databaseAdapter.hashOnReference((NamedRef)BranchName.of((String)"main"), Optional.empty()));
        Hash[] commits = new Hash[numCommits];
        ContentId fixed = ContentId.of((String)"FIXED");
        for (int i2 = 0; i2 < numCommits; ++i2) {
            Hash hash;
            Key key = Key.of((String[])new String[]{"many", "commits", Integer.toString(numCommits)});
            OnRefOnly c = OnRefOnly.onRef((String)("value for #" + i2 + " of " + numCommits), (String)fixed.getId());
            byte payload = DefaultStoreWorker.payloadForContent((Content)c);
            ImmutableCommitParams.Builder commit = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)("commit #" + i2 + " of " + numCommits))).addPuts(KeyWithBytes.of((Key)key, (ContentId)fixed, (byte)payload, (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)c, DatabaseAdapterTestUtils.ALWAYS_THROWING_ATTACHMENT_CONSUMER)));
            commits[i2] = hash = this.databaseAdapter.commit((CommitParams)commit.build());
        }
        try (Stream log = this.databaseAdapter.commitLog(this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty()));){
            Assertions.assertThat((long)log.count()).isEqualTo((long)numCommits);
        }
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(4, Runtime.getRuntime().availableProcessors()));
        try {
            CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])IntStream.range(0, numCommits).mapToObj(i -> () -> this.verify(i, numCommits, branch, commits[i], fixed)).map(r -> CompletableFuture.runAsync(r, executor)).toArray(CompletableFuture[]::new));
            combinedFuture.get();
        }
        finally {
            executor.shutdown();
        }
        this.databaseAdapter.delete((NamedRef)branch, Optional.empty());
    }

    private void verify(int i, int numCommits, BranchName branch, Hash commit, ContentId contentId) {
        Key key = Key.of((String[])new String[]{"many", "commits", Integer.toString(numCommits)});
        try {
            commit = this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.of(commit));
        }
        catch (ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            Map values = this.databaseAdapter.values(commit, Collections.singletonList(key), KeyFilterPredicate.ALLOW_ALL);
            OnRefOnly expected = OnRefOnly.onRef((String)("value for #" + i + " of " + numCommits), (String)contentId.getId());
            ByteString expectValue = DefaultStoreWorker.instance().toStoreOnReferenceState((Content)expected, DatabaseAdapterTestUtils.ALWAYS_THROWING_ATTACHMENT_CONSUMER);
            ContentAndState expect = ContentAndState.of((byte)DefaultStoreWorker.payloadForContent((Content)expected), (ByteString)expectValue);
            Assertions.assertThat((Map)values).containsExactly(new Map.Entry[]{Maps.immutableEntry((Object)key, (Object)expect)});
        }
        catch (ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
        try (Stream keys = this.databaseAdapter.keys(commit, KeyFilterPredicate.ALLOW_ALL);){
            Assertions.assertThat(keys.map(KeyListEntry::getKey)).containsExactly((Object[])new Key[]{key});
        }
        catch (ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

