/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests.extension;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterFactory;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionProvider;

public interface TestConnectionProviderSource<CONN_CONFIG extends DatabaseConnectionConfig> {
    public boolean isCompatibleWith(DatabaseAdapterConfig var1, DatabaseAdapterFactory<?, ?, ?, ?> var2);

    public CONN_CONFIG createDefaultConnectionProviderConfig();

    public void configureConnectionProviderConfigFromDefaults(Function<CONN_CONFIG, CONN_CONFIG> var1);

    public void setConnectionProviderConfig(CONN_CONFIG var1);

    public CONN_CONFIG getConnectionProviderConfig();

    public DatabaseConnectionProvider<CONN_CONFIG> getConnectionProvider();

    public void start() throws Exception;

    public void stop() throws Exception;

    public static <CONN_CONFIG extends DatabaseConnectionConfig> TestConnectionProviderSource<CONN_CONFIG> findCompatibleProviderSource(DatabaseAdapterConfig databaseAdapterConfig, DatabaseAdapterFactory<?, ?, ?, ?> databaseAdapterFactory, String providerSpec) {
        ArrayList<TestConnectionProviderSource> providerSources = new ArrayList<TestConnectionProviderSource>();
        for (TestConnectionProviderSource ps2 : ServiceLoader.load(TestConnectionProviderSource.class)) {
            if (!ps2.isCompatibleWith(databaseAdapterConfig, databaseAdapterFactory)) continue;
            providerSources.add(ps2);
        }
        if (providerSources.isEmpty()) {
            throw new IllegalStateException("No matching TestConnectionProviderSource found for " + databaseAdapterConfig);
        }
        if (providerSpec != null) {
            providerSources.removeIf(ps -> !ps.getClass().getName().toLowerCase(Locale.ROOT).contains(providerSpec));
        }
        if (providerSources.size() != 1) {
            throw new IllegalStateException("Too many TestConnectionProviderSource instances matched: " + providerSources.stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        return (TestConnectionProviderSource)providerSources.get(0);
    }
}

