/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.serialize;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.ContentIdWithType;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ImmutableKeyList;
import org.projectnessie.versioned.persist.adapter.ImmutableRefLog;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;

public class ProtoSerialization {
    public static AdapterTypes.CommitLogEntry toProto(CommitLogEntry entry) {
        AdapterTypes.CommitLogEntry.Builder proto = AdapterTypes.CommitLogEntry.newBuilder().setCreatedTime(entry.getCreatedTime()).setHash(entry.getHash().asBytes()).setCommitSeq(entry.getCommitSeq()).setMetadata(entry.getMetadata()).setKeyListDistance(entry.getKeyListDistance());
        entry.getParents().forEach(p -> proto.addParents(p.asBytes()));
        entry.getPuts().forEach(p -> proto.addPuts(ProtoSerialization.toProto(p)));
        entry.getDeletes().forEach(p -> proto.addDeletes(ProtoSerialization.keyToProto(p)));
        if (entry.getKeyList() != null) {
            entry.getKeyList().getKeys().forEach(k -> proto.addKeyList(ProtoSerialization.toProto(k)));
        }
        entry.getKeyListsIds().forEach(k -> proto.addKeyListIds(k.asBytes()));
        return proto.build();
    }

    public static CommitLogEntry protoToCommitLogEntry(ByteString serialized) {
        try {
            if (serialized == null) {
                return null;
            }
            AdapterTypes.CommitLogEntry proto = AdapterTypes.CommitLogEntry.parseFrom(serialized);
            return ProtoSerialization.protoToCommitLogEntry(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static CommitLogEntry protoToCommitLogEntry(byte[] bytes) {
        try {
            if (bytes == null) {
                return null;
            }
            AdapterTypes.CommitLogEntry proto = AdapterTypes.CommitLogEntry.parseFrom(bytes);
            return ProtoSerialization.protoToCommitLogEntry(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static CommitLogEntry protoToCommitLogEntry(AdapterTypes.CommitLogEntry proto) {
        ImmutableCommitLogEntry.Builder entry = ImmutableCommitLogEntry.builder().createdTime(proto.getCreatedTime()).hash(Hash.of((ByteString)proto.getHash())).commitSeq(proto.getCommitSeq()).metadata(proto.getMetadata()).keyListDistance(proto.getKeyListDistance());
        proto.getParentsList().forEach(p -> entry.addParents(Hash.of((ByteString)p)));
        proto.getPutsList().forEach(p -> entry.addPuts(ProtoSerialization.protoToKeyWithBytes(p)));
        proto.getDeletesList().forEach(p -> entry.addDeletes(ProtoSerialization.protoToKey(p)));
        if (!proto.getKeyListList().isEmpty()) {
            ImmutableKeyList.Builder kl = ImmutableKeyList.builder();
            proto.getKeyListList().forEach(kle -> kl.addKeys(ProtoSerialization.protoToKeyWithType(kle)));
            entry.keyList((KeyList)kl.build());
        }
        proto.getKeyListIdsList().forEach(p -> entry.addKeyListsIds(Hash.of((ByteString)p)));
        return entry.build();
    }

    public static AdapterTypes.ContentIdWithBytes toProto(ContentIdAndBytes x) {
        return AdapterTypes.ContentIdWithBytes.newBuilder().setContentId(AdapterTypes.ContentId.newBuilder().setId(x.getContentId().getId())).setType(x.getType()).setValue(x.getValue()).build();
    }

    public static ContentIdAndBytes protoToContentIdAndBytes(AdapterTypes.ContentIdWithBytes proto) {
        return ContentIdAndBytes.of((ContentId)ContentId.of((String)proto.getContentId().getId()), (byte)((byte)proto.getType()), (ByteString)proto.getValue());
    }

    public static AdapterTypes.ContentIdWithType toProto(ContentIdWithType x) {
        return AdapterTypes.ContentIdWithType.newBuilder().setContentId(AdapterTypes.ContentId.newBuilder().setId(x.getContentId().getId())).setType(x.getType()).build();
    }

    public static ContentIdWithType protoToContentIdWithType(AdapterTypes.ContentIdWithType proto) {
        return ContentIdWithType.of((ContentId)ContentId.of((String)proto.getContentId().getId()), (byte)((byte)proto.getType()));
    }

    public static AdapterTypes.KeyList toProto(KeyList x) {
        AdapterTypes.KeyList.Builder keyList = AdapterTypes.KeyList.newBuilder();
        for (KeyWithType key : x.getKeys()) {
            keyList.addKeys(ProtoSerialization.toProto(key));
        }
        return keyList.build();
    }

    public static KeyList protoToKeyList(ByteString serialized) {
        try {
            AdapterTypes.KeyList proto = AdapterTypes.KeyList.parseFrom(serialized);
            ImmutableKeyList.Builder keyList = ImmutableKeyList.builder();
            for (AdapterTypes.KeyWithType key : proto.getKeysList()) {
                keyList.addKeys(ProtoSerialization.protoToKeyWithType(key));
            }
            return keyList.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyList protoToKeyList(byte[] bytes) {
        try {
            AdapterTypes.KeyList proto = AdapterTypes.KeyList.parseFrom(bytes);
            ImmutableKeyList.Builder keyList = ImmutableKeyList.builder();
            for (AdapterTypes.KeyWithType key : proto.getKeysList()) {
                keyList.addKeys(ProtoSerialization.protoToKeyWithType(key));
            }
            return keyList.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static AdapterTypes.KeyWithBytes toProto(KeyWithBytes x) {
        return AdapterTypes.KeyWithBytes.newBuilder().setKey(ProtoSerialization.keyToProto(x.getKey())).setContentId(AdapterTypes.ContentId.newBuilder().setId(x.getContentId().getId())).setType(x.getType()).setValue(x.getValue()).build();
    }

    public static KeyWithBytes protoToKeyWithBytes(AdapterTypes.KeyWithBytes proto) {
        return KeyWithBytes.of((Key)Key.of((String[])((String[])proto.getKey().getElementList().toArray((Object[])new String[0]))), (ContentId)ContentId.of((String)proto.getContentId().getId()), (byte)((byte)proto.getType()), (ByteString)proto.getValue());
    }

    public static AdapterTypes.KeyWithType toProto(KeyWithType x) {
        return AdapterTypes.KeyWithType.newBuilder().setKey(ProtoSerialization.keyToProto(x.getKey())).setContentId(AdapterTypes.ContentId.newBuilder().setId(x.getContentId().getId())).setType(x.getType()).build();
    }

    public static KeyWithType protoToKeyWithType(AdapterTypes.KeyWithType proto) {
        return KeyWithType.of((Key)ProtoSerialization.protoToKey(proto.getKey()), (ContentId)ContentId.of((String)proto.getContentId().getId()), (byte)((byte)proto.getType()));
    }

    public static AdapterTypes.Key keyToProto(Key key) {
        return AdapterTypes.Key.newBuilder().addAllElement(key.getElements()).build();
    }

    public static RefLog protoToRefLog(ByteString serialized) {
        try {
            if (serialized == null) {
                return null;
            }
            AdapterTypes.RefLogEntry proto = AdapterTypes.RefLogEntry.parseFrom(serialized);
            return ProtoSerialization.protoToRefLog(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static RefLog protoToRefLog(byte[] bytes) {
        try {
            if (bytes == null) {
                return null;
            }
            AdapterTypes.RefLogEntry proto = AdapterTypes.RefLogEntry.parseFrom(bytes);
            return ProtoSerialization.protoToRefLog(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static RefLog protoToRefLog(AdapterTypes.RefLogEntry proto) {
        ImmutableRefLog.Builder entry = ImmutableRefLog.builder().refLogId(Hash.of((ByteString)proto.getRefLogId())).refName(proto.getRefName().toStringUtf8()).refType(proto.getRefType().name()).commitHash(Hash.of((ByteString)proto.getCommitHash())).operationTime(proto.getOperationTime()).operation(proto.getOperation().name());
        proto.getParentsList().forEach(parentId -> entry.addParents(Hash.of((ByteString)parentId)));
        proto.getSourceHashesList().forEach(hash -> entry.addSourceHashes(Hash.of((ByteString)hash)));
        return entry.build();
    }

    public static Key protoToKey(AdapterTypes.Key key) {
        return Key.of((String[])((String[])key.getElementList().toArray((Object[])new String[0])));
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T parse(byte[] var1) throws InvalidProtocolBufferException;
    }
}

