/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.nontx;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.persist.adapter.RefLog;

final class RefLogSpliterator
extends Spliterators.AbstractSpliterator<RefLog> {
    private final List<RefLogSplit> splits;
    private RefLog initialRefLog;
    private boolean eof;

    RefLogSpliterator(Hash initialHash, Stream<Spliterator<RefLog>> refLogStripeFetcher) throws RefLogNotFoundException {
        block1: {
            RefLog refLog;
            super(Long.MAX_VALUE, 0);
            this.splits = refLogStripeFetcher.map(x$0 -> new RefLogSplit((Spliterator)x$0)).collect(Collectors.toList());
            if (initialHash == null) break block1;
            do {
                if ((refLog = this.tryNext()) != null) continue;
                throw RefLogNotFoundException.forRefLogId((String)initialHash.asString());
            } while (!refLog.getRefLogId().equals(initialHash));
            this.initialRefLog = refLog;
        }
    }

    private RefLog tryNext() {
        if (this.eof) {
            return null;
        }
        Optional<RefLogSplit> oldest = this.splits.stream().filter(RefLogSplit::hasMore).max(Comparator.comparing(RefLogSplit::operationTime));
        if (!oldest.isPresent()) {
            this.eof = true;
            return null;
        }
        RefLog refLog = oldest.get().pull();
        if (refLog == null) {
            this.eof = true;
        }
        return refLog;
    }

    @Override
    public boolean tryAdvance(Consumer<? super RefLog> action) {
        if (this.eof) {
            return false;
        }
        if (this.initialRefLog != null) {
            action.accept((RefLog)this.initialRefLog);
            this.initialRefLog = null;
            return true;
        }
        RefLog refLog = this.tryNext();
        if (refLog != null) {
            action.accept((RefLog)refLog);
            return true;
        }
        return false;
    }

    private static final class RefLogSplit {
        private final Spliterator<RefLog> source;
        private boolean exhausted;
        private RefLog current;

        private RefLogSplit(Spliterator<RefLog> source) {
            this.source = source;
        }

        private void advance() {
            if (this.exhausted) {
                return;
            }
            this.current = null;
            if (!this.source.tryAdvance(refLog -> {
                this.current = refLog;
            })) {
                this.exhausted = true;
            }
        }

        private void maybeAdvance() {
            if (this.current == null) {
                this.advance();
            }
        }

        RefLog pull() {
            if (this.exhausted) {
                return null;
            }
            this.maybeAdvance();
            RefLog r = this.current;
            if (r != null) {
                this.current = null;
            }
            return r;
        }

        long operationTime() {
            this.maybeAdvance();
            return this.current != null ? this.current.getOperationTime() : 0L;
        }

        boolean hasMore() {
            this.maybeAdvance();
            return this.current != null;
        }

        public String toString() {
            return "RefLogSplit{exhausted=" + this.exhausted + ", current=" + this.current + '}';
        }
    }
}

