/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.nontx;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.projectnessie.versioned.persist.tests.AbstractDatabaseAdapterTest;
import org.projectnessie.versioned.persist.tests.LongerCommitTimeouts;

public abstract class AbstractNonTxDatabaseAdapterTest
extends AbstractDatabaseAdapterTest {
    private static Set<String> fetchCurrentReferenceNames(NonTransactionalDatabaseAdapter<?> nontx, NonTransactionalOperationContext ctx) {
        List allNames = StreamSupport.stream(nontx.fetchReferenceNames(ctx), false).flatMap(names -> names.getRefNamesList().stream()).collect(Collectors.toList());
        HashSet<String> namesSet = new HashSet<String>(allNames);
        Assertions.assertThat(allNames).containsExactlyInAnyOrderElementsOf(namesSet);
        return namesSet;
    }

    @Test
    void namedRefsIndex() {
        NonTransactionalDatabaseAdapter nontx = (NonTransactionalDatabaseAdapter)databaseAdapter;
        IntFunction<String> nameGenerator = i -> "branch-" + i + "nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn";
        Set testNames = IntStream.range(0, 100).mapToObj(nameGenerator).collect(Collectors.toSet());
        Set testBranches = testNames.stream().map(BranchName::of).collect(Collectors.toSet());
        Assertions.assertThat(testBranches).hasSize(100);
        Hash head = nontx.noAncestorHash();
        AdapterTypes.RefPointer headRef = AdapterTypes.RefPointer.newBuilder().setType(AdapterTypes.RefType.Branch).setHash(head.asBytes()).build();
        try (NonTransactionalOperationContext ctx = nontx.borrowConnection();){
            for (BranchName branchName : testBranches) {
                boolean createSuccess = nontx.createNamedReference(ctx, (NamedRef)branchName, head);
                Assertions.assertThat((boolean)createSuccess).isTrue();
            }
            Assertions.assertThat(AbstractNonTxDatabaseAdapterTest.fetchCurrentReferenceNames(nontx, ctx)).containsAll(testNames);
            for (BranchName branchName : testBranches) {
                boolean deleteSuccess = nontx.deleteNamedReference(ctx, (NamedRef)branchName, headRef);
                Assertions.assertThat((boolean)deleteSuccess).isTrue();
            }
            Assertions.assertThat(AbstractNonTxDatabaseAdapterTest.fetchCurrentReferenceNames(nontx, ctx)).doesNotContainAnyElementsOf(testNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(ints={10, 100, 200, 1000})
    void migrateNamedReferencesFromGlobalPointer(int numNamedRefs) throws Exception {
        Assumptions.assumeThat((numNamedRefs <= 200 || !(this instanceof LongerCommitTimeouts) ? 1 : 0) != 0).isTrue();
        NonTransactionalDatabaseAdapter nontx = (NonTransactionalDatabaseAdapter)databaseAdapter;
        int numThreads = 3;
        HashSet<AdapterTypes.NamedReference> createdRefs = new HashSet<AdapterTypes.NamedReference>();
        try (NonTransactionalOperationContext ctx = nontx.borrowConnection();){
            AdapterTypes.GlobalStatePointer globalPointer = nontx.fetchGlobalPointer(ctx);
            Assertions.assertThat((Object)globalPointer).extracting(AdapterTypes.GlobalStatePointer::getNamedReferencesCount).isEqualTo((Object)0);
            AdapterTypes.GlobalStatePointer.Builder newPointer = globalPointer.toBuilder().setGlobalId(DatabaseAdapterUtil.randomHash().asBytes());
            AdapterTypes.RefPointer head = nontx.fetchNamedReference(ctx, "main").getRef();
            IntFunction<String> refName = i -> "ref-" + i;
            for (int i2 = 0; i2 < numNamedRefs; ++i2) {
                AdapterTypes.NamedReference ref = AdapterTypes.NamedReference.newBuilder().setName(refName.apply(i2)).setRef(head.toBuilder().setHash(DatabaseAdapterUtil.randomHash().asBytes())).build();
                newPointer.addNamedReferences(ref);
                createdRefs.add(ref);
            }
            Assertions.assertThat((boolean)nontx.globalPointerCas(ctx, globalPointer, newPointer.build())).isTrue();
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            try {
                CountDownLatch readyLatch = new CountDownLatch(numThreads);
                CountDownLatch startLatch = new CountDownLatch(1);
                CountDownLatch doneLatch = new CountDownLatch(numThreads);
                List futures = IntStream.range(0, numThreads).mapToObj(i -> executor.submit(() -> {
                    readyLatch.countDown();
                    Preconditions.checkState((boolean)startLatch.await(5L, TimeUnit.MINUTES));
                    try {
                        Stream ignore = nontx.fetchNamedReferences(ctx);
                        if (ignore != null) {
                            ignore.close();
                        }
                    }
                    finally {
                        doneLatch.countDown();
                    }
                    return null;
                })).collect(Collectors.toList());
                Preconditions.checkState((boolean)readyLatch.await(5L, TimeUnit.MINUTES));
                startLatch.countDown();
                Preconditions.checkState((boolean)doneLatch.await(20L, TimeUnit.MINUTES));
                Assertions.assertThat(futures).allSatisfy(f -> Assertions.assertThatCode(() -> f.get(1L, TimeUnit.MINUTES)).doesNotThrowAnyException());
            }
            finally {
                executor.shutdown();
            }
            Assertions.assertThat((List)nontx.fetchGlobalPointer(ctx).getNamedReferencesList()).isEmpty();
            try (Stream namedRefs = nontx.fetchNamedReferences(ctx);){
                Assertions.assertThat(namedRefs.filter(nr -> !"main".equals(nr.getName()))).containsExactlyInAnyOrderElementsOf(createdRefs);
            }
            Assertions.assertThat(createdRefs).allSatisfy(namedRef -> Assertions.assertThat((Object)nontx.fetchNamedReference(ctx, namedRef.getName())).isEqualTo(namedRef));
        }
    }
}

