/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.dynamodb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BackendLimitExceededException;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.serialize.ProtoSerialization;
import org.projectnessie.versioned.persist.dynamodb.DynamoDatabaseClient;
import org.projectnessie.versioned.persist.dynamodb.Tables;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class DynamoDatabaseAdapter
extends NonTransactionalDatabaseAdapter<NonTransactionalDatabaseAdapterConfig> {
    private static final int DYNAMO_BATCH_WRITE_MAX_REQUESTS = 25;
    private static final int DYNAMO_MAX_ITEM_SIZE = 384000;
    private static final char PREFIX_SEPARATOR = ':';
    private final DynamoDatabaseClient client;
    private final String keyPrefix;
    private final Map<String, AttributeValue> globalPointerKeyMap;

    public DynamoDatabaseAdapter(NonTransactionalDatabaseAdapterConfig config, DynamoDatabaseClient c, AdapterEventConsumer eventConsumer) {
        super(config, eventConsumer);
        Objects.requireNonNull(c, "Requires a non-null DynamoDatabaseClient from DynamoDatabaseAdapterConfig");
        this.client = c;
        String keyPrefix = config.getRepositoryId();
        if (keyPrefix.indexOf(58) >= 0) {
            throw new IllegalArgumentException("Invalid key prefix: " + keyPrefix);
        }
        this.keyPrefix = keyPrefix + ':';
        this.globalPointerKeyMap = Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix).build());
    }

    @Nonnull
    @VisibleForTesting
    static RuntimeException unhandledException(String operation, RuntimeException e) {
        if (e instanceof RequestLimitExceededException) {
            return new BackendLimitExceededException(String.format("Dynamo request-limit exceeded during %s.", operation), (Throwable)e);
        }
        if (e instanceof LimitExceededException) {
            return new BackendLimitExceededException(String.format("Dynamo limit exceeded during %s.", operation), (Throwable)e);
        }
        if (e instanceof ProvisionedThroughputExceededException) {
            return new BackendLimitExceededException(String.format("Dynamo provisioned throughput exceeded during %s.", operation), (Throwable)e);
        }
        return e;
    }

    protected void doEraseRepo() {
        this.client.client.deleteItem(b -> b.tableName("global_pointer").key(this.globalPointerKeyMap));
        try (BatchDelete batchDelete = new BatchDelete();){
            Tables.allExceptGlobalPointer().filter(t -> !"global_pointer".equals(t)).forEach(table -> this.client.client.scanPaginator(b -> b.tableName(table).scanFilter(this.repositoryScanFilter())).forEach(r -> r.items().stream().map(attrs -> (AttributeValue)attrs.get("key")).filter(key -> key.s().startsWith(this.keyPrefix)).forEach(key -> batchDelete.add((String)table, (AttributeValue)key))));
        }
    }

    private <T> T loadById(String table, Hash id, ProtoSerialization.Parser<T> parser) {
        return this.loadById(table, id.asString(), parser);
    }

    private <T> T loadById(String table, String id, ProtoSerialization.Parser<T> parser) {
        byte[] data = this.loadById(table, id);
        try {
            return (T)(data != null ? parser.parse(data) : null);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] loadById(String table, String id) {
        Map<String, AttributeValue> key = Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + id).build());
        GetItemResponse response = this.client.client.getItem(b -> b.tableName(table).key(key));
        if (!response.hasItem()) {
            return null;
        }
        Map attributes = response.item();
        SdkBytes bytes = ((AttributeValue)attributes.get("val")).b();
        return bytes.asByteArray();
    }

    protected int attachmentChunkSize() {
        return Math.min(super.attachmentChunkSize(), 25);
    }

    protected AdapterTypes.GlobalStatePointer doFetchGlobalPointer(NonTransactionalOperationContext ctx) {
        return (AdapterTypes.GlobalStatePointer)this.loadById("global_pointer", "", AdapterTypes.GlobalStatePointer::parseFrom);
    }

    protected CommitLogEntry doFetchFromCommitLog(NonTransactionalOperationContext ctx, Hash hash) {
        return (CommitLogEntry)this.loadById("commit_log", hash, ProtoSerialization::protoToCommitLogEntry);
    }

    protected AdapterTypes.GlobalStateLogEntry doFetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        return (AdapterTypes.GlobalStateLogEntry)this.loadById("global_log", id, AdapterTypes.GlobalStateLogEntry::parseFrom);
    }

    protected List<CommitLogEntry> doFetchMultipleFromCommitLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPageResult("commit_log", hashes, ProtoSerialization::protoToCommitLogEntry);
    }

    protected List<AdapterTypes.GlobalStateLogEntry> doFetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPageResult("global_log", hashes, AdapterTypes.GlobalStateLogEntry::parseFrom);
    }

    protected Stream<KeyListEntity> doFetchKeyLists(NonTransactionalOperationContext ctx, List<Hash> keyListsIds) {
        Map map = this.fetchPage("key_lists", keyListsIds, ProtoSerialization::protoToKeyList);
        return keyListsIds.stream().map(h -> map.containsKey(h) ? KeyListEntity.of((Hash)h, (KeyList)((KeyList)map.get(h))) : null);
    }

    protected void doWriteIndividualCommit(NonTransactionalOperationContext ctx, CommitLogEntry entry) {
        this.insert("commit_log", entry.getHash().asString(), ProtoSerialization.toProto((CommitLogEntry)entry).toByteArray());
    }

    protected void unsafeWriteGlobalPointer(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) {
        this.insert("global_pointer", "", pointer.toByteArray());
    }

    protected void doWriteMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) {
        this.persistMultipleCommits(entries);
    }

    protected void doUpdateMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) {
        this.persistMultipleCommits(entries);
    }

    private void persistMultipleCommits(List<CommitLogEntry> entries) {
        this.batchWrite("commit_log", entries, e -> e.getHash().asString(), e -> ProtoSerialization.toProto((CommitLogEntry)e).toByteArray(), e -> Collections.emptyMap());
    }

    protected void doWriteKeyListEntities(NonTransactionalOperationContext ctx, List<KeyListEntity> newKeyListEntities) {
        this.batchWrite("key_lists", newKeyListEntities, e -> e.getId().asString(), e -> ProtoSerialization.toProto((KeyList)e.getKeys()).toByteArray(), e -> Collections.emptyMap());
    }

    protected boolean doGlobalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        AttributeValue expectedBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])expected.toByteArray())).build();
        AttributeValue newPointerBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])newPointer.toByteArray())).build();
        try {
            this.client.client.updateItem(b -> b.tableName("global_pointer").key(this.globalPointerKeyMap).expected(Collections.singletonMap("val", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(expectedBytes).build())).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(newPointerBytes).build())));
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    protected void doCleanUpCommitCas(NonTransactionalOperationContext ctx, Set<Hash> branchCommits, Set<Hash> newKeyLists) {
        try (BatchDelete batchDelete = new BatchDelete();){
            branchCommits.forEach(h -> batchDelete.add("commit_log", (Hash)h));
            newKeyLists.forEach(h -> batchDelete.add("key_lists", (Hash)h));
        }
    }

    protected void doCleanUpRefLogWrite(NonTransactionalOperationContext ctx, Hash refLogId) {
        this.client.client.deleteItem(b -> b.tableName("ref_log").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + refLogId.asString()).build())));
    }

    protected RepoDescription doFetchRepositoryDescription(NonTransactionalOperationContext ctx) {
        return (RepoDescription)this.loadById("repo_desc", "", ProtoSerialization::protoToRepoDescription);
    }

    protected boolean doTryUpdateRepositoryDescription(NonTransactionalOperationContext ctx, RepoDescription expected, RepoDescription updateTo) {
        AttributeValue updateToBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])ProtoSerialization.toProto((RepoDescription)updateTo).toByteArray())).build();
        try {
            if (expected != null) {
                AttributeValue expectedBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])ProtoSerialization.toProto((RepoDescription)expected).toByteArray())).build();
                this.client.client.updateItem(b -> b.tableName("repo_desc").key(this.globalPointerKeyMap).expected(Collections.singletonMap("val", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(expectedBytes).build())).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(updateToBytes).build())));
            } else {
                this.client.client.putItem(b -> b.tableName("repo_desc").item((Map)ImmutableMap.of((Object)"key", (Object)this.globalPointerKeyMap.get("key"), (Object)"val", (Object)updateToBytes)).conditionExpression(String.format("attribute_not_exists(%s)", "val")));
            }
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    protected void unsafeWriteRefLogStripe(NonTransactionalOperationContext ctx, int stripe, AdapterTypes.RefLogParents refLogParents) {
        this.insert("ref_log_heads", Integer.toString(stripe), refLogParents.toByteArray());
    }

    protected boolean doRefLogParentsCas(NonTransactionalOperationContext ctx, int stripe, AdapterTypes.RefLogParents previousEntry, AdapterTypes.RefLogParents newEntry) {
        Map<String, ExpectedAttributeValue> expected = previousEntry != null ? Collections.singletonMap("val", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value((AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])previousEntry.toByteArray())).build()).build()) : Collections.singletonMap("key", (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build());
        AttributeValue newPointerBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])newEntry.toByteArray())).build();
        try {
            this.client.client.updateItem(b -> b.tableName("ref_log_heads").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + stripe).build())).expected(expected).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(newPointerBytes).build())));
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    protected AdapterTypes.RefLogParents doFetchRefLogParents(NonTransactionalOperationContext ctx, int stripe) {
        return (AdapterTypes.RefLogParents)this.loadById("ref_log_heads", Integer.toString(stripe), AdapterTypes.RefLogParents::parseFrom);
    }

    protected List<AdapterTypes.ReferenceNames> doFetchReferenceNames(NonTransactionalOperationContext ctx, int segment, int prefetchSegments) {
        Map<Integer, AdapterTypes.ReferenceNames> result = this.fetchPage("ref_names", IntStream.rangeClosed(segment, segment + prefetchSegments).boxed().collect(Collectors.toList()), v -> v != null ? AdapterTypes.ReferenceNames.newBuilder().addAllRefNames((Iterable)v.ss()).build() : AdapterTypes.ReferenceNames.getDefaultInstance(), Object::toString, Integer::parseInt);
        return IntStream.rangeClosed(segment, segment + prefetchSegments).mapToObj(result::get).collect(Collectors.toList());
    }

    protected void doAddToNamedReferences(NonTransactionalOperationContext ctx, Stream<NamedRef> refStream, int addToSegment) {
        Map<String, AttributeValue> key = Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + addToSegment).build());
        this.client.client.updateItem(updateItem -> updateItem.tableName("ref_names").key(key).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.ADD).value(b -> b.ss((Collection)refStream.map(NamedRef::getName).collect(Collectors.toList()))).build())));
    }

    protected void doRemoveFromNamedReferences(NonTransactionalOperationContext ctx, NamedRef ref, int removeFromSegment) {
        Map<String, AttributeValue> key = Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + removeFromSegment).build());
        this.client.client.updateItem(update -> update.tableName("ref_names").key(key).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.DELETE).value(b -> b.ss(new String[]{ref.getName()})).build())));
    }

    protected List<AdapterTypes.NamedReference> doFetchNamedReference(NonTransactionalOperationContext ctx, List<String> refNames) {
        Map<String, AdapterTypes.NamedReference> page = this.fetchPage("ref_heads", refNames, av -> {
            try {
                return AdapterTypes.NamedReference.parseFrom((byte[])av.b().asByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }, Function.identity(), Function.identity());
        return new ArrayList<AdapterTypes.NamedReference>(page.values());
    }

    protected boolean doCreateNamedReference(NonTransactionalOperationContext ctx, AdapterTypes.NamedReference namedReference) {
        AttributeValue newPointerBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])namedReference.toByteArray())).build();
        try {
            this.client.client.updateItem(b -> b.tableName("ref_heads").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + namedReference.getName()).build())).expected(Collections.singletonMap("key", (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(newPointerBytes).build())));
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    protected boolean doDeleteNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead) {
        AdapterTypes.NamedReference namedReference = AdapterTypes.NamedReference.newBuilder().setName(ref.getName()).setRef(refHead).build();
        AttributeValue expectedBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])namedReference.toByteArray())).build();
        try {
            this.client.client.deleteItem(b -> b.tableName("ref_heads").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + ref.getName()).build())).expected(Collections.singletonMap("val", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(expectedBytes).build())));
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    protected boolean doUpdateNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead, Hash newHead) {
        AdapterTypes.NamedReference namedReference = AdapterTypes.NamedReference.newBuilder().setName(ref.getName()).setRef(refHead).build();
        AdapterTypes.NamedReference newNamedReference = AdapterTypes.NamedReference.newBuilder().setName(ref.getName()).setRef(refHead.toBuilder().setHash(newHead.asBytes())).build();
        AttributeValue expectedBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])namedReference.toByteArray())).build();
        AttributeValue newPointerBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])newNamedReference.toByteArray())).build();
        try {
            this.client.client.updateItem(b -> b.tableName("ref_heads").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + ref.getName()).build())).expected(Collections.singletonMap("val", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(expectedBytes).build())).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(newPointerBytes).build())));
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    protected int maxEntitySize(int value) {
        return Math.min(value, 384000);
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyListEntry entry) {
        return ProtoSerialization.toProto((KeyListEntry)entry).getSerializedSize();
    }

    private <T> List<T> fetchPageResult(String table, List<Hash> hashes, ProtoSerialization.Parser<T> parser) {
        Map<Hash, T> map = this.fetchPage(table, hashes, parser);
        return hashes.stream().map(map::get).collect(Collectors.toList());
    }

    private <T> Map<Hash, T> fetchPage(String table, List<Hash> hashes, ProtoSerialization.Parser<T> parser) {
        return this.fetchPage(table, hashes, v -> {
            try {
                return parser.parse(v.b().asByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }, Hash::asString, Hash::of);
    }

    private <I, T> Map<I, T> fetchPage(String table, List<I> ids, Function<AttributeValue, T> parser, Function<I, String> keyToString, Function<String, I> stringToKey) {
        List keys = ids.stream().map(k -> this.keyPrefix + (String)keyToString.apply(k)).map(k -> (AttributeValue)AttributeValue.builder().s(k).build()).map(k -> Collections.singletonMap("key", k)).collect(Collectors.toList());
        Map<String, KeysAndAttributes> requestItems = Collections.singletonMap(table, (KeysAndAttributes)KeysAndAttributes.builder().attributesToGet(new String[]{"key", "val"}).keys(keys).build());
        BatchGetItemResponse response = this.client.client.batchGetItem(b -> b.requestItems(requestItems));
        if (!response.hasResponses()) {
            return Collections.emptyMap();
        }
        if (response.hasUnprocessedKeys() && !response.unprocessedKeys().isEmpty()) {
            throw new IllegalArgumentException("Requested too many keys, unprocessed keys: " + response.unprocessedKeys());
        }
        List items = (List)response.responses().get(table);
        return items.stream().collect(Collectors.toMap(m -> stringToKey.apply(((AttributeValue)m.get("key")).s().substring(this.keyPrefix.length())), m -> parser.apply((AttributeValue)m.get("val"))));
    }

    private void insert(String table, String key, byte[] data) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + key).build());
        item.put("val", (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])data)).build());
        this.client.client.putItem(b -> b.tableName(table).item(item));
    }

    private <T> void batchWrite(String tableName, List<T> entries, Function<T, String> id, Function<T, byte[]> serializer, Function<T, Map<String, AttributeValue>> itemEnhancer) {
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<WriteRequest> requests = new ArrayList<WriteRequest>();
        for (T entry : entries) {
            HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            String key = this.keyPrefix + id.apply(entry);
            item.put("key", (AttributeValue)AttributeValue.builder().s(key).build());
            item.put("val", (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])serializer.apply(entry))).build());
            item.putAll(itemEnhancer.apply(entry));
            if (requests.size() == 25) {
                this.client.client.batchWriteItem(b -> b.requestItems(Collections.singletonMap(tableName, requests)));
                requests.clear();
            }
            WriteRequest write = (WriteRequest)WriteRequest.builder().putRequest(b -> b.item(item)).build();
            requests.add(write);
        }
        this.client.client.batchWriteItem(b -> b.requestItems(Collections.singletonMap(tableName, requests)));
    }

    protected void doWriteRefLog(NonTransactionalOperationContext ctx, AdapterTypes.RefLogEntry entry) {
        this.insert("ref_log", Hash.of((ByteString)entry.getRefLogId()).asString(), entry.toByteArray());
    }

    protected RefLog doFetchFromRefLog(NonTransactionalOperationContext ctx, Hash refLogId) {
        Objects.requireNonNull(refLogId, "refLogId mut not be null");
        return (RefLog)this.loadById("ref_log", refLogId, ProtoSerialization::protoToRefLog);
    }

    protected List<RefLog> doFetchPageFromRefLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPageResult("ref_log", hashes, ProtoSerialization::protoToRefLog);
    }

    protected Stream<CommitLogEntry> doScanAllCommitLogEntries(NonTransactionalOperationContext c) {
        return this.client.client.scanPaginator(b -> b.tableName("commit_log").scanFilter(this.repositoryScanFilter())).stream().flatMap(scanResponse -> scanResponse.items().stream().map(item -> (AttributeValue)item.get("val")).map(AttributeValue::b).map(BytesWrapper::asByteArray).map(ProtoSerialization::protoToCommitLogEntry));
    }

    private Map<String, Condition> repositoryScanFilter() {
        return Collections.singletonMap("key", (Condition)Condition.builder().comparisonOperator(ComparisonOperator.BEGINS_WITH).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(this.keyPrefix).build()}).build());
    }

    protected void writeAttachments(Stream<Map.Entry<AdapterTypes.AttachmentKey, AdapterTypes.AttachmentValue>> attachments) {
        List attachmentsList = attachments.collect(Collectors.toList());
        HashMap<String, List> keys = new HashMap<String, List>();
        for (Map.Entry entry : attachmentsList) {
            keys.computeIfAbsent(((AdapterTypes.AttachmentKey)entry.getKey()).getContentId().getId(), i -> new ArrayList()).add((AdapterTypes.AttachmentKey)entry.getKey());
        }
        for (Map.Entry entry : keys.entrySet()) {
            this.client.client.updateItem(updateItem -> updateItem.tableName("attachment_keys").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + (String)e2.getKey()).build())).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.ADD).value(b -> b.ss((Collection)((List)e2.getValue()).stream().map(ProtoSerialization::attachmentKeyAsString).collect(Collectors.toList()))).build())));
        }
        this.batchWrite("attachments", attachmentsList, e -> ProtoSerialization.attachmentKeyAsString((AdapterTypes.AttachmentKey)((AdapterTypes.AttachmentKey)e.getKey())), e -> ((AdapterTypes.AttachmentValue)e.getValue()).toByteArray(), e -> {
            AdapterTypes.AttachmentValue v = (AdapterTypes.AttachmentValue)e.getValue();
            if (!v.hasVersion()) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap("ver", (AttributeValue)AttributeValue.builder().s(v.getVersion()).build());
        });
    }

    protected boolean consistentWriteAttachment(AdapterTypes.AttachmentKey key, AdapterTypes.AttachmentValue value, Optional<String> expectedVersion) {
        AttributeValue newValueBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])value.toByteArray())).build();
        AttributeValue newVersion = (AttributeValue)AttributeValue.builder().s(value.getVersion()).build();
        Map<String, AttributeValue> keyMap = Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + ProtoSerialization.attachmentKeyAsString((AdapterTypes.AttachmentKey)key)).build());
        UpdateItemRequest.Builder b = UpdateItemRequest.builder().tableName("attachments").key(keyMap).attributeUpdates((Map)ImmutableMap.of((Object)"ver", (Object)((AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(newVersion).build()), (Object)"val", (Object)((AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(newValueBytes).build())));
        if (expectedVersion.isPresent()) {
            AttributeValue expectedVersionValue = (AttributeValue)AttributeValue.builder().s(expectedVersion.get()).build();
            b = b.expected(Collections.singletonMap("ver", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(expectedVersionValue).build()));
        } else {
            b = b.expected(Collections.singletonMap("key", (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build()));
        }
        try {
            this.client.client.updateItem((UpdateItemRequest)b.build());
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
        this.client.client.updateItem(updateItem -> updateItem.tableName("attachment_keys").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + key.getContentId().getId()).build())).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.ADD).value(v -> v.ss(new String[]{ProtoSerialization.attachmentKeyAsString((AdapterTypes.AttachmentKey)key)})).build())));
        return true;
    }

    protected Stream<AdapterTypes.AttachmentKey> fetchAttachmentKeys(String contentId) {
        GetItemResponse keysList = this.client.client.getItem(g -> g.tableName("attachment_keys").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + contentId).build())));
        if (!keysList.hasItem()) {
            return Stream.empty();
        }
        AttributeValue value = (AttributeValue)keysList.item().get("val");
        return value == null ? Stream.empty() : value.ss().stream().map(ProtoSerialization::attachmentKeyFromString);
    }

    protected Stream<Map.Entry<AdapterTypes.AttachmentKey, AdapterTypes.AttachmentValue>> fetchAttachments(Stream<AdapterTypes.AttachmentKey> keys) {
        List keysList = keys.map(ProtoSerialization::attachmentKeyAsString).collect(Collectors.toList());
        Map fetched = this.fetchPage("attachments", keysList, av -> {
            try {
                return AdapterTypes.AttachmentValue.parseFrom((byte[])av.b().asByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }, Function.identity(), Function.identity());
        return keysList.stream().filter(fetched::containsKey).map(k -> {
            AdapterTypes.AttachmentValue value = (AdapterTypes.AttachmentValue)fetched.get(k);
            return Maps.immutableEntry((Object)ProtoSerialization.attachmentKeyFromString((String)k), (Object)value);
        });
    }

    protected void purgeAttachments(Stream<AdapterTypes.AttachmentKey> keys) {
        keys.forEach(k -> {
            String keyAsString = ProtoSerialization.attachmentKeyAsString((AdapterTypes.AttachmentKey)k);
            String dbKeyAttachment = this.keyPrefix + keyAsString;
            this.client.client.deleteItem(delete -> delete.tableName("attachments").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(dbKeyAttachment).build())));
            String dbKeyList = this.keyPrefix + k.getContentId().getId();
            this.client.client.updateItem(update -> update.tableName("attachment_keys").key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(dbKeyList).build())).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.DELETE).value(v -> v.ss(new String[]{keyAsString})).build())));
        });
    }

    private final class BatchDelete
    implements AutoCloseable {
        private final Map<String, List<WriteRequest>> requestItems = new HashMap<String, List<WriteRequest>>();
        private int requests;

        private BatchDelete() {
        }

        void add(String table, Hash hash) {
            this.add(table, (AttributeValue)AttributeValue.builder().s(DynamoDatabaseAdapter.this.keyPrefix + hash.asString()).build());
        }

        void add(String table, AttributeValue key) {
            this.requestItems.computeIfAbsent(table, t -> new ArrayList()).add((WriteRequest)WriteRequest.builder().deleteRequest(b -> b.key(Collections.singletonMap("key", key))).build());
            ++this.requests;
            if (this.requests == 25) {
                this.close();
            }
        }

        @Override
        public void close() {
            if (this.requests > 0) {
                ((DynamoDatabaseAdapter)DynamoDatabaseAdapter.this).client.client.batchWriteItem(b -> b.requestItems(this.requestItems));
                this.requestItems.clear();
                this.requests = 0;
            }
        }
    }
}

