/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.dynamodb;

import java.util.Optional;
import java.util.function.Consumer;
import org.projectnessie.versioned.persist.dynamodb.DynamoClientConfig;
import org.projectnessie.versioned.persist.dynamodb.DynamoDatabaseClient;
import org.projectnessie.versioned.persist.dynamodb.DynamoTestConnectionProviderSource;
import org.projectnessie.versioned.persist.dynamodb.ImmutableDefaultDynamoClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public class LocalDynamoTestConnectionProviderSource
extends DynamoTestConnectionProviderSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDynamoTestConnectionProviderSource.class);
    public static final int DYNAMODB_PORT = 8000;
    private GenericContainer<?> container;
    private String endpointURI;

    @Override
    public DynamoClientConfig createDefaultConnectionProviderConfig() {
        return ImmutableDefaultDynamoClientConfig.builder().build();
    }

    @Override
    public DynamoDatabaseClient createConnectionProvider() {
        return new DynamoDatabaseClient();
    }

    public void start() throws Exception {
        this.startDynamo();
        this.configureConnectionProviderConfigFromDefaults(c -> ImmutableDefaultDynamoClientConfig.builder().endpointURI(this.endpointURI).region("US_WEST_2").credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"xxx", (String)"xxx"))).build());
        super.start();
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public void startDynamo() {
        this.startDynamo(Optional.empty(), false);
    }

    public void startDynamo(Optional<String> containerNetworkId, boolean quiet) {
        if (this.container != null) {
            throw new IllegalStateException("Already started");
        }
        String version = System.getProperty("it.nessie.container.dynamodb-local.tag", "latest");
        String imageName = "amazon/dynamodb-local:" + version;
        if (!quiet) {
            LOGGER.info("Starting Dynamo test container (network-id: {})", containerNetworkId);
        }
        int retry = 0;
        while (true) {
            GenericContainer c = new GenericContainer(imageName).withLogConsumer((Consumer)(quiet ? outputFrame -> {} : new Slf4jLogConsumer(LOGGER))).withExposedPorts(new Integer[]{8000}).withCommand(new String[]{"-jar", "DynamoDBLocal.jar", "-inMemory", "-sharedDb"}).withStartupAttempts(5);
            containerNetworkId.ifPresent(arg_0 -> ((GenericContainer)c).withNetworkMode(arg_0));
            try {
                c.start();
                this.container = c;
            }
            catch (ContainerLaunchException e) {
                c.close();
                if (e.getCause() == null || retry >= 3) {
                    LOGGER.error("Launch of container {} failed", (Object)c.getDockerImageName(), (Object)e);
                    throw new RuntimeException(e);
                }
                LOGGER.warn("Launch of container {} failed, will retry...", (Object)c.getDockerImageName(), (Object)e);
                ++retry;
                continue;
            }
            break;
        }
        Integer port = containerNetworkId.isPresent() ? 8000 : this.container.getFirstMappedPort();
        String host = containerNetworkId.isPresent() ? this.container.getCurrentContainerInfo().getConfig().getHostName() : this.container.getHost();
        this.endpointURI = String.format("http://%s:%d", host, port);
        if (!quiet) {
            LOGGER.info("Dynamo test container endpoint is {} (network-id: {})", (Object)this.endpointURI, containerNetworkId);
        }
    }

    public void stop() throws Exception {
        try {
            super.stop();
        }
        finally {
            try {
                if (this.container != null) {
                    this.container.stop();
                }
            }
            finally {
                this.container = null;
            }
        }
    }
}

