/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.ToBranchParams;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitParams", generator="Immutables")
@Immutable
public final class ImmutableCommitParams
implements CommitParams {
    private final BranchName toBranch;
    private final Optional<Hash> expectedHead;
    private final ImmutableMap<ContentId, Optional<ByteString>> expectedStates;
    private final ImmutableList<KeyWithBytes> puts;
    private final ImmutableList<ContentAttachment> attachments;
    private final ImmutableList<Key> unchanged;
    private final ImmutableList<Key> deletes;
    private final ByteString commitMetaSerialized;
    @Nullable
    private final Callable<Void> validator;

    private ImmutableCommitParams(Builder builder) {
        this.toBranch = builder.toBranch;
        this.expectedStates = builder.expectedStates.build();
        this.puts = builder.puts.build();
        this.attachments = builder.attachments.build();
        this.unchanged = builder.unchanged.build();
        this.deletes = builder.deletes.build();
        this.commitMetaSerialized = builder.commitMetaSerialized;
        this.validator = builder.validator;
        this.expectedHead = builder.expectedHead != null ? builder.expectedHead : Objects.requireNonNull(CommitParams.super.getExpectedHead(), "expectedHead");
    }

    private ImmutableCommitParams(BranchName toBranch, Optional<Hash> expectedHead, ImmutableMap<ContentId, Optional<ByteString>> expectedStates, ImmutableList<KeyWithBytes> puts, ImmutableList<ContentAttachment> attachments, ImmutableList<Key> unchanged, ImmutableList<Key> deletes, ByteString commitMetaSerialized, @Nullable Callable<Void> validator) {
        this.toBranch = toBranch;
        this.expectedHead = expectedHead;
        this.expectedStates = expectedStates;
        this.puts = puts;
        this.attachments = attachments;
        this.unchanged = unchanged;
        this.deletes = deletes;
        this.commitMetaSerialized = commitMetaSerialized;
        this.validator = validator;
    }

    @Override
    public BranchName getToBranch() {
        return this.toBranch;
    }

    @Override
    public Optional<Hash> getExpectedHead() {
        return this.expectedHead;
    }

    public ImmutableMap<ContentId, Optional<ByteString>> getExpectedStates() {
        return this.expectedStates;
    }

    public ImmutableList<KeyWithBytes> getPuts() {
        return this.puts;
    }

    public ImmutableList<ContentAttachment> getAttachments() {
        return this.attachments;
    }

    public ImmutableList<Key> getUnchanged() {
        return this.unchanged;
    }

    public ImmutableList<Key> getDeletes() {
        return this.deletes;
    }

    @Override
    public ByteString getCommitMetaSerialized() {
        return this.commitMetaSerialized;
    }

    @Override
    @Nullable
    public Callable<Void> getValidator() {
        return this.validator;
    }

    public final ImmutableCommitParams withToBranch(BranchName value) {
        if (this.toBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "toBranch");
        return new ImmutableCommitParams(newValue, this.expectedHead, this.expectedStates, this.puts, this.attachments, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withExpectedHead(Optional<Hash> value) {
        Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
        if (this.expectedHead.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitParams(this.toBranch, newValue, this.expectedStates, this.puts, this.attachments, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withExpectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
        if (this.expectedStates == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, (ImmutableMap<ContentId, Optional<ByteString>>)newValue, this.puts, this.attachments, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withPuts(KeyWithBytes ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, (ImmutableList<KeyWithBytes>)newValue, this.attachments, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withPuts(Iterable<? extends KeyWithBytes> elements) {
        if (this.puts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, (ImmutableList<KeyWithBytes>)newValue, this.attachments, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withAttachments(ContentAttachment ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, this.puts, (ImmutableList<ContentAttachment>)newValue, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withAttachments(Iterable<? extends ContentAttachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, this.puts, (ImmutableList<ContentAttachment>)newValue, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withUnchanged(Key ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, this.puts, this.attachments, (ImmutableList<Key>)newValue, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withUnchanged(Iterable<? extends Key> elements) {
        if (this.unchanged == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, this.puts, this.attachments, (ImmutableList<Key>)newValue, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withDeletes(Key ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, this.puts, this.attachments, this.unchanged, (ImmutableList<Key>)newValue, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withDeletes(Iterable<? extends Key> elements) {
        if (this.deletes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, this.puts, this.attachments, this.unchanged, (ImmutableList<Key>)newValue, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitParams withCommitMetaSerialized(ByteString value) {
        if (this.commitMetaSerialized == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "commitMetaSerialized");
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, this.puts, this.attachments, this.unchanged, this.deletes, newValue, this.validator);
    }

    public final ImmutableCommitParams withValidator(@Nullable Callable<Void> value) {
        if (this.validator == value) {
            return this;
        }
        return new ImmutableCommitParams(this.toBranch, this.expectedHead, this.expectedStates, this.puts, this.attachments, this.unchanged, this.deletes, this.commitMetaSerialized, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitParams && this.equalTo(0, (ImmutableCommitParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitParams another) {
        return this.toBranch.equals(another.toBranch) && this.expectedHead.equals(another.expectedHead) && this.expectedStates.equals(another.expectedStates) && this.puts.equals(another.puts) && this.attachments.equals(another.attachments) && this.unchanged.equals(another.unchanged) && this.deletes.equals(another.deletes) && this.commitMetaSerialized.equals((Object)another.commitMetaSerialized) && Objects.equals(this.validator, another.validator);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toBranch.hashCode();
        h += (h << 5) + this.expectedHead.hashCode();
        h += (h << 5) + this.expectedStates.hashCode();
        h += (h << 5) + this.puts.hashCode();
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.unchanged.hashCode();
        h += (h << 5) + this.deletes.hashCode();
        h += (h << 5) + this.commitMetaSerialized.hashCode();
        h += (h << 5) + Objects.hashCode(this.validator);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitParams").omitNullValues().add("toBranch", (Object)this.toBranch).add("expectedHead", this.expectedHead).add("expectedStates", this.expectedStates).add("puts", this.puts).add("attachments", this.attachments).add("unchanged", this.unchanged).add("deletes", this.deletes).add("commitMetaSerialized", (Object)this.commitMetaSerialized).add("validator", this.validator).toString();
    }

    public static ImmutableCommitParams copyOf(CommitParams instance) {
        if (instance instanceof ImmutableCommitParams) {
            return (ImmutableCommitParams)instance;
        }
        return ImmutableCommitParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TO_BRANCH = 1L;
        private static final long INIT_BIT_COMMIT_META_SERIALIZED = 2L;
        private long initBits = 3L;
        @Nullable
        private BranchName toBranch;
        @Nullable
        private Optional<Hash> expectedHead;
        private ImmutableMap.Builder<ContentId, Optional<ByteString>> expectedStates = ImmutableMap.builder();
        private ImmutableList.Builder<KeyWithBytes> puts = ImmutableList.builder();
        private ImmutableList.Builder<ContentAttachment> attachments = ImmutableList.builder();
        private ImmutableList.Builder<Key> unchanged = ImmutableList.builder();
        private ImmutableList.Builder<Key> deletes = ImmutableList.builder();
        @Nullable
        private ByteString commitMetaSerialized;
        @Nullable
        private Callable<Void> validator;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ToBranchParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToBranchParams instance;
            long bits = 0L;
            if (object instanceof CommitParams) {
                instance = (CommitParams)object;
                this.addAllPuts(instance.getPuts());
                this.addAllDeletes(instance.getDeletes());
                this.commitMetaSerialized(instance.getCommitMetaSerialized());
                this.addAllAttachments(instance.getAttachments());
                if ((bits & 2L) == 0L) {
                    this.expectedHead(instance.getExpectedHead());
                    bits |= 2L;
                }
                this.addAllUnchanged(instance.getUnchanged());
                Callable<Void> validatorValue = instance.getValidator();
                if (validatorValue != null) {
                    this.validator(validatorValue);
                }
                this.putAllExpectedStates(instance.getExpectedStates());
                if ((bits & 1L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 1L;
                }
            }
            if (object instanceof ToBranchParams) {
                instance = (ToBranchParams)object;
                if ((bits & 1L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead(instance.getExpectedHead());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder toBranch(BranchName toBranch) {
            this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedHead(Optional<Hash> expectedHead) {
            this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExpectedStates(ContentId key, Optional<ByteString> value) {
            this.expectedStates.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExpectedStates(Map.Entry<? extends ContentId, ? extends Optional<ByteString>> entry) {
            this.expectedStates.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
            this.expectedStates = ImmutableMap.builder();
            return this.putAllExpectedStates(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExpectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
            this.expectedStates.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPuts(KeyWithBytes element) {
            this.puts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPuts(KeyWithBytes ... elements) {
            this.puts.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder puts(Iterable<? extends KeyWithBytes> elements) {
            this.puts = ImmutableList.builder();
            return this.addAllPuts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPuts(Iterable<? extends KeyWithBytes> elements) {
            this.puts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAttachments(ContentAttachment element) {
            this.attachments.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAttachments(ContentAttachment ... elements) {
            this.attachments.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attachments(Iterable<? extends ContentAttachment> elements) {
            this.attachments = ImmutableList.builder();
            return this.addAllAttachments(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAttachments(Iterable<? extends ContentAttachment> elements) {
            this.attachments.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUnchanged(Key element) {
            this.unchanged.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUnchanged(Key ... elements) {
            this.unchanged.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder unchanged(Iterable<? extends Key> elements) {
            this.unchanged = ImmutableList.builder();
            return this.addAllUnchanged(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUnchanged(Iterable<? extends Key> elements) {
            this.unchanged.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletes(Key element) {
            this.deletes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletes(Key ... elements) {
            this.deletes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deletes(Iterable<? extends Key> elements) {
            this.deletes = ImmutableList.builder();
            return this.addAllDeletes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDeletes(Iterable<? extends Key> elements) {
            this.deletes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitMetaSerialized(ByteString commitMetaSerialized) {
            this.commitMetaSerialized = Objects.requireNonNull(commitMetaSerialized, "commitMetaSerialized");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validator(@Nullable Callable<Void> validator) {
            this.validator = validator;
            return this;
        }

        public ImmutableCommitParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("toBranch");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitMetaSerialized");
            }
            return "Cannot build CommitParams, some of required attributes are not set " + attributes;
        }
    }
}

