/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;
import org.projectnessie.versioned.paging.PaginationIterator;

public abstract class AuthzPaginationIterator<E>
extends AbstractIterator<E>
implements PaginationIterator<E> {
    private final PaginationIterator<E> source;
    private final Supplier<BatchAccessChecker> checkerSupplier;
    private final int checkBatchSize;
    private final Set<Check> initialChecks;
    private final Set<Check> succeededChecks;
    private final Set<Check> failedChecks;
    private Iterator<E> currentResult = Collections.emptyIterator();
    private E currentEntry;

    public AuthzPaginationIterator(PaginationIterator<E> source, Supplier<BatchAccessChecker> checkerSupplier, int checkBatchSize) {
        this.source = source;
        this.checkerSupplier = checkerSupplier;
        this.checkBatchSize = checkBatchSize;
        this.initialChecks = new HashSet<Check>();
        this.succeededChecks = new HashSet<Check>();
        this.failedChecks = new HashSet<Check>();
    }

    public AuthzPaginationIterator<E> initialCheck(Check initialCheck) {
        this.initialChecks.add(initialCheck);
        return this;
    }

    protected abstract Set<Check> checksForEntry(E var1);

    protected final E computeNext() {
        while (true) {
            int batchEntryCount;
            if (this.currentResult.hasNext()) {
                E entry = this.currentResult.next();
                this.currentEntry = entry;
                return entry;
            }
            ArrayList<Object> batchEntries = new ArrayList<Object>(this.checkBatchSize);
            ArrayList<Set<Check>> checksForEntries = new ArrayList<Set<Check>>(this.checkBatchSize);
            HashSet batchChecks = Sets.newHashSetWithExpectedSize((int)this.checkBatchSize);
            batchChecks.addAll(this.initialChecks);
            while (this.source.hasNext()) {
                Object entry = this.source.next();
                Set<Check> checksForEntry = this.checksForEntry(entry);
                if (checksForEntry.stream().anyMatch(this.failedChecks::contains)) continue;
                batchEntries.add(entry);
                checksForEntries.add(checksForEntry);
                checksForEntry.stream().filter(c -> !this.succeededChecks.contains(c)).forEach(batchChecks::add);
                if (batchChecks.size() < this.checkBatchSize) continue;
                break;
            }
            Map<Object, Object> failed = Collections.emptyMap();
            if (!batchChecks.isEmpty()) {
                BatchAccessChecker checker = this.checkerSupplier.get();
                batchChecks.forEach(checker::can);
                failed = checker.check();
            }
            if (!this.initialChecks.isEmpty()) {
                HashMap<Check, String> failedInitial = new HashMap<Check, String>();
                for (Check initialCheck : this.initialChecks) {
                    String failure = (String)failed.get(initialCheck);
                    if (failure == null) continue;
                    failedInitial.put(initialCheck, failure);
                }
                this.initialChecks.clear();
                if (!failedInitial.isEmpty()) {
                    BatchAccessChecker.throwForFailedChecks(failedInitial);
                }
            }
            if ((batchEntryCount = batchEntries.size()) == 0) {
                return (E)this.endOfData();
            }
            ArrayList current = new ArrayList(batchEntryCount);
            for (int i = 0; i < batchEntryCount; ++i) {
                Object entry = batchEntries.get(i);
                Set checksForEntry = (Set)checksForEntries.get(i);
                boolean anyFailed = false;
                for (Check check : checksForEntry) {
                    if (failed.containsKey(check)) {
                        anyFailed = true;
                        this.failedChecks.add(check);
                        continue;
                    }
                    this.succeededChecks.add(check);
                }
                if (anyFailed) continue;
                current.add(entry);
            }
            this.currentResult = current.iterator();
        }
    }

    public final String tokenForCurrent() {
        return this.source.tokenForEntry(this.currentEntry);
    }

    public final String tokenForEntry(E entry) {
        return this.source.tokenForEntry(entry);
    }

    public final void close() {
    }
}

