/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.util.Objects;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Detached;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.DetachedRef;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.TagName;

public final class RefUtil {
    private RefUtil() {
    }

    public static NamedRef toNamedRef(Reference reference) {
        Objects.requireNonNull(reference, "reference must not be null");
        if (reference instanceof Branch) {
            return BranchName.of((String)reference.getName());
        }
        if (reference instanceof Tag) {
            return TagName.of((String)reference.getName());
        }
        if (reference instanceof Detached) {
            return DetachedRef.INSTANCE;
        }
        throw new IllegalArgumentException(String.format("Unsupported reference '%s'", reference));
    }

    public static NamedRef toNamedRef(Reference.ReferenceType referenceType, String referenceName) {
        Objects.requireNonNull(referenceType, "referenceType must not be null");
        switch (referenceType) {
            case BRANCH: {
                return BranchName.of((String)referenceName);
            }
            case TAG: {
                return TagName.of((String)referenceName);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid reference type '%s'", referenceType));
    }

    public static Reference toReference(NamedRef namedRef, Hash hash) {
        Objects.requireNonNull(namedRef, "namedRef must not be null");
        return RefUtil.toReference(namedRef, hash != null ? hash.asString() : null);
    }

    public static Reference toReference(NamedRef namedRef, String hash) {
        Objects.requireNonNull(namedRef, "namedRef must not be null");
        if (namedRef instanceof BranchName) {
            return Branch.of((String)namedRef.getName(), (String)hash);
        }
        if (namedRef instanceof TagName) {
            return Tag.of((String)namedRef.getName(), (String)hash);
        }
        if (namedRef instanceof DetachedRef) {
            return Detached.of((String)Objects.requireNonNull(hash, "hash must not be null for detached references"));
        }
        throw new IllegalArgumentException(String.format("Unsupported named reference '%s'", namedRef));
    }
}

