/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.api.RefLogApi;
import org.projectnessie.api.params.RefLogParams;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieRefLogNotFoundException;
import org.projectnessie.model.ImmutableRefLogResponse;
import org.projectnessie.model.ImmutableRefLogResponseEntry;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.cel.CELUtil;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.impl.StreamUtil;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.VersionStore;

public class RefLogApiImpl
extends BaseApiImpl
implements RefLogApi {
    private static final int MAX_REF_LOG_ENTRIES = 250;

    public RefLogApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Principal principal) {
        super(config, store, authorizer, principal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefLogResponse getRefLog(RefLogParams params) throws NessieNotFoundException {
        int max = Math.min(params.maxRecords() != null ? params.maxRecords() : 250, 250);
        Hash endHash = null;
        if (params.endHash() != null) {
            endHash = Hash.of((String)Objects.requireNonNull(params.endHash()));
        }
        Hash endRef = null == params.pageToken() ? endHash : Hash.of((String)params.pageToken());
        try (Stream entries = this.getStore().getRefLog(endRef);){
            Stream<RefLogResponse.RefLogResponseEntry> logEntries = entries.map(entry -> {
                ImmutableRefLogResponseEntry.Builder logEntry = RefLogResponse.RefLogResponseEntry.builder();
                logEntry.refLogId(entry.getRefLogId().asString()).refName(entry.getRefName()).refType(entry.getRefType()).commitHash(entry.getCommitHash().asString()).operation(entry.getOperation()).operationTime(entry.getOperationTime()).parentRefLogId(entry.getParentRefLogId().asString());
                entry.getSourceHashes().forEach(hash -> logEntry.addSourceHashes(hash.asString()));
                return logEntry.build();
            });
            logEntries = StreamSupport.stream(StreamUtil.takeUntilIncl(logEntries.spliterator(), x -> Objects.equals(x.getRefLogId(), params.startHash())), false);
            List items = RefLogApiImpl.filterRefLog(logEntries, params.filter()).limit(max + 1).collect(Collectors.toList());
            if (items.size() == max + 1) {
                ImmutableRefLogResponse immutableRefLogResponse2 = ImmutableRefLogResponse.builder().addAllLogEntries(items.subList(0, max)).isHasMore(true).token(((RefLogResponse.RefLogResponseEntry)items.get(max)).getRefLogId()).build();
                return immutableRefLogResponse2;
            }
            ImmutableRefLogResponse immutableRefLogResponse = ImmutableRefLogResponse.builder().addAllLogEntries(items).build();
            return immutableRefLogResponse;
        }
        catch (RefLogNotFoundException e) {
            throw new NessieRefLogNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    private static Stream<RefLogResponse.RefLogResponseEntry> filterRefLog(Stream<RefLogResponse.RefLogResponseEntry> logEntries, String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return logEntries;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.REFLOG_DECLARATIONS).withTypes(CELUtil.REFLOG_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return logEntries.filter(logEntry -> {
            try {
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"reflog", (Object)logEntry));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

