/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.projectnessie.api.ContentApi;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.ImmutableGetMultipleContentsResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class ContentApiImpl
extends BaseApiImpl
implements ContentApi {
    public ContentApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Principal principal) {
        super(config, store, authorizer, principal);
    }

    public Content getContent(ContentKey key, String namedRef, String hashOnRef) throws NessieNotFoundException {
        WithHash<NamedRef> ref = this.namedRefWithHashOrThrow(namedRef, hashOnRef);
        try {
            Content obj = this.getStore().getValue((Ref)ref.getHash(), ContentApiImpl.toKey(key));
            if (obj != null) {
                return obj;
            }
            throw new NessieContentNotFoundException(key, namedRef);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public GetMultipleContentsResponse getMultipleContents(String namedRef, String hashOnRef, GetMultipleContentsRequest request) throws NessieNotFoundException {
        try {
            WithHash<NamedRef> ref = this.namedRefWithHashOrThrow(namedRef, hashOnRef);
            List externalKeys = request.getRequestedKeys();
            List internalKeys = externalKeys.stream().map(ContentApiImpl::toKey).collect(Collectors.toList());
            Map values = this.getStore().getValues((Ref)ref.getHash(), internalKeys);
            List output = values.entrySet().stream().map(e -> GetMultipleContentsResponse.ContentWithKey.of((ContentKey)ContentApiImpl.toContentKey((Key)e.getKey()), (Content)((Content)e.getValue()))).collect(Collectors.toList());
            return ImmutableGetMultipleContentsResponse.builder().contents(output).build();
        }
        catch (ReferenceNotFoundException ex) {
            throw new NessieReferenceNotFoundException(ex.getMessage(), (Throwable)ex);
        }
    }

    static Key toKey(ContentKey key) {
        return Key.of((String[])key.getElements().toArray(new String[0]));
    }

    static ContentKey toContentKey(Key key) {
        return ContentKey.of((List)key.getElements());
    }
}

