/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.services.authz.Check;
import org.projectnessie.versioned.NamedRef;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Check", generator="Immutables")
@Immutable
public final class ImmutableCheck
implements Check {
    private final Check.CheckType type;
    @Nullable
    private final NamedRef ref;
    @Nullable
    private final ContentKey key;
    @Nullable
    private final String contentId;
    @Nullable
    private final Content.Type contentType;

    private ImmutableCheck(Check.CheckType type, @Nullable NamedRef ref, @Nullable ContentKey key, @Nullable String contentId, @Nullable Content.Type contentType) {
        this.type = type;
        this.ref = ref;
        this.key = key;
        this.contentId = contentId;
        this.contentType = contentType;
    }

    @Override
    public Check.CheckType type() {
        return this.type;
    }

    @Override
    @Nullable
    public NamedRef ref() {
        return this.ref;
    }

    @Override
    @Nullable
    public ContentKey key() {
        return this.key;
    }

    @Override
    @Nullable
    public String contentId() {
        return this.contentId;
    }

    @Override
    @Nullable
    public Content.Type contentType() {
        return this.contentType;
    }

    public final ImmutableCheck withType(Check.CheckType value) {
        Check.CheckType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableCheck(newValue, this.ref, this.key, this.contentId, this.contentType);
    }

    public final ImmutableCheck withRef(@Nullable NamedRef value) {
        if (this.ref == value) {
            return this;
        }
        return new ImmutableCheck(this.type, value, this.key, this.contentId, this.contentType);
    }

    public final ImmutableCheck withKey(@Nullable ContentKey value) {
        if (this.key == value) {
            return this;
        }
        return new ImmutableCheck(this.type, this.ref, value, this.contentId, this.contentType);
    }

    public final ImmutableCheck withContentId(@Nullable String value) {
        if (Objects.equals(this.contentId, value)) {
            return this;
        }
        return new ImmutableCheck(this.type, this.ref, this.key, value, this.contentType);
    }

    public final ImmutableCheck withContentType(@Nullable Content.Type value) {
        if (this.contentType == value) {
            return this;
        }
        return new ImmutableCheck(this.type, this.ref, this.key, this.contentId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheck && this.equalTo(0, (ImmutableCheck)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheck another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.ref, another.ref) && Objects.equals(this.key, another.key) && Objects.equals(this.contentId, another.contentId) && Objects.equals(this.contentType, another.contentType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.key);
        h += (h << 5) + Objects.hashCode(this.contentId);
        h += (h << 5) + Objects.hashCode(this.contentType);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Check").omitNullValues().add("type", (Object)this.type).add("ref", (Object)this.ref).add("key", (Object)this.key).add("contentId", (Object)this.contentId).add("contentType", (Object)this.contentType).toString();
    }

    public static ImmutableCheck copyOf(Check instance) {
        if (instance instanceof ImmutableCheck) {
            return (ImmutableCheck)instance;
        }
        return ImmutableCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Check", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private Check.CheckType type;
        @Nullable
        private NamedRef ref;
        @Nullable
        private ContentKey key;
        @Nullable
        private String contentId;
        @Nullable
        private Content.Type contentType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Check instance) {
            Content.Type contentTypeValue;
            String contentIdValue;
            ContentKey keyValue;
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            NamedRef refValue = instance.ref();
            if (refValue != null) {
                this.ref(refValue);
            }
            if ((keyValue = instance.key()) != null) {
                this.key(keyValue);
            }
            if ((contentIdValue = instance.contentId()) != null) {
                this.contentId(contentIdValue);
            }
            if ((contentTypeValue = instance.contentType()) != null) {
                this.contentType(contentTypeValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Check.CheckType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable NamedRef ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(@Nullable ContentKey key) {
            this.key = key;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(@Nullable String contentId) {
            this.contentId = contentId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentType(@Nullable Content.Type contentType) {
            this.contentType = contentType;
            return this;
        }

        public ImmutableCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheck(this.type, this.ref, this.key, this.contentId, this.contentType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Check, some of required attributes are not set " + attributes;
        }
    }
}

