/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.v1.http.HttpRefLogApi;
import org.projectnessie.api.v1.params.RefLogParams;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.RefLogApiImplWithAuthorization;
import org.projectnessie.services.spi.RefLogService;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
public class RestRefLogResource
implements HttpRefLogApi {
    private final ServerConfig config;
    private final VersionStore store;
    private final Authorizer authorizer;
    @Context
    SecurityContext securityContext;

    public RestRefLogResource() {
        this(null, null, null);
    }

    @Inject
    public RestRefLogResource(ServerConfig config, VersionStore store, Authorizer authorizer) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
    }

    private RefLogService resource() {
        return new RefLogApiImplWithAuthorization(this.config, this.store, this.authorizer, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public RefLogResponse getRefLog(RefLogParams params) throws NessieNotFoundException {
        return this.resource().getRefLog(params.startHash(), params.endHash(), params.filter(), params.maxRecords(), params.pageToken());
    }
}

