/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.v1.http.HttpDiffApi;
import org.projectnessie.api.v1.params.DiffParams;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.DiffApiImplWithAuthorization;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
public class RestDiffResource
implements HttpDiffApi {
    private final ServerConfig config;
    private final VersionStore store;
    private final Authorizer authorizer;
    @Context
    SecurityContext securityContext;

    public RestDiffResource() {
        this(null, null, null);
    }

    @Inject
    public RestDiffResource(ServerConfig config, VersionStore store, Authorizer authorizer) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
    }

    private DiffService resource() {
        return new DiffApiImplWithAuthorization(this.config, this.store, this.authorizer, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public DiffResponse getDiff(DiffParams params) throws NessieNotFoundException {
        return this.resource().getDiff(params.getFromRef(), params.getFromHashOnRef(), params.getToRef(), params.getToHashOnRef());
    }
}

