/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.v1.http.HttpNamespaceApi;
import org.projectnessie.api.v1.params.MultipleNamespacesParams;
import org.projectnessie.api.v1.params.NamespaceParams;
import org.projectnessie.api.v1.params.NamespaceUpdate;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.NamespaceApiImplWithAuthorization;
import org.projectnessie.services.spi.NamespaceService;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
@Path(value="v1/namespaces")
public class RestNamespaceResource
implements HttpNamespaceApi {
    private final ServerConfig config;
    private final VersionStore store;
    private final Authorizer authorizer;
    @Context
    SecurityContext securityContext;

    public RestNamespaceResource() {
        this(null, null, null);
    }

    @Inject
    public RestNamespaceResource(ServerConfig config, VersionStore store, Authorizer authorizer) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
    }

    private NamespaceService resource() {
        return new NamespaceApiImplWithAuthorization(this.config, this.store, this.authorizer, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public Namespace createNamespace(NamespaceParams params, Namespace namespace) throws NessieNamespaceAlreadyExistsException, NessieReferenceNotFoundException {
        return this.resource().createNamespace(params.getRefName(), namespace);
    }

    public void deleteNamespace(@NotNull NamespaceParams params) throws NessieReferenceNotFoundException, NessieNamespaceNotEmptyException, NessieNamespaceNotFoundException {
        this.resource().deleteNamespace(params.getRefName(), params.getNamespace());
    }

    public Namespace getNamespace(@NotNull NamespaceParams params) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        return this.resource().getNamespace(params.getRefName(), params.getHashOnRef(), params.getNamespace());
    }

    public GetNamespacesResponse getNamespaces(@NotNull MultipleNamespacesParams params) throws NessieReferenceNotFoundException {
        return this.resource().getNamespaces(params.getRefName(), params.getHashOnRef(), params.getNamespace());
    }

    public void updateProperties(NamespaceParams params, NamespaceUpdate namespaceUpdate) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        this.resource().updateProperties(params.getRefName(), params.getNamespace(), namespaceUpdate.getPropertyUpdates(), namespaceUpdate.getPropertyRemovals());
    }
}

