/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;

@ParametersAreNonnullByDefault
@Generated(from="MergeResponse", generator="Immutables")
@Immutable
public final class ImmutableMergeResponse
implements MergeResponse {
    private final boolean wasApplied;
    private final boolean wasSuccessful;
    @Nullable
    private final String resultantTargetHash;
    @Nullable
    private final String commonAncestor;
    private final String targetBranch;
    private final String effectiveTargetHash;
    @Nullable
    private final String expectedHash;
    private final List<LogResponse.LogEntry> sourceCommits;
    @Nullable
    private final List<LogResponse.LogEntry> targetCommits;
    private final List<MergeResponse.ContentKeyDetails> details;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMergeResponse(Builder builder) {
        this.resultantTargetHash = builder.resultantTargetHash;
        this.commonAncestor = builder.commonAncestor;
        this.targetBranch = builder.targetBranch;
        this.effectiveTargetHash = builder.effectiveTargetHash;
        this.expectedHash = builder.expectedHash;
        this.sourceCommits = ImmutableMergeResponse.createUnmodifiableList(true, builder.sourceCommits);
        this.targetCommits = builder.targetCommits == null ? null : ImmutableMergeResponse.createUnmodifiableList(true, builder.targetCommits);
        this.details = ImmutableMergeResponse.createUnmodifiableList(true, builder.details);
        if (builder.wasAppliedIsSet()) {
            this.initShim.wasApplied(builder.wasApplied);
        }
        if (builder.wasSuccessfulIsSet()) {
            this.initShim.wasSuccessful(builder.wasSuccessful);
        }
        this.wasApplied = this.initShim.wasApplied();
        this.wasSuccessful = this.initShim.wasSuccessful();
        this.initShim = null;
    }

    private ImmutableMergeResponse(boolean wasApplied, boolean wasSuccessful, @Nullable String resultantTargetHash, @Nullable String commonAncestor, String targetBranch, String effectiveTargetHash, @Nullable String expectedHash, List<LogResponse.LogEntry> sourceCommits, @Nullable List<LogResponse.LogEntry> targetCommits, List<MergeResponse.ContentKeyDetails> details) {
        this.wasApplied = wasApplied;
        this.wasSuccessful = wasSuccessful;
        this.resultantTargetHash = resultantTargetHash;
        this.commonAncestor = commonAncestor;
        this.targetBranch = targetBranch;
        this.effectiveTargetHash = effectiveTargetHash;
        this.expectedHash = expectedHash;
        this.sourceCommits = sourceCommits;
        this.targetCommits = targetCommits;
        this.details = details;
        this.initShim = null;
    }

    private boolean wasAppliedInitialize() {
        return MergeResponse.super.wasApplied();
    }

    private boolean wasSuccessfulInitialize() {
        return MergeResponse.super.wasSuccessful();
    }

    @Override
    @JsonProperty(value="wasApplied")
    public boolean wasApplied() {
        InitShim shim = this.initShim;
        return shim != null ? shim.wasApplied() : this.wasApplied;
    }

    @Override
    @JsonProperty(value="wasSuccessful")
    public boolean wasSuccessful() {
        InitShim shim = this.initShim;
        return shim != null ? shim.wasSuccessful() : this.wasSuccessful;
    }

    @Override
    @JsonProperty(value="resultantTargetHash")
    @Nullable
    public String getResultantTargetHash() {
        return this.resultantTargetHash;
    }

    @Override
    @JsonProperty(value="commonAncestor")
    @Nullable
    public String getCommonAncestor() {
        return this.commonAncestor;
    }

    @Override
    @JsonProperty(value="targetBranch")
    public String getTargetBranch() {
        return this.targetBranch;
    }

    @Override
    @JsonProperty(value="effectiveTargetHash")
    public String getEffectiveTargetHash() {
        return this.effectiveTargetHash;
    }

    @Override
    @JsonProperty(value="expectedHash")
    @Nullable
    public String getExpectedHash() {
        return this.expectedHash;
    }

    @Override
    @JsonProperty(value="sourceCommits")
    @Deprecated
    public List<LogResponse.LogEntry> getSourceCommits() {
        return this.sourceCommits;
    }

    @Override
    @JsonProperty(value="targetCommits")
    @Deprecated
    @Nullable
    public List<LogResponse.LogEntry> getTargetCommits() {
        return this.targetCommits;
    }

    @Override
    @JsonProperty(value="details")
    public List<MergeResponse.ContentKeyDetails> getDetails() {
        return this.details;
    }

    public final ImmutableMergeResponse withWasApplied(boolean value) {
        if (this.wasApplied == value) {
            return this;
        }
        return new ImmutableMergeResponse(value, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.details);
    }

    public final ImmutableMergeResponse withWasSuccessful(boolean value) {
        if (this.wasSuccessful == value) {
            return this;
        }
        return new ImmutableMergeResponse(this.wasApplied, value, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.details);
    }

    public final ImmutableMergeResponse withResultantTargetHash(@Nullable String value) {
        if (Objects.equals(this.resultantTargetHash, value)) {
            return this;
        }
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, value, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.details);
    }

    public final ImmutableMergeResponse withCommonAncestor(@Nullable String value) {
        if (Objects.equals(this.commonAncestor, value)) {
            return this;
        }
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, value, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.details);
    }

    public final ImmutableMergeResponse withTargetBranch(String value) {
        String newValue = Objects.requireNonNull(value, "targetBranch");
        if (this.targetBranch.equals(newValue)) {
            return this;
        }
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, newValue, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.details);
    }

    public final ImmutableMergeResponse withEffectiveTargetHash(String value) {
        String newValue = Objects.requireNonNull(value, "effectiveTargetHash");
        if (this.effectiveTargetHash.equals(newValue)) {
            return this;
        }
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, newValue, this.expectedHash, this.sourceCommits, this.targetCommits, this.details);
    }

    public final ImmutableMergeResponse withExpectedHash(@Nullable String value) {
        if (Objects.equals(this.expectedHash, value)) {
            return this;
        }
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, value, this.sourceCommits, this.targetCommits, this.details);
    }

    @Deprecated
    public final ImmutableMergeResponse withSourceCommits(LogResponse.LogEntry ... elements) {
        List<LogResponse.LogEntry> newValue = ImmutableMergeResponse.createUnmodifiableList(false, ImmutableMergeResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, newValue, this.targetCommits, this.details);
    }

    @Deprecated
    public final ImmutableMergeResponse withSourceCommits(Iterable<? extends LogResponse.LogEntry> elements) {
        if (this.sourceCommits == elements) {
            return this;
        }
        List<LogResponse.LogEntry> newValue = ImmutableMergeResponse.createUnmodifiableList(false, ImmutableMergeResponse.createSafeList(elements, true, false));
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, newValue, this.targetCommits, this.details);
    }

    @Deprecated
    public final ImmutableMergeResponse withTargetCommits(LogResponse.LogEntry ... elements) {
        if (elements == null) {
            return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, null, this.details);
        }
        List<LogResponse.LogEntry> newValue = Arrays.asList(elements) == null ? null : ImmutableMergeResponse.createUnmodifiableList(false, ImmutableMergeResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, newValue, this.details);
    }

    @Deprecated
    public final ImmutableMergeResponse withTargetCommits(@Nullable Iterable<? extends LogResponse.LogEntry> elements) {
        if (this.targetCommits == elements) {
            return this;
        }
        List<LogResponse.LogEntry> newValue = elements == null ? null : ImmutableMergeResponse.createUnmodifiableList(false, ImmutableMergeResponse.createSafeList(elements, true, false));
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, newValue, this.details);
    }

    public final ImmutableMergeResponse withDetails(MergeResponse.ContentKeyDetails ... elements) {
        List<MergeResponse.ContentKeyDetails> newValue = ImmutableMergeResponse.createUnmodifiableList(false, ImmutableMergeResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, newValue);
    }

    public final ImmutableMergeResponse withDetails(Iterable<? extends MergeResponse.ContentKeyDetails> elements) {
        if (this.details == elements) {
            return this;
        }
        List<MergeResponse.ContentKeyDetails> newValue = ImmutableMergeResponse.createUnmodifiableList(false, ImmutableMergeResponse.createSafeList(elements, true, false));
        return new ImmutableMergeResponse(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeResponse && this.equalTo(0, (ImmutableMergeResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeResponse another) {
        return this.wasApplied == another.wasApplied && this.wasSuccessful == another.wasSuccessful && Objects.equals(this.resultantTargetHash, another.resultantTargetHash) && Objects.equals(this.commonAncestor, another.commonAncestor) && this.targetBranch.equals(another.targetBranch) && this.effectiveTargetHash.equals(another.effectiveTargetHash) && Objects.equals(this.expectedHash, another.expectedHash) && this.sourceCommits.equals(another.sourceCommits) && Objects.equals(this.targetCommits, another.targetCommits) && this.details.equals(another.details);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.wasApplied);
        h += (h << 5) + Boolean.hashCode(this.wasSuccessful);
        h += (h << 5) + Objects.hashCode(this.resultantTargetHash);
        h += (h << 5) + Objects.hashCode(this.commonAncestor);
        h += (h << 5) + this.targetBranch.hashCode();
        h += (h << 5) + this.effectiveTargetHash.hashCode();
        h += (h << 5) + Objects.hashCode(this.expectedHash);
        h += (h << 5) + this.sourceCommits.hashCode();
        h += (h << 5) + Objects.hashCode(this.targetCommits);
        h += (h << 5) + this.details.hashCode();
        return h;
    }

    public String toString() {
        return "MergeResponse{wasApplied=" + this.wasApplied + ", wasSuccessful=" + this.wasSuccessful + ", resultantTargetHash=" + this.resultantTargetHash + ", commonAncestor=" + this.commonAncestor + ", targetBranch=" + this.targetBranch + ", effectiveTargetHash=" + this.effectiveTargetHash + ", expectedHash=" + this.expectedHash + ", sourceCommits=" + this.sourceCommits + ", targetCommits=" + this.targetCommits + ", details=" + this.details + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMergeResponse fromJson(Json json) {
        Builder builder = ImmutableMergeResponse.builder();
        if (json.wasAppliedIsSet) {
            builder.wasApplied(json.wasApplied);
        }
        if (json.wasSuccessfulIsSet) {
            builder.wasSuccessful(json.wasSuccessful);
        }
        if (json.resultantTargetHash != null) {
            builder.resultantTargetHash(json.resultantTargetHash);
        }
        if (json.commonAncestor != null) {
            builder.commonAncestor(json.commonAncestor);
        }
        if (json.targetBranch != null) {
            builder.targetBranch(json.targetBranch);
        }
        if (json.effectiveTargetHash != null) {
            builder.effectiveTargetHash(json.effectiveTargetHash);
        }
        if (json.expectedHash != null) {
            builder.expectedHash(json.expectedHash);
        }
        if (json.sourceCommits != null) {
            builder.addAllSourceCommits(json.sourceCommits);
        }
        if (json.targetCommits != null) {
            builder.addAllTargetCommits(json.targetCommits);
        }
        if (json.details != null) {
            builder.addAllDetails(json.details);
        }
        return builder.build();
    }

    public static ImmutableMergeResponse copyOf(MergeResponse instance) {
        if (instance instanceof ImmutableMergeResponse) {
            return (ImmutableMergeResponse)instance;
        }
        return ImmutableMergeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static /* synthetic */ boolean access$1300(ImmutableMergeResponse x0) {
        return x0.wasAppliedInitialize();
    }

    static /* synthetic */ boolean access$1400(ImmutableMergeResponse x0) {
        return x0.wasSuccessfulInitialize();
    }

    @Generated(from="MergeResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_BRANCH = 1L;
        private static final long INIT_BIT_EFFECTIVE_TARGET_HASH = 2L;
        private static final long OPT_BIT_WAS_APPLIED = 1L;
        private static final long OPT_BIT_WAS_SUCCESSFUL = 2L;
        private long initBits = 3L;
        private long optBits;
        private boolean wasApplied;
        private boolean wasSuccessful;
        @javax.annotation.Nullable
        private String resultantTargetHash;
        @javax.annotation.Nullable
        private String commonAncestor;
        @javax.annotation.Nullable
        private String targetBranch;
        @javax.annotation.Nullable
        private String effectiveTargetHash;
        @javax.annotation.Nullable
        private String expectedHash;
        private List<LogResponse.LogEntry> sourceCommits = new ArrayList<LogResponse.LogEntry>();
        private List<LogResponse.LogEntry> targetCommits = null;
        private List<MergeResponse.ContentKeyDetails> details = new ArrayList<MergeResponse.ContentKeyDetails>();

        private Builder() {
        }

        public final Builder from(MergeResponse instance) {
            String commonAncestorValue;
            Objects.requireNonNull(instance, "instance");
            this.wasApplied(instance.wasApplied());
            this.wasSuccessful(instance.wasSuccessful());
            String resultantTargetHashValue = instance.getResultantTargetHash();
            if (resultantTargetHashValue != null) {
                this.resultantTargetHash(resultantTargetHashValue);
            }
            if ((commonAncestorValue = instance.getCommonAncestor()) != null) {
                this.commonAncestor(commonAncestorValue);
            }
            this.targetBranch(instance.getTargetBranch());
            this.effectiveTargetHash(instance.getEffectiveTargetHash());
            String expectedHashValue = instance.getExpectedHash();
            if (expectedHashValue != null) {
                this.expectedHash(expectedHashValue);
            }
            this.addAllSourceCommits(instance.getSourceCommits());
            List<LogResponse.LogEntry> targetCommitsValue = instance.getTargetCommits();
            if (targetCommitsValue != null) {
                this.addAllTargetCommits(targetCommitsValue);
            }
            this.addAllDetails(instance.getDetails());
            return this;
        }

        @JsonProperty(value="wasApplied")
        public final Builder wasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="wasSuccessful")
        public final Builder wasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="resultantTargetHash")
        public final Builder resultantTargetHash(String resultantTargetHash) {
            this.resultantTargetHash = resultantTargetHash;
            return this;
        }

        @JsonProperty(value="commonAncestor")
        public final Builder commonAncestor(String commonAncestor) {
            this.commonAncestor = commonAncestor;
            return this;
        }

        @JsonProperty(value="targetBranch")
        public final Builder targetBranch(String targetBranch) {
            this.targetBranch = Objects.requireNonNull(targetBranch, "targetBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="effectiveTargetHash")
        public final Builder effectiveTargetHash(String effectiveTargetHash) {
            this.effectiveTargetHash = Objects.requireNonNull(effectiveTargetHash, "effectiveTargetHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expectedHash")
        public final Builder expectedHash(String expectedHash) {
            this.expectedHash = expectedHash;
            return this;
        }

        @Deprecated
        public final Builder addSourceCommits(LogResponse.LogEntry element) {
            this.sourceCommits.add(Objects.requireNonNull(element, "sourceCommits element"));
            return this;
        }

        @Deprecated
        public final Builder addSourceCommits(LogResponse.LogEntry ... elements) {
            for (LogResponse.LogEntry element : elements) {
                this.sourceCommits.add(Objects.requireNonNull(element, "sourceCommits element"));
            }
            return this;
        }

        @JsonProperty(value="sourceCommits")
        @Deprecated
        public final Builder sourceCommits(Iterable<? extends LogResponse.LogEntry> elements) {
            this.sourceCommits.clear();
            return this.addAllSourceCommits(elements);
        }

        @Deprecated
        public final Builder addAllSourceCommits(Iterable<? extends LogResponse.LogEntry> elements) {
            for (LogResponse.LogEntry logEntry : elements) {
                this.sourceCommits.add(Objects.requireNonNull(logEntry, "sourceCommits element"));
            }
            return this;
        }

        @Deprecated
        public final Builder addTargetCommits(LogResponse.LogEntry element) {
            if (this.targetCommits == null) {
                this.targetCommits = new ArrayList<LogResponse.LogEntry>();
            }
            this.targetCommits.add(Objects.requireNonNull(element, "targetCommits element"));
            return this;
        }

        @Deprecated
        public final Builder addTargetCommits(LogResponse.LogEntry ... elements) {
            if (this.targetCommits == null) {
                this.targetCommits = new ArrayList<LogResponse.LogEntry>();
            }
            for (LogResponse.LogEntry element : elements) {
                this.targetCommits.add(Objects.requireNonNull(element, "targetCommits element"));
            }
            return this;
        }

        @JsonProperty(value="targetCommits")
        @Deprecated
        public final Builder targetCommits(Iterable<? extends LogResponse.LogEntry> elements) {
            if (elements == null) {
                this.targetCommits = null;
                return this;
            }
            this.targetCommits = new ArrayList<LogResponse.LogEntry>();
            return this.addAllTargetCommits(elements);
        }

        @Deprecated
        public final Builder addAllTargetCommits(Iterable<? extends LogResponse.LogEntry> elements) {
            Objects.requireNonNull(elements, "targetCommits element");
            if (this.targetCommits == null) {
                this.targetCommits = new ArrayList<LogResponse.LogEntry>();
            }
            for (LogResponse.LogEntry logEntry : elements) {
                this.targetCommits.add(Objects.requireNonNull(logEntry, "targetCommits element"));
            }
            return this;
        }

        public final Builder addDetails(MergeResponse.ContentKeyDetails element) {
            this.details.add(Objects.requireNonNull(element, "details element"));
            return this;
        }

        public final Builder addDetails(MergeResponse.ContentKeyDetails ... elements) {
            for (MergeResponse.ContentKeyDetails element : elements) {
                this.details.add(Objects.requireNonNull(element, "details element"));
            }
            return this;
        }

        @JsonProperty(value="details")
        public final Builder details(Iterable<? extends MergeResponse.ContentKeyDetails> elements) {
            this.details.clear();
            return this.addAllDetails(elements);
        }

        public final Builder addAllDetails(Iterable<? extends MergeResponse.ContentKeyDetails> elements) {
            for (MergeResponse.ContentKeyDetails contentKeyDetails : elements) {
                this.details.add(Objects.requireNonNull(contentKeyDetails, "details element"));
            }
            return this;
        }

        public ImmutableMergeResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergeResponse(this);
        }

        private boolean wasAppliedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean wasSuccessfulIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetBranch");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("effectiveTargetHash");
            }
            return "Cannot build MergeResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MergeResponse", generator="Immutables")
    static final class Json
    implements MergeResponse {
        boolean wasApplied;
        boolean wasAppliedIsSet;
        boolean wasSuccessful;
        boolean wasSuccessfulIsSet;
        @javax.annotation.Nullable
        String resultantTargetHash;
        @javax.annotation.Nullable
        String commonAncestor;
        @javax.annotation.Nullable
        String targetBranch;
        @javax.annotation.Nullable
        String effectiveTargetHash;
        @javax.annotation.Nullable
        String expectedHash;
        @javax.annotation.Nullable
        List<LogResponse.LogEntry> sourceCommits = Collections.emptyList();
        @javax.annotation.Nullable
        List<LogResponse.LogEntry> targetCommits = null;
        @javax.annotation.Nullable
        List<MergeResponse.ContentKeyDetails> details = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="wasApplied")
        public void setWasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.wasAppliedIsSet = true;
        }

        @JsonProperty(value="wasSuccessful")
        public void setWasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.wasSuccessfulIsSet = true;
        }

        @JsonProperty(value="resultantTargetHash")
        public void setResultantTargetHash(String resultantTargetHash) {
            this.resultantTargetHash = resultantTargetHash;
        }

        @JsonProperty(value="commonAncestor")
        public void setCommonAncestor(String commonAncestor) {
            this.commonAncestor = commonAncestor;
        }

        @JsonProperty(value="targetBranch")
        public void setTargetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
        }

        @JsonProperty(value="effectiveTargetHash")
        public void setEffectiveTargetHash(String effectiveTargetHash) {
            this.effectiveTargetHash = effectiveTargetHash;
        }

        @JsonProperty(value="expectedHash")
        public void setExpectedHash(String expectedHash) {
            this.expectedHash = expectedHash;
        }

        @JsonProperty(value="sourceCommits")
        public void setSourceCommits(List<LogResponse.LogEntry> sourceCommits) {
            this.sourceCommits = sourceCommits;
        }

        @JsonProperty(value="targetCommits")
        public void setTargetCommits(List<LogResponse.LogEntry> targetCommits) {
            this.targetCommits = targetCommits;
        }

        @JsonProperty(value="details")
        public void setDetails(List<MergeResponse.ContentKeyDetails> details) {
            this.details = details;
        }

        @Override
        public boolean wasApplied() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean wasSuccessful() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getResultantTargetHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommonAncestor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTargetBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEffectiveTargetHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExpectedHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<LogResponse.LogEntry> getSourceCommits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<LogResponse.LogEntry> getTargetCommits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MergeResponse.ContentKeyDetails> getDetails() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MergeResponse", generator="Immutables")
    private final class InitShim {
        private byte wasAppliedBuildStage = 0;
        private boolean wasApplied;
        private byte wasSuccessfulBuildStage = 0;
        private boolean wasSuccessful;

        private InitShim() {
        }

        boolean wasApplied() {
            if (this.wasAppliedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.wasAppliedBuildStage == 0) {
                this.wasAppliedBuildStage = (byte)-1;
                this.wasApplied = ImmutableMergeResponse.this.wasAppliedInitialize();
                this.wasAppliedBuildStage = 1;
            }
            return this.wasApplied;
        }

        void wasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.wasAppliedBuildStage = 1;
        }

        boolean wasSuccessful() {
            if (this.wasSuccessfulBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.wasSuccessfulBuildStage == 0) {
                this.wasSuccessfulBuildStage = (byte)-1;
                this.wasSuccessful = ImmutableMergeResponse.this.wasSuccessfulInitialize();
                this.wasSuccessfulBuildStage = 1;
            }
            return this.wasSuccessful;
        }

        void wasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.wasSuccessfulBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.wasAppliedBuildStage == -1) {
                attributes.add("wasApplied");
            }
            if (this.wasSuccessfulBuildStage == -1) {
                attributes.add("wasSuccessful");
            }
            return "Cannot build MergeResponse, attribute initializers form cycle " + attributes;
        }
    }
}

