/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.PaginatedResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="DiffResponse", generator="Immutables")
@Immutable
public final class ImmutableDiffResponse
implements DiffResponse {
    private final boolean isHasMore;
    @Nullable
    private final String token;
    private final List<DiffResponse.DiffEntry> diffs;
    @Nullable
    private final Reference effectiveFromReference;
    @Nullable
    private final Reference effectiveToReference;

    private ImmutableDiffResponse(Builder builder) {
        this.token = builder.token;
        this.diffs = ImmutableDiffResponse.createUnmodifiableList(true, builder.diffs);
        this.effectiveFromReference = builder.effectiveFromReference;
        this.effectiveToReference = builder.effectiveToReference;
        this.isHasMore = builder.isHasMoreIsSet() ? builder.isHasMore : DiffResponse.super.isHasMore();
    }

    private ImmutableDiffResponse(boolean isHasMore, @Nullable String token, List<DiffResponse.DiffEntry> diffs, @Nullable Reference effectiveFromReference, @Nullable Reference effectiveToReference) {
        this.isHasMore = isHasMore;
        this.token = token;
        this.diffs = diffs;
        this.effectiveFromReference = effectiveFromReference;
        this.effectiveToReference = effectiveToReference;
    }

    @Override
    @JsonProperty(value="hasMore")
    public boolean isHasMore() {
        return this.isHasMore;
    }

    @Override
    @JsonProperty(value="token")
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="diffs")
    public List<DiffResponse.DiffEntry> getDiffs() {
        return this.diffs;
    }

    @Override
    @JsonProperty(value="effectiveFromReference")
    @JsonView(value={Views.V2.class})
    @Nullable
    public Reference getEffectiveFromReference() {
        return this.effectiveFromReference;
    }

    @Override
    @JsonProperty(value="effectiveToReference")
    @JsonView(value={Views.V2.class})
    @Nullable
    public Reference getEffectiveToReference() {
        return this.effectiveToReference;
    }

    public final ImmutableDiffResponse withIsHasMore(boolean value) {
        if (this.isHasMore == value) {
            return this;
        }
        return new ImmutableDiffResponse(value, this.token, this.diffs, this.effectiveFromReference, this.effectiveToReference);
    }

    public final ImmutableDiffResponse withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableDiffResponse(this.isHasMore, value, this.diffs, this.effectiveFromReference, this.effectiveToReference);
    }

    public final ImmutableDiffResponse withDiffs(DiffResponse.DiffEntry ... elements) {
        List<DiffResponse.DiffEntry> newValue = ImmutableDiffResponse.createUnmodifiableList(false, ImmutableDiffResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDiffResponse(this.isHasMore, this.token, newValue, this.effectiveFromReference, this.effectiveToReference);
    }

    public final ImmutableDiffResponse withDiffs(Iterable<? extends DiffResponse.DiffEntry> elements) {
        if (this.diffs == elements) {
            return this;
        }
        List<DiffResponse.DiffEntry> newValue = ImmutableDiffResponse.createUnmodifiableList(false, ImmutableDiffResponse.createSafeList(elements, true, false));
        return new ImmutableDiffResponse(this.isHasMore, this.token, newValue, this.effectiveFromReference, this.effectiveToReference);
    }

    public final ImmutableDiffResponse withEffectiveFromReference(@Nullable Reference value) {
        if (this.effectiveFromReference == value) {
            return this;
        }
        return new ImmutableDiffResponse(this.isHasMore, this.token, this.diffs, value, this.effectiveToReference);
    }

    public final ImmutableDiffResponse withEffectiveToReference(@Nullable Reference value) {
        if (this.effectiveToReference == value) {
            return this;
        }
        return new ImmutableDiffResponse(this.isHasMore, this.token, this.diffs, this.effectiveFromReference, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiffResponse && this.equalTo(0, (ImmutableDiffResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiffResponse another) {
        return this.isHasMore == another.isHasMore && Objects.equals(this.token, another.token) && this.diffs.equals(another.diffs) && Objects.equals(this.effectiveFromReference, another.effectiveFromReference) && Objects.equals(this.effectiveToReference, another.effectiveToReference);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.isHasMore);
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + this.diffs.hashCode();
        h += (h << 5) + Objects.hashCode(this.effectiveFromReference);
        h += (h << 5) + Objects.hashCode(this.effectiveToReference);
        return h;
    }

    public String toString() {
        return "DiffResponse{isHasMore=" + this.isHasMore + ", token=" + this.token + ", diffs=" + this.diffs + ", effectiveFromReference=" + this.effectiveFromReference + ", effectiveToReference=" + this.effectiveToReference + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDiffResponse fromJson(Json json) {
        Builder builder = ImmutableDiffResponse.builder();
        if (json.isHasMoreIsSet) {
            builder.isHasMore(json.isHasMore);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.diffs != null) {
            builder.addAllDiffs(json.diffs);
        }
        if (json.effectiveFromReference != null) {
            builder.effectiveFromReference(json.effectiveFromReference);
        }
        if (json.effectiveToReference != null) {
            builder.effectiveToReference(json.effectiveToReference);
        }
        return builder.build();
    }

    public static ImmutableDiffResponse copyOf(DiffResponse instance) {
        if (instance instanceof ImmutableDiffResponse) {
            return (ImmutableDiffResponse)instance;
        }
        return ImmutableDiffResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="DiffResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_IS_HAS_MORE = 1L;
        private long optBits;
        private boolean isHasMore;
        @javax.annotation.Nullable
        private String token;
        private List<DiffResponse.DiffEntry> diffs = new ArrayList<DiffResponse.DiffEntry>();
        @javax.annotation.Nullable
        private Reference effectiveFromReference;
        @javax.annotation.Nullable
        private Reference effectiveToReference;

        private Builder() {
        }

        public final Builder from(PaginatedResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DiffResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedResponse instance;
            long bits = 0L;
            if (object instanceof PaginatedResponse) {
                instance = (PaginatedResponse)object;
                if ((bits & 2L) == 0L) {
                    this.isHasMore(instance.isHasMore());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    String tokenValue = instance.getToken();
                    if (tokenValue != null) {
                        this.token(tokenValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof DiffResponse) {
                Reference effectiveFromReferenceValue;
                instance = (DiffResponse)object;
                Reference effectiveToReferenceValue = instance.getEffectiveToReference();
                if (effectiveToReferenceValue != null) {
                    this.effectiveToReference(effectiveToReferenceValue);
                }
                if ((effectiveFromReferenceValue = instance.getEffectiveFromReference()) != null) {
                    this.effectiveFromReference(effectiveFromReferenceValue);
                }
                this.addAllDiffs(instance.getDiffs());
                if ((bits & 2L) == 0L) {
                    this.isHasMore(instance.isHasMore());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    String tokenValue = instance.getToken();
                    if (tokenValue != null) {
                        this.token(tokenValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="hasMore")
        public final Builder isHasMore(boolean isHasMore) {
            this.isHasMore = isHasMore;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="token")
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final Builder addDiffs(DiffResponse.DiffEntry element) {
            this.diffs.add(Objects.requireNonNull(element, "diffs element"));
            return this;
        }

        public final Builder addDiffs(DiffResponse.DiffEntry ... elements) {
            for (DiffResponse.DiffEntry element : elements) {
                this.diffs.add(Objects.requireNonNull(element, "diffs element"));
            }
            return this;
        }

        @JsonProperty(value="diffs")
        public final Builder diffs(Iterable<? extends DiffResponse.DiffEntry> elements) {
            this.diffs.clear();
            return this.addAllDiffs(elements);
        }

        public final Builder addAllDiffs(Iterable<? extends DiffResponse.DiffEntry> elements) {
            for (DiffResponse.DiffEntry diffEntry : elements) {
                this.diffs.add(Objects.requireNonNull(diffEntry, "diffs element"));
            }
            return this;
        }

        @JsonProperty(value="effectiveFromReference")
        @JsonView(value={Views.V2.class})
        public final Builder effectiveFromReference(Reference effectiveFromReference) {
            this.effectiveFromReference = effectiveFromReference;
            return this;
        }

        @JsonProperty(value="effectiveToReference")
        @JsonView(value={Views.V2.class})
        public final Builder effectiveToReference(Reference effectiveToReference) {
            this.effectiveToReference = effectiveToReference;
            return this;
        }

        public ImmutableDiffResponse build() {
            return new ImmutableDiffResponse(this);
        }

        private boolean isHasMoreIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DiffResponse", generator="Immutables")
    static final class Json
    implements DiffResponse {
        boolean isHasMore;
        boolean isHasMoreIsSet;
        @javax.annotation.Nullable
        String token;
        @javax.annotation.Nullable
        List<DiffResponse.DiffEntry> diffs = Collections.emptyList();
        @javax.annotation.Nullable
        Reference effectiveFromReference;
        @javax.annotation.Nullable
        Reference effectiveToReference;

        Json() {
        }

        @JsonProperty(value="hasMore")
        public void setIsHasMore(boolean isHasMore) {
            this.isHasMore = isHasMore;
            this.isHasMoreIsSet = true;
        }

        @JsonProperty(value="token")
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty(value="diffs")
        public void setDiffs(List<DiffResponse.DiffEntry> diffs) {
            this.diffs = diffs;
        }

        @JsonProperty(value="effectiveFromReference")
        @JsonView(value={Views.V2.class})
        public void setEffectiveFromReference(Reference effectiveFromReference) {
            this.effectiveFromReference = effectiveFromReference;
        }

        @JsonProperty(value="effectiveToReference")
        @JsonView(value={Views.V2.class})
        public void setEffectiveToReference(Reference effectiveToReference) {
            this.effectiveToReference = effectiveToReference;
        }

        @Override
        public boolean isHasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DiffResponse.DiffEntry> getDiffs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference getEffectiveFromReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference getEffectiveToReference() {
            throw new UnsupportedOperationException();
        }
    }
}

