/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.validation.constraints.NotEmpty;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableDetached;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Detached commit hash")
@JsonSerialize(as=ImmutableDetached.class)
@JsonDeserialize(as=ImmutableDetached.class)
@JsonTypeName(value="DETACHED")
@Value.Immutable
public interface Detached
extends Reference {
    public static final String REF_NAME = "DETACHED";

    @Override
    @JsonIgnore
    @Value.Redacted
    default public String getName() {
        return REF_NAME;
    }

    @Override
    @NotEmpty
    public String getHash();

    @Override
    @Value.Check
    default public void checkHash() {
        Validation.validateHash(this.getHash());
    }

    @Override
    default public Reference.ReferenceType getType() {
        throw new UnsupportedOperationException("Illegal use of detached reference");
    }

    public static ImmutableDetached.Builder builder() {
        return ImmutableDetached.builder();
    }

    public static Detached of(String hash) {
        return Detached.builder().hash(hash).build();
    }
}

