/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import javax.validation.constraints.NotNull;
import org.projectnessie.api.v1.http.HttpContentApi;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;

class HttpContentClient
implements HttpContentApi {
    private final HttpClient client;

    public HttpContentClient(HttpClient client) {
        this.client = client;
    }

    public Content getContent(@NotNull ContentKey key, String ref, String hashOnRef) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").path(key.toPathString()).queryParam("ref", ref).queryParam("hashOnRef", hashOnRef).get().readEntity(Content.class);
    }

    public GetMultipleContentsResponse getMultipleContents(@NotNull String ref, String hashOnRef, @NotNull GetMultipleContentsRequest request) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").queryParam("ref", ref).queryParam("hashOnRef", hashOnRef).post(request).readEntity(GetMultipleContentsResponse.class);
    }
}

