/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpClientReadTimeoutException;
import org.projectnessie.client.http.HttpHeaders;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.HttpRuntimeConfig;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.ResponseContextImpl;
import org.projectnessie.client.http.UriBuilder;

public class HttpRequest {
    private final HttpRuntimeConfig config;
    private final UriBuilder uriBuilder;
    private final HttpHeaders headers = new HttpHeaders();
    private String contentsType = "application/json; charset=utf-8";
    private String accept = "application/json; charset=utf-8";

    HttpRequest(HttpRuntimeConfig config) {
        this.uriBuilder = new UriBuilder(config.getBaseUri());
        this.config = config;
    }

    public HttpRequest contentsType(String contentsType) {
        this.contentsType = contentsType;
        return this;
    }

    public HttpRequest accept(String contentsType) {
        this.accept = contentsType;
        return this;
    }

    public HttpRequest path(String path) {
        this.uriBuilder.path(path);
        return this;
    }

    public HttpRequest queryParam(String name, String value) {
        this.uriBuilder.queryParam(name, value);
        return this;
    }

    public HttpRequest queryParam(String name, Integer value) {
        if (value != null) {
            this.uriBuilder.queryParam(name, value.toString());
        }
        return this;
    }

    public HttpRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeRequest(HttpClient.Method method, Object body) throws HttpClientException {
        URI uri = this.uriBuilder.build();
        try {
            HttpURLConnection con = (HttpURLConnection)uri.toURL().openConnection();
            con.setReadTimeout(this.config.getReadTimeoutMillis());
            con.setConnectTimeout(this.config.getConnectionTimeoutMillis());
            if (con instanceof HttpsURLConnection) {
                ((HttpsURLConnection)con).setSSLSocketFactory(this.config.getSslContext().getSocketFactory());
            }
            RequestContext context = new RequestContext(this.headers, uri, method, body);
            ResponseContextImpl responseContext = new ResponseContextImpl(con);
            try {
                boolean doesOutput;
                boolean postOrPut;
                this.headers.put("Accept", this.accept);
                boolean bl = postOrPut = method == HttpClient.Method.PUT || method == HttpClient.Method.POST;
                if (postOrPut) {
                    this.headers.put("Content-Type", this.contentsType);
                }
                boolean bl2 = doesOutput = postOrPut && body != null;
                if (!this.config.isDisableCompression()) {
                    this.headers.put("Accept-Encoding", "gzip;q=1.0, deflate;q=0.9");
                    if (doesOutput) {
                        this.headers.put("Content-Encoding", "gzip");
                    }
                }
                this.config.getRequestFilters().forEach(a -> a.filter(context));
                this.headers.applyTo(con);
                con.setRequestMethod(method.name());
                if (doesOutput) {
                    con.setDoOutput(true);
                    try (OutputStream out = con.getOutputStream();){
                        Class<?> bodyType;
                        if (!this.config.isDisableCompression()) {
                            out = new GZIPOutputStream(out);
                        }
                        if ((bodyType = body.getClass()) != String.class) {
                            this.config.getMapper().writerFor(bodyType).writeValue(out, body);
                        } else {
                            out.write(((String)body).getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
                con.connect();
                con.getResponseCode();
                List<BiConsumer<ResponseContext, Exception>> callbacks = context.getResponseCallbacks();
                if (callbacks != null) {
                    callbacks.forEach(callback -> callback.accept(responseContext, null));
                }
            }
            catch (IOException e) {
                List<BiConsumer<ResponseContext, Exception>> callbacks = context.getResponseCallbacks();
                if (callbacks != null) {
                    callbacks.forEach(callback -> callback.accept(null, e));
                }
                throw e;
            }
            this.config.getResponseFilters().forEach(responseFilter -> responseFilter.filter(responseContext));
            return new HttpResponse(responseContext, this.config.getMapper());
        }
        catch (ProtocolException e) {
            throw new HttpClientException(String.format("Cannot perform request against '%s'. Invalid protocol %s", new Object[]{uri, method}), e);
        }
        catch (JsonGenerationException | JsonMappingException e) {
            throw new HttpClientException(String.format("Cannot serialize body of %s request against '%s'. Unable to serialize %s", new Object[]{method, uri, body.getClass()}), e);
        }
        catch (MalformedURLException e) {
            throw new HttpClientException(String.format("Cannot perform %s request. Malformed Url for %s", new Object[]{method, this.uriBuilder.build()}), e);
        }
        catch (SocketTimeoutException e) {
            throw new HttpClientReadTimeoutException(String.format("Cannot finish %s request against '%s'. Timeout while waiting for response with a timeout of %ds", new Object[]{method, uri, this.config.getReadTimeoutMillis() / 1000}), e);
        }
        catch (IOException e) {
            throw new HttpClientException(String.format("Failed to execute %s request against '%s'.", new Object[]{method, uri}), e);
        }
    }

    public HttpResponse get() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.GET, null);
    }

    public HttpResponse delete() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.DELETE, null);
    }

    public HttpResponse post(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.POST, obj);
    }

    public HttpResponse put(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.PUT, obj);
    }

    public HttpRequest resolveTemplate(String name, String value) {
        this.uriBuilder.resolveTemplate(name, value);
        return this;
    }
}

