/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.NessieHttpClient;
import org.projectnessie.client.http.v1api.HttpApiV1;

public class HttpClientBuilder
implements NessieClientBuilder<HttpClientBuilder> {
    private final HttpClient.Builder builder = HttpClient.builder();
    private HttpAuthentication authentication;
    private boolean tracing;

    protected HttpClientBuilder() {
    }

    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    @Override
    public HttpClientBuilder fromSystemProperties() {
        return this.fromConfig(System::getProperty);
    }

    @Override
    public HttpClientBuilder fromConfig(Function<String, String> configuration) {
        String uri = configuration.apply("nessie.uri");
        if (uri != null) {
            this.withUri(URI.create(uri));
        }
        this.withAuthenticationFromConfig((Function)configuration);
        String s = configuration.apply("nessie.tracing");
        if (s != null) {
            this.withTracing(Boolean.parseBoolean(s));
        }
        if ((s = configuration.apply("nessie.transport.connect-timeout")) != null) {
            this.withConnectionTimeout(Integer.parseInt(s));
        }
        if ((s = configuration.apply("nessie.transport.read-timeout")) != null) {
            this.withReadTimeout(Integer.parseInt(s));
        }
        if ((s = configuration.apply("nessie.transport.disable-compression")) != null) {
            this.withDisableCompression(Boolean.parseBoolean(s));
        }
        return this;
    }

    @Override
    public HttpClientBuilder withAuthenticationFromConfig(Function<String, String> configuration) {
        this.withAuthentication(NessieAuthenticationProvider.fromConfig(configuration));
        return this;
    }

    @Override
    public HttpClientBuilder withUri(URI uri) {
        this.builder.setBaseUri(uri);
        return this;
    }

    @Override
    public HttpClientBuilder withAuthentication(NessieAuthentication authentication) {
        if (authentication != null && !(authentication instanceof HttpAuthentication)) {
            throw new IllegalArgumentException("HttpClientBuilder only accepts instances of HttpAuthentication");
        }
        this.authentication = (HttpAuthentication)authentication;
        return this;
    }

    public HttpClientBuilder withTracing(boolean tracing) {
        this.tracing = tracing;
        return this;
    }

    public HttpClientBuilder withReadTimeout(int readTimeoutMillis) {
        this.builder.setReadTimeoutMillis(readTimeoutMillis);
        return this;
    }

    public HttpClientBuilder withConnectionTimeout(int connectionTimeoutMillis) {
        this.builder.setConnectionTimeoutMillis(connectionTimeoutMillis);
        return this;
    }

    public HttpClientBuilder withDisableCompression(boolean disableCompression) {
        this.builder.setDisableCompression(disableCompression);
        return this;
    }

    public HttpClientBuilder withSSLContext(SSLContext sslContext) {
        this.builder.setSslContext(sslContext);
        return this;
    }

    @Override
    public <API extends NessieApi> API build(Class<API> apiVersion) {
        Objects.requireNonNull(apiVersion, "API version class must be non-null");
        NessieHttpClient client = new NessieHttpClient(this.authentication, this.tracing, this.builder);
        if (apiVersion.isAssignableFrom(HttpApiV1.class)) {
            return (API)new HttpApiV1(client);
        }
        throw new IllegalArgumentException(String.format("API version %s is not supported.", apiVersion.getName()));
    }
}

