/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.ext;

import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.ext.MultiVersionApiTest;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieClientCustomizer;
import org.projectnessie.client.ext.NessieClientFactory;
import org.projectnessie.client.ext.NessieClientUri;
import org.projectnessie.client.http.HttpClientBuilder;

public abstract class NessieClientResolver
implements ParameterResolver {
    protected abstract URI getBaseUri(ExtensionContext var1);

    private boolean isNessieUri(ParameterContext parameterContext) {
        return parameterContext.isAnnotated(NessieClientUri.class);
    }

    private boolean isNessieClient(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().isAssignableFrom(NessieClientFactory.class);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.isNessieUri(parameterContext) || this.isNessieClient(parameterContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.isNessieUri(parameterContext)) {
            NessieApiVersion apiVersion = MultiVersionApiTest.apiVersion(extensionContext);
            return apiVersion.resolve(this.getBaseUri(extensionContext));
        }
        if (this.isNessieClient(parameterContext)) {
            return this.clientFactoryForContext(extensionContext);
        }
        throw new IllegalStateException("Unsupported parameter: " + parameterContext);
    }

    private NessieClientFactory clientFactoryForContext(ExtensionContext extensionContext) {
        NessieApiVersion apiVersion = MultiVersionApiTest.apiVersion(extensionContext);
        URI uri = apiVersion.resolve(this.getBaseUri(extensionContext));
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        if (testInstance instanceof NessieClientCustomizer) {
            final NessieClientCustomizer testCustomizer = testInstance;
            return new ClientFactory(uri, apiVersion){

                @Override
                @Nonnull
                public NessieApiV1 make(NessieClientCustomizer customizer) {
                    return super.make((builder, version) -> customizer.configure(testCustomizer.configure(builder, version), version));
                }
            };
        }
        return new ClientFactory(uri, apiVersion);
    }

    private static class ClientFactory
    implements NessieClientFactory,
    Serializable {
        private final URI baseUri;
        private final NessieApiVersion apiVersion;

        private ClientFactory(URI baseUri, NessieApiVersion apiVersion) {
            this.baseUri = baseUri;
            this.apiVersion = apiVersion;
        }

        @Override
        public NessieApiVersion apiVersion() {
            return this.apiVersion;
        }

        @Override
        @Nonnull
        public NessieApiV1 make(NessieClientCustomizer customizer) {
            URI uri = this.apiVersion.resolve(this.baseUri);
            NessieClientBuilder<?> builder = customizer.configure((NessieClientBuilder<?>)HttpClientBuilder.builder().withUri(uri), this.apiVersion);
            return this.apiVersion.build(builder);
        }
    }
}

