/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.UpdateProperties;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewVersionMetadata;

class PropertiesUpdate
implements UpdateProperties {
    private final ViewOperations ops;
    private final Map<String, String> updates = Maps.newHashMap();
    private final Set<String> removals = Sets.newHashSet();
    private ViewVersionMetadata base;

    PropertiesUpdate(ViewOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    @Override
    public UpdateProperties set(String key, String value) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        Preconditions.checkNotNull((Object)value, (Object)"Value cannot be null");
        Preconditions.checkArgument((!this.removals.contains(key) ? 1 : 0) != 0, (String)"Cannot remove and update the same key: %s", (Object)key);
        this.updates.put(key, value);
        return this;
    }

    @Override
    public UpdateProperties remove(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        Preconditions.checkArgument((!this.updates.keySet().contains(key) ? 1 : 0) != 0, (String)"Cannot remove and update the same key: %s", (Object)key);
        this.removals.add(key);
        return this;
    }

    public Map<String, String> apply() {
        this.base = this.ops.refresh();
        HashMap newProperties = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.base.properties().entrySet()) {
            if (this.removals.contains(entry.getKey())) continue;
            newProperties.put(entry.getKey(), entry.getValue());
        }
        newProperties.putAll(this.updates);
        return newProperties;
    }

    public void commit() {
        Tasks.foreach((Object[])new ViewOperations[]{this.ops}).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff((long)this.base.propertyAsInt("commit.retry.min-wait-ms", 100), (long)this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), (long)this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn(CommitFailedException.class).run(taskOps -> {
            Object newProperties = this.apply();
            ViewVersionMetadata updated = this.base.replaceProperties((Map<String, String>)newProperties);
            taskOps.commit(this.base, updated, new HashMap<String, String>());
        });
    }
}

