/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.types.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.common.ULong;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.pb.Checked;
import org.projectnessie.cel.common.types.ref.FieldType;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeDescription;
import org.projectnessie.cel.relocated.com.google.protobuf.ByteString;
import org.projectnessie.cel.relocated.com.google.protobuf.Timestamp;
import org.projectnessie.cel.types.jackson.JacksonFieldType;

final class JacksonTypeDescription
implements TypeDescription {
    private final JavaType javaType;
    private final String name;
    private final Type type;
    private final org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type pbType;
    private final Map<String, JacksonFieldType> fieldTypes;

    JacksonTypeDescription(JavaType javaType, JsonSerializer<?> ser, TypeQuery typeQuery) {
        this.javaType = javaType;
        this.name = javaType.getRawClass().getName();
        this.type = TypeT.newObjectTypeValue(this.name);
        this.pbType = org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type.newBuilder().setMessageType(this.name).build();
        this.fieldTypes = new HashMap<String, JacksonFieldType>();
        Iterator propIter = ser.properties();
        while (propIter.hasNext()) {
            PropertyWriter pw = (PropertyWriter)propIter.next();
            String n = pw.getName();
            JacksonFieldType ft = new JacksonFieldType(this.findTypeForJacksonType(pw.getType(), typeQuery), target -> this.fromObject(target, n) != null, target -> this.fromObject(target, n), pw);
            this.fieldTypes.put(n, ft);
        }
    }

    org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type findTypeForJacksonType(JavaType type, TypeQuery typeQuery) {
        Class rawClass = type.getRawClass();
        if (rawClass == Boolean.TYPE || rawClass == Boolean.class) {
            return Checked.checkedBool;
        }
        if (rawClass == Long.TYPE || rawClass == Long.class || rawClass == Integer.TYPE || rawClass == Integer.class || rawClass == Short.TYPE || rawClass == Short.class || rawClass == Byte.TYPE || rawClass == Byte.class) {
            return Checked.checkedInt;
        }
        if (rawClass == ULong.class) {
            return Checked.checkedUint;
        }
        if (rawClass == byte[].class || rawClass == ByteString.class) {
            return Checked.checkedBytes;
        }
        if (rawClass == Double.TYPE || rawClass == Double.class || rawClass == Float.TYPE || rawClass == Float.class) {
            return Checked.checkedDouble;
        }
        if (rawClass == String.class) {
            return Checked.checkedString;
        }
        if (rawClass == org.projectnessie.cel.relocated.com.google.protobuf.Duration.class || rawClass == Duration.class) {
            return Checked.checkedDuration;
        }
        if (rawClass == Timestamp.class || Instant.class.isAssignableFrom(rawClass) || ZonedDateTime.class.isAssignableFrom(rawClass)) {
            return Checked.checkedTimestamp;
        }
        if (Map.class.isAssignableFrom(rawClass)) {
            org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type keyType = this.findTypeForJacksonType(type.getKeyType(), typeQuery);
            org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type valueType = this.findTypeForJacksonType(type.getContentType(), typeQuery);
            return Decls.newMapType(keyType, valueType);
        }
        if (List.class.isAssignableFrom(rawClass)) {
            org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type valueType = this.findTypeForJacksonType(type.getContentType(), typeQuery);
            return Decls.newListType(valueType);
        }
        if (type.isEnumType()) {
            return typeQuery.getType(type);
        }
        org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type t = typeQuery.getType(type);
        if (t == null) {
            throw new UnsupportedOperationException(String.format("Unsupported Java Type '%s'", type));
        }
        return t;
    }

    boolean hasProperty(String property) {
        return this.fieldTypes.containsKey(property);
    }

    Object fromObject(Object value, String property) {
        JacksonFieldType ft = this.fieldTypes.get(property);
        if (ft == null) {
            throw new IllegalArgumentException(String.format("No property named '%s'", property));
        }
        PropertyWriter pw = ft.propertyWriter();
        if (pw instanceof BeanPropertyWriter) {
            try {
                return ((BeanPropertyWriter)pw).get(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (pw == null) {
            return null;
        }
        throw new UnsupportedOperationException(String.format("Unknown property-writer '%s' for property '%s'", pw.getClass().getName(), property));
    }

    Type type() {
        return this.type;
    }

    org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type pbType() {
        return this.pbType;
    }

    FieldType fieldType(String fieldName) {
        return this.fieldTypes.get(fieldName);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class<?> reflectType() {
        return this.javaType.getRawClass();
    }

    @FunctionalInterface
    static interface TypeQuery {
        public org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type getType(JavaType var1);
    }
}

