/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent.status;

import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.projectnessie.cel.relocated.org.agrona.DirectBuffer;
import org.projectnessie.cel.relocated.org.agrona.MutableDirectBuffer;
import org.projectnessie.cel.relocated.org.agrona.concurrent.AtomicBuffer;
import org.projectnessie.cel.relocated.org.agrona.concurrent.EpochClock;
import org.projectnessie.cel.relocated.org.agrona.concurrent.status.CountersManager;

public class ConcurrentCountersManager
extends CountersManager {
    private final ReentrantLock lock = new ReentrantLock();

    public ConcurrentCountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer) {
        super(metaDataBuffer, valuesBuffer);
    }

    public ConcurrentCountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset) {
        super(metaDataBuffer, valuesBuffer, labelCharset);
    }

    public ConcurrentCountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset, EpochClock epochClock, long freeToReuseTimeoutMs) {
        super(metaDataBuffer, valuesBuffer, labelCharset, epochClock, freeToReuseTimeoutMs);
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            int n = super.available();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate(String label, int typeId) {
        this.lock.lock();
        try {
            int n = super.allocate(label, typeId);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        this.lock.lock();
        try {
            int n = super.allocate(label, typeId, keyFunc);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        this.lock.lock();
        try {
            int n = super.allocate(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void free(int counterId) {
        this.lock.lock();
        try {
            super.free(counterId);
        }
        finally {
            this.lock.unlock();
        }
    }
}

