/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent;

import java.util.concurrent.TimeUnit;
import org.projectnessie.cel.relocated.org.agrona.concurrent.EpochNanoClock;

public class OffsetEpochNanoClock
implements EpochNanoClock {
    private static final int DEFAULT_MAX_MEASUREMENT_RETRIES = 100;
    private static final long DEFAULT_MEASUREMENT_THRESHOLD_NS = 250L;
    private static final long DEFAULT_RESAMPLE_INTERVAL_NS = TimeUnit.HOURS.toNanos(1L);
    private final int maxMeasurementRetries;
    private final long measurementThresholdNs;
    private final long resampleIntervalNs;
    private volatile TimeFields timeFields;

    public OffsetEpochNanoClock() {
        this(100, 250L, DEFAULT_RESAMPLE_INTERVAL_NS);
    }

    public OffsetEpochNanoClock(int maxMeasurementRetries, long measurementThresholdNs, long resampleIntervalNs) {
        this.maxMeasurementRetries = maxMeasurementRetries;
        this.measurementThresholdNs = measurementThresholdNs;
        this.resampleIntervalNs = resampleIntervalNs;
        this.sample();
    }

    public void sample() {
        long bestInitialCurrentNanoTime = 0L;
        long bestInitialNanoTime = 0L;
        long bestNanoTimeWindow = Long.MAX_VALUE;
        int maxMeasurementRetries = this.maxMeasurementRetries;
        long measurementThresholdNs = this.measurementThresholdNs;
        for (int i = 0; i < maxMeasurementRetries; ++i) {
            long firstNanoTime = System.nanoTime();
            long initialCurrentTimeMillis = System.currentTimeMillis();
            long secondNanoTime = System.nanoTime();
            long nanoTimeWindow = secondNanoTime - firstNanoTime;
            if (nanoTimeWindow < measurementThresholdNs) {
                this.timeFields = new TimeFields(TimeUnit.MILLISECONDS.toNanos(initialCurrentTimeMillis), firstNanoTime + secondNanoTime >> 1, true);
                return;
            }
            if (nanoTimeWindow >= bestNanoTimeWindow) continue;
            bestInitialCurrentNanoTime = TimeUnit.MILLISECONDS.toNanos(initialCurrentTimeMillis);
            bestInitialNanoTime = firstNanoTime + secondNanoTime >> 1;
            bestNanoTimeWindow = nanoTimeWindow;
        }
        this.timeFields = new TimeFields(bestInitialCurrentNanoTime, bestInitialNanoTime, false);
    }

    @Override
    public long nanoTime() {
        TimeFields timeFields = this.timeFields;
        long nanoTimeAdjustment = System.nanoTime() - timeFields.initialNanoTime;
        if (nanoTimeAdjustment < 0L || nanoTimeAdjustment > this.resampleIntervalNs) {
            this.sample();
            return this.nanoTime();
        }
        return timeFields.initialCurrentNanoTime + nanoTimeAdjustment;
    }

    public boolean isWithinThreshold() {
        return this.timeFields.isWithinThreshold;
    }

    static final class TimeFields {
        final long initialCurrentNanoTime;
        final long initialNanoTime;
        final boolean isWithinThreshold;

        private TimeFields(long initialCurrentNanoTime, long initialNanoTime, boolean isWithinThreshold) {
            this.initialNanoTime = initialNanoTime;
            this.initialCurrentNanoTime = initialCurrentNanoTime;
            this.isWithinThreshold = isWithinThreshold;
        }
    }
}

