/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona;

import java.nio.ByteBuffer;
import org.projectnessie.cel.relocated.org.agrona.BitUtil;
import org.projectnessie.cel.relocated.org.agrona.DirectBuffer;
import org.projectnessie.cel.relocated.org.agrona.MutableDirectBuffer;
import org.projectnessie.cel.relocated.org.agrona.collections.ArrayUtil;
import org.projectnessie.cel.relocated.org.agrona.concurrent.UnsafeBuffer;

public class ExpandableRingBuffer {
    public static final int MAX_CAPACITY = 0x40000000;
    public static final int HEADER_ALIGNMENT = 8;
    public static final int HEADER_LENGTH = 8;
    private static final int MESSAGE_LENGTH_OFFSET = 0;
    private static final int MESSAGE_TYPE_OFFSET = 4;
    private static final int MESSAGE_TYPE_PADDING = 0;
    private static final int MESSAGE_TYPE_DATA = 1;
    private final int maxCapacity;
    private int capacity;
    private int mask;
    private long head;
    private long tail;
    private final UnsafeBuffer buffer = new UnsafeBuffer();
    private final boolean isDirect;

    public ExpandableRingBuffer() {
        this(0, 0x40000000, true);
    }

    public ExpandableRingBuffer(int initialCapacity, int maxCapacity, boolean isDirect) {
        this.isDirect = isDirect;
        this.maxCapacity = maxCapacity;
        if (maxCapacity < 0 || maxCapacity > 0x40000000 || !BitUtil.isPowerOfTwo(maxCapacity)) {
            throw new IllegalArgumentException("illegal max capacity: " + maxCapacity);
        }
        if (0 == initialCapacity) {
            this.buffer.wrap(ArrayUtil.EMPTY_BYTE_ARRAY);
            return;
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity < 0 : " + initialCapacity);
        }
        this.capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        if (this.capacity < 0) {
            throw new IllegalArgumentException("invalid initial capacity: " + initialCapacity);
        }
        this.mask = this.capacity - 1;
        this.buffer.wrap(isDirect ? ByteBuffer.allocateDirect(this.capacity) : ByteBuffer.allocate(this.capacity));
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public int capacity() {
        return this.capacity;
    }

    public int size() {
        return (int)(this.tail - this.head);
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public long head() {
        return this.head;
    }

    public long tail() {
        return this.tail;
    }

    public void reset(int requiredCapacity) {
        if (requiredCapacity < 0) {
            throw new IllegalArgumentException("required capacity <= 0 : " + requiredCapacity);
        }
        int newCapacity = BitUtil.findNextPositivePowerOfTwo(requiredCapacity);
        if (newCapacity < 0) {
            throw new IllegalArgumentException("invalid required capacity: " + requiredCapacity);
        }
        if (newCapacity > this.maxCapacity) {
            throw new IllegalArgumentException("requiredCapacity=" + requiredCapacity + " > maxCapacity=" + this.maxCapacity);
        }
        if (newCapacity != this.capacity) {
            this.capacity = newCapacity;
            this.mask = newCapacity == 0 ? 0 : newCapacity - 1;
            this.buffer.wrap(this.isDirect ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity));
        }
        this.head = 0L;
        this.tail = 0L;
    }

    public int forEach(MessageConsumer messageConsumer, int limit) {
        long position = this.head;
        int count = 0;
        while (count < limit && position < this.tail) {
            int offset = (int)position & this.mask;
            int length = this.buffer.getInt(offset + 0);
            int typeId = this.buffer.getInt(offset + 4);
            int alignedLength = BitUtil.align(length, 8);
            position += (long)alignedLength;
            if (0 == typeId) continue;
            int headOffset = (int)(position - this.head);
            if (!messageConsumer.onMessage(this.buffer, offset + 8, length - 8, headOffset)) break;
            ++count;
        }
        return (int)(position - this.head);
    }

    public int forEach(int headOffset, MessageConsumer messageConsumer, int limit) {
        long initialPosition;
        if (headOffset < 0 || headOffset > this.size()) {
            throw new IllegalArgumentException("size=" + this.size() + " : headOffset=" + headOffset);
        }
        if (!BitUtil.isAligned(headOffset, 8)) {
            throw new IllegalArgumentException(headOffset + " not aligned to " + 8);
        }
        long position = initialPosition = this.head + (long)headOffset;
        int count = 0;
        while (count < limit && position < this.tail) {
            int offset = (int)position & this.mask;
            int length = this.buffer.getInt(offset + 0);
            int typeId = this.buffer.getInt(offset + 4);
            int alignedLength = BitUtil.align(length, 8);
            position += (long)alignedLength;
            if (0 == typeId) continue;
            int result = (int)(position - this.head);
            if (!messageConsumer.onMessage(this.buffer, offset + 8, length - 8, result)) break;
            ++count;
        }
        return (int)(position - initialPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consume(MessageConsumer messageConsumer, int messageLimit) {
        int bytes;
        int count = 0;
        long position = this.head;
        try {
            while (count < messageLimit && position < this.tail) {
                int offset = (int)position & this.mask;
                int length = this.buffer.getInt(offset + 0);
                int typeId = this.buffer.getInt(offset + 4);
                int alignedLength = BitUtil.align(length, 8);
                position += (long)alignedLength;
                if (0 == typeId) continue;
                int headOffset = (int)(position - this.head);
                if (!messageConsumer.onMessage(this.buffer, offset + 8, length - 8, headOffset)) {
                    position -= (long)alignedLength;
                    break;
                }
                ++count;
            }
        }
        finally {
            bytes = (int)(position - this.head);
            this.head = position;
        }
        return bytes;
    }

    public boolean append(DirectBuffer srcBuffer, int srcOffset, int srcLength) {
        int toEndRemaining;
        int totalRemaining;
        int headOffset = (int)this.head & this.mask;
        int tailOffset = (int)this.tail & this.mask;
        int alignedLength = BitUtil.align(8 + srcLength, 8);
        if (alignedLength > (totalRemaining = this.capacity - (int)(this.tail - this.head))) {
            this.resize(alignedLength);
        } else if (tailOffset >= headOffset && alignedLength > (toEndRemaining = this.capacity - tailOffset)) {
            if (alignedLength <= totalRemaining - toEndRemaining) {
                this.buffer.putInt(tailOffset + 0, toEndRemaining);
                this.buffer.putInt(tailOffset + 4, 0);
                this.tail += (long)toEndRemaining;
            } else {
                this.resize(alignedLength);
            }
        }
        int newTotalRemaining = this.capacity - (int)(this.tail - this.head);
        if (alignedLength > newTotalRemaining) {
            return false;
        }
        this.writeMessage(srcBuffer, srcOffset, srcLength);
        this.tail += (long)alignedLength;
        return true;
    }

    private void resize(int newMessageLength) {
        int newCapacity = BitUtil.findNextPositivePowerOfTwo(this.capacity + newMessageLength);
        if (newCapacity < this.capacity || newCapacity > this.maxCapacity) {
            return;
        }
        UnsafeBuffer tempBuffer = new UnsafeBuffer(this.isDirect ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity));
        int headOffset = (int)this.head & this.mask;
        int remaining = (int)(this.tail - this.head);
        int firstCopyLength = Math.min(remaining, this.capacity - headOffset);
        tempBuffer.putBytes(0, this.buffer, headOffset, firstCopyLength);
        int tailOffset = firstCopyLength;
        if (firstCopyLength < remaining) {
            int length = remaining - firstCopyLength;
            tempBuffer.putBytes(firstCopyLength, this.buffer, 0, length);
            tailOffset += length;
        }
        this.buffer.wrap(tempBuffer);
        this.capacity = newCapacity;
        this.mask = newCapacity - 1;
        this.head = 0L;
        this.tail = tailOffset;
    }

    private void writeMessage(DirectBuffer srcBuffer, int srcOffset, int srcLength) {
        int offset = (int)this.tail & this.mask;
        this.buffer.putInt(offset + 0, 8 + srcLength);
        this.buffer.putInt(offset + 4, 1);
        this.buffer.putBytes(offset + 8, srcBuffer, srcOffset, srcLength);
    }

    @FunctionalInterface
    public static interface MessageConsumer {
        public boolean onMessage(MutableDirectBuffer var1, int var2, int var3, int var4);
    }
}

