/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.parser;

import org.projectnessie.cel.shaded.org.antlr.v4.runtime.CharStream;
import org.projectnessie.cel.shaded.org.antlr.v4.runtime.misc.Interval;

public final class StringCharStream
implements CharStream {
    private final String buf;
    private final String src;
    private int pos;

    public StringCharStream(String buf, String src) {
        this.buf = buf;
        this.src = src;
    }

    @Override
    public void consume() {
        if (this.pos >= this.buf.length()) {
            throw new RuntimeException("cannot consume EOF");
        }
        ++this.pos;
    }

    @Override
    public int LA(int offset) {
        if (offset == 0) {
            return 0;
        }
        if (offset < 0) {
            ++offset;
        }
        this.pos = this.pos + offset - 1;
        if (this.pos < 0 || this.pos >= this.buf.length()) {
            return -1;
        }
        return this.buf.charAt(this.pos);
    }

    @Override
    public int mark() {
        return -1;
    }

    @Override
    public void release(int marker) {
    }

    @Override
    public int index() {
        return this.pos;
    }

    @Override
    public void seek(int index) {
        if (index <= this.pos) {
            this.pos = index;
            return;
        }
        this.pos = Math.min(index, this.buf.length());
    }

    @Override
    public int size() {
        return this.buf.length();
    }

    @Override
    public String getSourceName() {
        return this.src;
    }

    @Override
    public String getText(Interval interval) {
        int start = interval.a;
        int stop = interval.b;
        if (stop >= this.buf.length()) {
            stop = this.buf.length() - 1;
        }
        if (start >= this.buf.length()) {
            return "";
        }
        return this.buf.substring(start, stop + 1);
    }

    public String toString() {
        return this.buf;
    }
}

