/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common;

import java.util.Objects;
import org.projectnessie.cel.common.Location;
import org.projectnessie.cel.common.Source;

public final class CELError
implements Comparable<CELError> {
    private static final char dot = '.';
    private static final char ind = '^';
    private final Location location;
    private final String message;
    private final Exception exception;

    public CELError(Exception e, Location location, String message) {
        this.exception = e;
        this.location = location;
        this.message = message;
    }

    public Exception getException() {
        return this.exception;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public int compareTo(CELError o) {
        int r = this.location.compareTo(o.location);
        if (r == 0) {
            r = this.message.compareTo(o.message);
        }
        return r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CELError error = (CELError)o;
        return Objects.equals(this.location, error.location) && Objects.equals(this.message, error.message);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.message);
    }

    public String toString() {
        return "Error{location=" + this.location + ", message='" + this.message + '\'' + '}';
    }

    public String toDisplayString(Source source) {
        StringBuilder result = new StringBuilder(String.format("ERROR: %s:%d:%d: %s", source.description(), this.location.line(), this.location.column() + 1, this.message));
        String snippet = source.snippet(this.location.line());
        if (snippet != null) {
            snippet = snippet.replace('\t', ' ');
            result.append("\n | ").append(snippet);
            result.append("\n | ");
            for (int i = 0; i < this.location.column(); ++i) {
                result.append('.');
            }
            result.append('^');
        }
        return result.toString();
    }
}

