/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.checker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.checker.Types;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Decl;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type;

final class Standard {
    private Standard() {
    }

    static List<Decl> makeStandardDeclarations() {
        Type paramA = Decls.newTypeParamType("A");
        List<String> typeParamAList = Collections.singletonList("A");
        Type listOfA = Decls.newListType(paramA);
        Type paramB = Decls.newTypeParamType("B");
        List<String> typeParamABList = Arrays.asList("A", "B");
        Type mapOfAB = Decls.newMapType(paramA, paramB);
        ArrayList<Decl> idents = new ArrayList<Decl>();
        for (Type t : Arrays.asList(Decls.Int, Decls.Uint, Decls.Bool, Decls.Double, Decls.Bytes, Decls.String)) {
            idents.add(Decls.newVar(Types.formatCheckedType(t), Decls.newTypeType(t)));
        }
        idents.add(Decls.newVar("list", Decls.newTypeType(listOfA)));
        idents.add(Decls.newVar("map", Decls.newTypeType(mapOfAB)));
        idents.add(Decls.newVar("null_type", Decls.newTypeType(Decls.Null)));
        idents.add(Decls.newVar("type", Decls.newTypeType(Decls.newTypeType(null))));
        idents.add(Decls.newFunction(Operator.Conditional.id, Decls.newParameterizedOverload("conditional", Arrays.asList(Decls.Bool, paramA, paramA), paramA, typeParamAList)));
        idents.add(Decls.newFunction(Operator.LogicalAnd.id, Decls.newOverload("logical_and", Arrays.asList(Decls.Bool, Decls.Bool), Decls.Bool)));
        idents.add(Decls.newFunction(Operator.LogicalOr.id, Decls.newOverload("logical_or", Arrays.asList(Decls.Bool, Decls.Bool), Decls.Bool)));
        idents.add(Decls.newFunction(Operator.LogicalNot.id, Decls.newOverload("logical_not", Collections.singletonList(Decls.Bool), Decls.Bool)));
        idents.add(Decls.newFunction(Operator.NotStrictlyFalse.id, Decls.newOverload("not_strictly_false", Collections.singletonList(Decls.Bool), Decls.Bool)));
        idents.add(Decls.newFunction(Operator.Less.id, Decls.newOverload("less_bool", Arrays.asList(Decls.Bool, Decls.Bool), Decls.Bool), Decls.newOverload("less_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Bool), Decls.newOverload("less_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Bool), Decls.newOverload("less_double", Arrays.asList(Decls.Double, Decls.Double), Decls.Bool), Decls.newOverload("less_string", Arrays.asList(Decls.String, Decls.String), Decls.Bool), Decls.newOverload("less_bytes", Arrays.asList(Decls.Bytes, Decls.Bytes), Decls.Bool), Decls.newOverload("less_timestamp", Arrays.asList(Decls.Timestamp, Decls.Timestamp), Decls.Bool), Decls.newOverload("less_duration", Arrays.asList(Decls.Duration, Decls.Duration), Decls.Bool)));
        idents.add(Decls.newFunction(Operator.LessEquals.id, Decls.newOverload("less_equals_bool", Arrays.asList(Decls.Bool, Decls.Bool), Decls.Bool), Decls.newOverload("less_equals_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Bool), Decls.newOverload("less_equals_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Bool), Decls.newOverload("less_equals_double", Arrays.asList(Decls.Double, Decls.Double), Decls.Bool), Decls.newOverload("less_equals_string", Arrays.asList(Decls.String, Decls.String), Decls.Bool), Decls.newOverload("less_equals_bytes", Arrays.asList(Decls.Bytes, Decls.Bytes), Decls.Bool), Decls.newOverload("less_equals_timestamp", Arrays.asList(Decls.Timestamp, Decls.Timestamp), Decls.Bool), Decls.newOverload("less_equals_duration", Arrays.asList(Decls.Duration, Decls.Duration), Decls.Bool)));
        idents.add(Decls.newFunction(Operator.Greater.id, Decls.newOverload("greater_bool", Arrays.asList(Decls.Bool, Decls.Bool), Decls.Bool), Decls.newOverload("greater_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Bool), Decls.newOverload("greater_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Bool), Decls.newOverload("greater_double", Arrays.asList(Decls.Double, Decls.Double), Decls.Bool), Decls.newOverload("greater_string", Arrays.asList(Decls.String, Decls.String), Decls.Bool), Decls.newOverload("greater_bytes", Arrays.asList(Decls.Bytes, Decls.Bytes), Decls.Bool), Decls.newOverload("greater_timestamp", Arrays.asList(Decls.Timestamp, Decls.Timestamp), Decls.Bool), Decls.newOverload("greater_duration", Arrays.asList(Decls.Duration, Decls.Duration), Decls.Bool)));
        idents.add(Decls.newFunction(Operator.GreaterEquals.id, Decls.newOverload("greater_equals_bool", Arrays.asList(Decls.Bool, Decls.Bool), Decls.Bool), Decls.newOverload("greater_equals_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Bool), Decls.newOverload("greater_equals_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Bool), Decls.newOverload("greater_equals_double", Arrays.asList(Decls.Double, Decls.Double), Decls.Bool), Decls.newOverload("greater_equals_string", Arrays.asList(Decls.String, Decls.String), Decls.Bool), Decls.newOverload("greater_equals_bytes", Arrays.asList(Decls.Bytes, Decls.Bytes), Decls.Bool), Decls.newOverload("greater_equals_timestamp", Arrays.asList(Decls.Timestamp, Decls.Timestamp), Decls.Bool), Decls.newOverload("greater_equals_duration", Arrays.asList(Decls.Duration, Decls.Duration), Decls.Bool)));
        idents.add(Decls.newFunction(Operator.Equals.id, Decls.newParameterizedOverload("equals", Arrays.asList(paramA, paramB), Decls.Bool, typeParamABList)));
        idents.add(Decls.newFunction(Operator.NotEquals.id, Decls.newParameterizedOverload("not_equals", Arrays.asList(paramA, paramB), Decls.Bool, typeParamABList)));
        idents.add(Decls.newFunction(Operator.Subtract.id, Decls.newOverload("subtract_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Int), Decls.newOverload("subtract_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Uint), Decls.newOverload("subtract_double", Arrays.asList(Decls.Double, Decls.Double), Decls.Double), Decls.newOverload("subtract_timestamp_timestamp", Arrays.asList(Decls.Timestamp, Decls.Timestamp), Decls.Duration), Decls.newOverload("subtract_timestamp_duration", Arrays.asList(Decls.Timestamp, Decls.Duration), Decls.Timestamp), Decls.newOverload("subtract_duration_duration", Arrays.asList(Decls.Duration, Decls.Duration), Decls.Duration)));
        idents.add(Decls.newFunction(Operator.Multiply.id, Decls.newOverload("multiply_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Int), Decls.newOverload("multiply_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Uint), Decls.newOverload("multiply_double", Arrays.asList(Decls.Double, Decls.Double), Decls.Double)));
        idents.add(Decls.newFunction(Operator.Divide.id, Decls.newOverload("divide_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Int), Decls.newOverload("divide_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Uint), Decls.newOverload("divide_double", Arrays.asList(Decls.Double, Decls.Double), Decls.Double)));
        idents.add(Decls.newFunction(Operator.Modulo.id, Decls.newOverload("modulo_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Int), Decls.newOverload("modulo_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Uint)));
        idents.add(Decls.newFunction(Operator.Add.id, Decls.newOverload("add_int64", Arrays.asList(Decls.Int, Decls.Int), Decls.Int), Decls.newOverload("add_uint64", Arrays.asList(Decls.Uint, Decls.Uint), Decls.Uint), Decls.newOverload("add_double", Arrays.asList(Decls.Double, Decls.Double), Decls.Double), Decls.newOverload("add_string", Arrays.asList(Decls.String, Decls.String), Decls.String), Decls.newOverload("add_bytes", Arrays.asList(Decls.Bytes, Decls.Bytes), Decls.Bytes), Decls.newParameterizedOverload("add_list", Arrays.asList(listOfA, listOfA), listOfA, typeParamAList), Decls.newOverload("add_timestamp_duration", Arrays.asList(Decls.Timestamp, Decls.Duration), Decls.Timestamp), Decls.newOverload("add_duration_timestamp", Arrays.asList(Decls.Duration, Decls.Timestamp), Decls.Timestamp), Decls.newOverload("add_duration_duration", Arrays.asList(Decls.Duration, Decls.Duration), Decls.Duration)));
        idents.add(Decls.newFunction(Operator.Negate.id, Decls.newOverload("negate_int64", Collections.singletonList(Decls.Int), Decls.Int), Decls.newOverload("negate_double", Collections.singletonList(Decls.Double), Decls.Double)));
        idents.add(Decls.newFunction(Operator.Index.id, Decls.newParameterizedOverload("index_list", Arrays.asList(listOfA, Decls.Int), paramA, typeParamAList), Decls.newParameterizedOverload("index_map", Arrays.asList(mapOfAB, paramA), paramB, typeParamABList)));
        idents.add(Decls.newFunction("size", Decls.newInstanceOverload("string_size", Collections.singletonList(Decls.String), Decls.Int), Decls.newInstanceOverload("bytes_size", Collections.singletonList(Decls.Bytes), Decls.Int), Decls.newParameterizedInstanceOverload("list_size", Collections.singletonList(listOfA), Decls.Int, typeParamAList), Decls.newParameterizedInstanceOverload("map_size", Collections.singletonList(mapOfAB), Decls.Int, typeParamABList), Decls.newOverload("size_string", Collections.singletonList(Decls.String), Decls.Int), Decls.newOverload("size_bytes", Collections.singletonList(Decls.Bytes), Decls.Int), Decls.newParameterizedOverload("size_list", Collections.singletonList(listOfA), Decls.Int, typeParamAList), Decls.newParameterizedOverload("size_map", Collections.singletonList(mapOfAB), Decls.Int, typeParamABList)));
        idents.add(Decls.newFunction(Operator.In.id, Decls.newParameterizedOverload("in_list", Arrays.asList(paramA, listOfA), Decls.Bool, typeParamAList), Decls.newParameterizedOverload("in_map", Arrays.asList(paramA, mapOfAB), Decls.Bool, typeParamABList)));
        idents.add(Decls.newFunction("in", Decls.newParameterizedOverload("in_list", Arrays.asList(paramA, listOfA), Decls.Bool, typeParamAList), Decls.newParameterizedOverload("in_map", Arrays.asList(paramA, mapOfAB), Decls.Bool, typeParamABList)));
        idents.add(Decls.newFunction("type", Decls.newParameterizedOverload("type", Collections.singletonList(paramA), Decls.newTypeType(paramA), typeParamAList)));
        idents.add(Decls.newFunction("int", Decls.newOverload("int64_to_int64", Collections.singletonList(Decls.Int), Decls.Int), Decls.newOverload("uint64_to_int64", Collections.singletonList(Decls.Uint), Decls.Int), Decls.newOverload("double_to_int64", Collections.singletonList(Decls.Double), Decls.Int), Decls.newOverload("string_to_int64", Collections.singletonList(Decls.String), Decls.Int), Decls.newOverload("timestamp_to_int64", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newOverload("duration_to_int64", Collections.singletonList(Decls.Duration), Decls.Int)));
        idents.add(Decls.newFunction("uint", Decls.newOverload("uint64_to_uint64", Collections.singletonList(Decls.Uint), Decls.Uint), Decls.newOverload("int64_to_uint64", Collections.singletonList(Decls.Int), Decls.Uint), Decls.newOverload("double_to_uint64", Collections.singletonList(Decls.Double), Decls.Uint), Decls.newOverload("string_to_uint64", Collections.singletonList(Decls.String), Decls.Uint)));
        idents.add(Decls.newFunction("double", Decls.newOverload("double_to_double", Collections.singletonList(Decls.Double), Decls.Double), Decls.newOverload("int64_to_double", Collections.singletonList(Decls.Int), Decls.Double), Decls.newOverload("uint64_to_double", Collections.singletonList(Decls.Uint), Decls.Double), Decls.newOverload("string_to_double", Collections.singletonList(Decls.String), Decls.Double)));
        idents.add(Decls.newFunction("bool", Decls.newOverload("bool_to_bool", Collections.singletonList(Decls.Bool), Decls.Bool), Decls.newOverload("string_to_bool", Collections.singletonList(Decls.String), Decls.Bool)));
        idents.add(Decls.newFunction("string", Decls.newOverload("string_to_string", Collections.singletonList(Decls.String), Decls.String), Decls.newOverload("bool_to_string", Collections.singletonList(Decls.Bool), Decls.String), Decls.newOverload("int64_to_string", Collections.singletonList(Decls.Int), Decls.String), Decls.newOverload("uint64_to_string", Collections.singletonList(Decls.Uint), Decls.String), Decls.newOverload("double_to_string", Collections.singletonList(Decls.Double), Decls.String), Decls.newOverload("bytes_to_string", Collections.singletonList(Decls.Bytes), Decls.String), Decls.newOverload("timestamp_to_string", Collections.singletonList(Decls.Timestamp), Decls.String), Decls.newOverload("duration_to_string", Collections.singletonList(Decls.Duration), Decls.String)));
        idents.add(Decls.newFunction("bytes", Decls.newOverload("bytes_to_bytes", Collections.singletonList(Decls.Bytes), Decls.Bytes), Decls.newOverload("string_to_bytes", Collections.singletonList(Decls.String), Decls.Bytes)));
        idents.add(Decls.newFunction("timestamp", Decls.newOverload("timestamp_to_timestamp", Collections.singletonList(Decls.Timestamp), Decls.Timestamp), Decls.newOverload("string_to_timestamp", Collections.singletonList(Decls.String), Decls.Timestamp), Decls.newOverload("int64_to_timestamp", Collections.singletonList(Decls.Int), Decls.Timestamp)));
        idents.add(Decls.newFunction("duration", Decls.newOverload("duration_to_duration", Collections.singletonList(Decls.Duration), Decls.Duration), Decls.newOverload("string_to_duration", Collections.singletonList(Decls.String), Decls.Duration), Decls.newOverload("int64_to_duration", Collections.singletonList(Decls.Int), Decls.Duration)));
        idents.add(Decls.newFunction("dyn", Decls.newParameterizedOverload("to_dyn", Collections.singletonList(paramA), Decls.Dyn, typeParamAList)));
        idents.add(Decls.newFunction("contains", Decls.newInstanceOverload("contains_string", Arrays.asList(Decls.String, Decls.String), Decls.Bool)));
        idents.add(Decls.newFunction("endsWith", Decls.newInstanceOverload("ends_with_string", Arrays.asList(Decls.String, Decls.String), Decls.Bool)));
        idents.add(Decls.newFunction("matches", Decls.newInstanceOverload("matches_string", Arrays.asList(Decls.String, Decls.String), Decls.Bool)));
        idents.add(Decls.newFunction("startsWith", Decls.newInstanceOverload("starts_with_string", Arrays.asList(Decls.String, Decls.String), Decls.Bool)));
        idents.add(Decls.newFunction("getFullYear", Decls.newInstanceOverload("timestamp_to_year", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_year_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int)));
        idents.add(Decls.newFunction("getMonth", Decls.newInstanceOverload("timestamp_to_month", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_month_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int)));
        idents.add(Decls.newFunction("getDayOfYear", Decls.newInstanceOverload("timestamp_to_day_of_year", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_day_of_year_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int)));
        idents.add(Decls.newFunction("getDayOfMonth", Decls.newInstanceOverload("timestamp_to_day_of_month", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_day_of_month_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int)));
        idents.add(Decls.newFunction("getDate", Decls.newInstanceOverload("timestamp_to_day_of_month_1_based", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_day_of_month_1_based_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int)));
        idents.add(Decls.newFunction("getDayOfWeek", Decls.newInstanceOverload("timestamp_to_day_of_week", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_day_of_week_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int)));
        idents.add(Decls.newFunction("getHours", Decls.newInstanceOverload("timestamp_to_hours", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_hours_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int), Decls.newInstanceOverload("duration_to_hours", Collections.singletonList(Decls.Duration), Decls.Int)));
        idents.add(Decls.newFunction("getMinutes", Decls.newInstanceOverload("timestamp_to_minutes", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_minutes_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int), Decls.newInstanceOverload("duration_to_minutes", Collections.singletonList(Decls.Duration), Decls.Int)));
        idents.add(Decls.newFunction("getSeconds", Decls.newInstanceOverload("timestamp_to_seconds", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_seconds_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int), Decls.newInstanceOverload("duration_to_seconds", Collections.singletonList(Decls.Duration), Decls.Int)));
        idents.add(Decls.newFunction("getMilliseconds", Decls.newInstanceOverload("timestamp_to_milliseconds", Collections.singletonList(Decls.Timestamp), Decls.Int), Decls.newInstanceOverload("timestamp_to_milliseconds_with_tz", Arrays.asList(Decls.Timestamp, Decls.String), Decls.Int), Decls.newInstanceOverload("duration_to_milliseconds", Collections.singletonList(Decls.Duration), Decls.Int)));
        return Collections.unmodifiableList(idents);
    }
}

