/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.checker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.projectnessie.cel.checker.Checker;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.checker.Mapping;
import org.projectnessie.cel.checker.Scopes;
import org.projectnessie.cel.checker.Types;
import org.projectnessie.cel.common.containers.Container;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.pb.Checked;
import org.projectnessie.cel.common.types.ref.TypeProvider;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.parser.Macro;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Constant;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Decl;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type;

public final class CheckerEnv {
    final Container container;
    final TypeProvider provider;
    private final Scopes declarations;
    int aggLitElemType;
    static final int dynElementType = 0;
    static final int homogenousElementType = 1;

    private CheckerEnv(Container container, TypeProvider provider, Scopes declarations, int aggLitElemType) {
        this.container = container;
        this.provider = provider;
        this.declarations = declarations;
        this.aggLitElemType = aggLitElemType;
    }

    public static CheckerEnv newCheckerEnv(Container container, TypeProvider provider) {
        Scopes declarations = Scopes.newScopes();
        return new CheckerEnv(container, provider, declarations, 0);
    }

    public static CheckerEnv newStandardCheckerEnv(Container container, TypeProvider provider) {
        CheckerEnv e = CheckerEnv.newCheckerEnv(container, provider);
        e.add(Checker.StandardDeclarations);
        return e;
    }

    public CheckerEnv enableDynamicAggregateLiterals(boolean enabled) {
        this.aggLitElemType = enabled ? 0 : 1;
        return this;
    }

    public void add(Decl ... decls) {
        this.add(Arrays.asList(decls));
    }

    public void add(List<Decl> decls) {
        ArrayList<String> errMsgs = new ArrayList<String>();
        for (Decl decl : decls) {
            switch (decl.getDeclKindCase()) {
                case IDENT: {
                    this.addIdent(this.sanitizeIdent(decl), errMsgs);
                    break;
                }
                case FUNCTION: {
                    this.addFunction(this.sanitizeFunction(decl), errMsgs);
                }
            }
        }
        if (!errMsgs.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)"\n", errMsgs));
        }
    }

    public Decl lookupIdent(String name) {
        for (String candidate : this.container.resolveCandidateNames(name)) {
            Decl ident = this.declarations.findIdent(candidate);
            if (ident != null) {
                return ident;
            }
            Type t = this.provider.findType(candidate);
            if (t != null) {
                Decl decl = Decls.newVar(candidate, t);
                this.declarations.addIdent(decl);
                return decl;
            }
            Val enumValue = this.provider.enumValue(candidate);
            if (enumValue.type() == Err.ErrType) continue;
            Decl decl = Decls.newIdent(candidate, Decls.Int, Constant.newBuilder().setInt64Value(enumValue.intValue()).build());
            this.declarations.addIdent(decl);
            return decl;
        }
        return null;
    }

    public Decl lookupFunction(String name) {
        for (String candidate : this.container.resolveCandidateNames(name)) {
            Decl fn = this.declarations.findFunction(candidate);
            if (fn == null) continue;
            return fn;
        }
        return null;
    }

    Decl addOverload(Decl f, Decl.FunctionDecl.Overload overload, List<String> errMsgs) {
        Decl.FunctionDecl function = f.getFunction();
        Mapping emptyMappings = Mapping.newMapping();
        Type overloadFunction = Decls.newFunctionType(overload.getResultType(), overload.getParamsList());
        Type overloadErased = Types.substitute(emptyMappings, overloadFunction, true);
        boolean hasErr = false;
        for (Decl.FunctionDecl.Overload existing : function.getOverloadsList()) {
            Type existingFunction = Decls.newFunctionType(existing.getResultType(), existing.getParamsList());
            Type existingErased = Types.substitute(emptyMappings, existingFunction, true);
            boolean overlap = Types.isAssignable(emptyMappings, overloadErased, existingErased) != null || Types.isAssignable(emptyMappings, existingErased, overloadErased) != null;
            if (!overlap || overload.getIsInstanceFunction() != existing.getIsInstanceFunction()) continue;
            errMsgs.add(this.overlappingOverloadError(f.getName(), overload.getOverloadId(), overloadFunction, existing.getOverloadId(), existingFunction));
            hasErr = true;
        }
        for (Macro macro : Macro.AllMacros) {
            if (!macro.function().equals(f.getName()) || macro.isReceiverStyle() != overload.getIsInstanceFunction() || macro.argCount() != overload.getParamsCount()) continue;
            errMsgs.add(this.overlappingMacroError(f.getName(), macro.argCount()));
            hasErr = true;
        }
        if (hasErr) {
            return f;
        }
        function = function.toBuilder().addOverloads(overload).build();
        f = f.toBuilder().setFunction(function).build();
        return f;
    }

    void addFunction(Decl decl, List<String> errMsgs) {
        Decl current = this.declarations.findFunction(decl.getName());
        if (current == null) {
            current = Decls.newFunction(decl.getName(), Collections.emptyList());
            this.declarations.addFunction(current);
        }
        for (Decl.FunctionDecl.Overload overload : decl.getFunction().getOverloadsList()) {
            current = this.addOverload(current, overload, errMsgs);
        }
        this.declarations.updateFunction(decl.getName(), current);
    }

    void addIdent(Decl decl, List<String> errMsgs) {
        Decl current = this.declarations.findIdentInScope(decl.getName());
        if (current != null) {
            errMsgs.add(this.overlappingIdentifierError(decl.getName()));
            return;
        }
        this.declarations.addIdent(decl);
    }

    Decl sanitizeFunction(Decl decl) {
        Decl.FunctionDecl fn = decl.getFunction();
        boolean needsSanitizing = false;
        block0: for (Decl.FunctionDecl.Overload o : fn.getOverloadsList()) {
            if (CheckerEnv.isObjectWellKnownType(o.getResultType())) {
                needsSanitizing = true;
                break;
            }
            for (Type p : o.getParamsList()) {
                if (!CheckerEnv.isObjectWellKnownType(p)) continue;
                needsSanitizing = true;
                continue block0;
            }
        }
        if (!needsSanitizing) {
            return decl;
        }
        ArrayList<Decl.FunctionDecl.Overload> overloads = new ArrayList<Decl.FunctionDecl.Overload>(fn.getOverloadsCount());
        for (Decl.FunctionDecl.Overload o : fn.getOverloadsList()) {
            boolean sanitized = false;
            Type rt = o.getResultType();
            if (CheckerEnv.isObjectWellKnownType(rt)) {
                rt = CheckerEnv.getObjectWellKnownType(rt);
                sanitized = true;
            }
            ArrayList<Type> params = new ArrayList<Type>(o.getParamsCount());
            for (Type p : o.getParamsList()) {
                if (CheckerEnv.isObjectWellKnownType(p)) {
                    params.add(CheckerEnv.getObjectWellKnownType(p));
                    sanitized = true;
                    continue;
                }
                params.add(p);
            }
            Decl.FunctionDecl.Overload ov = sanitized ? (o.getIsInstanceFunction() ? Decls.newInstanceOverload(o.getOverloadId(), params, rt) : Decls.newOverload(o.getOverloadId(), params, rt)) : o;
            overloads.add(ov);
        }
        return Decls.newFunction(decl.getName(), overloads);
    }

    Decl sanitizeIdent(Decl decl) {
        Decl.IdentDecl id = decl.getIdent();
        Type t = id.getType();
        if (!CheckerEnv.isObjectWellKnownType(t)) {
            return decl;
        }
        return Decls.newIdent(decl.getName(), CheckerEnv.getObjectWellKnownType(t), id.getValue());
    }

    static boolean isObjectWellKnownType(Type t) {
        if (Types.kindOf(t) != Types.Kind.kindObject) {
            return false;
        }
        return Checked.CheckedWellKnowns.containsKey(t.getMessageType());
    }

    static Type getObjectWellKnownType(Type t) {
        return Checked.CheckedWellKnowns.get(t.getMessageType());
    }

    CheckerEnv enterScope() {
        Scopes childDecls = this.declarations.push();
        return new CheckerEnv(this.container, this.provider, childDecls, this.aggLitElemType);
    }

    CheckerEnv exitScope() {
        Scopes parentDecls = this.declarations.pop();
        return new CheckerEnv(this.container, this.provider, parentDecls, this.aggLitElemType);
    }

    String overlappingIdentifierError(String name) {
        return String.format("overlapping identifier for name '%s'", name);
    }

    String overlappingOverloadError(String name, String overloadID1, Type f1, String overloadID2, Type f2) {
        return String.format("overlapping overload for name '%s' (type '%s' with overloadId: '%s' cannot be distinguished from '%s' with overloadId: '%s')", name, Types.formatCheckedType(f1), overloadID1, Types.formatCheckedType(f2), overloadID2);
    }

    String overlappingMacroError(String name, int argCount) {
        return String.format("overlapping macro for name '%s' with %d args", name, argCount);
    }
}

