/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.projectnessie.cel.Ast;
import org.projectnessie.cel.CEL;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.EvalDetails;
import org.projectnessie.cel.Issues;
import org.projectnessie.cel.Library;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.checker.Checker;
import org.projectnessie.cel.checker.CheckerEnv;
import org.projectnessie.cel.common.Errors;
import org.projectnessie.cel.common.Location;
import org.projectnessie.cel.common.Source;
import org.projectnessie.cel.common.containers.Container;
import org.projectnessie.cel.common.types.pb.ProtoTypeRegistry;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeProvider;
import org.projectnessie.cel.common.types.ref.TypeRegistry;
import org.projectnessie.cel.interpreter.Activation;
import org.projectnessie.cel.interpreter.AstPruner;
import org.projectnessie.cel.interpreter.AttributePattern;
import org.projectnessie.cel.parser.Macro;
import org.projectnessie.cel.parser.Parser;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.CheckedExpr;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Decl;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Expr;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.ParsedExpr;
import org.projectnessie.cel.relocated.com.google.protobuf.Message;

public final class Env {
    Container container;
    final List<Decl> declarations;
    final List<Macro> macros;
    TypeAdapter adapter;
    TypeProvider provider;
    private final Set<EnvOption.EnvFeature> features;
    private final List<ProgramOption> progOpts;
    private CheckerEnv chk;
    private RuntimeException chkErr;
    private final Object once = new Object();

    private Env(Container container, List<Decl> declarations, List<Macro> macros, TypeAdapter adapter, TypeProvider provider, Set<EnvOption.EnvFeature> features, List<ProgramOption> progOpts) {
        this.container = container;
        this.declarations = declarations;
        this.macros = macros;
        this.adapter = adapter;
        this.provider = provider;
        this.features = features;
        this.progOpts = progOpts;
    }

    public static Env newEnv(EnvOption ... opts) {
        ArrayList<EnvOption> stdOpts = new ArrayList<EnvOption>(opts.length + 1);
        stdOpts.add(Library.StdLib());
        Collections.addAll(stdOpts, opts);
        return Env.newCustomEnv(stdOpts.toArray(new EnvOption[0]));
    }

    public static Env newCustomEnv(TypeRegistry registry, List<EnvOption> opts) {
        return new Env(Container.defaultContainer, new ArrayList<Decl>(), new ArrayList<Macro>(), registry, registry, EnumSet.noneOf(EnvOption.EnvFeature.class), new ArrayList<ProgramOption>()).configure(opts);
    }

    public static Env newCustomEnv(EnvOption ... opts) {
        return Env.newCustomEnv(ProtoTypeRegistry.newRegistry(new Message[0]), Arrays.asList(opts));
    }

    void addProgOpts(List<ProgramOption> progOpts) {
        this.progOpts.addAll(progOpts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AstIssuesTuple check(Ast ast) {
        ParsedExpr pe = CEL.astToParsedExpr(ast);
        Object object = this.once;
        synchronized (object) {
            if (this.chk == null && this.chkErr == null) {
                CheckerEnv ce = CheckerEnv.newCheckerEnv(this.container, this.provider);
                ce.enableDynamicAggregateLiterals(true);
                if (this.hasFeature(EnvOption.EnvFeature.FeatureDisableDynamicAggregateLiterals)) {
                    ce.enableDynamicAggregateLiterals(false);
                }
                try {
                    ce.add(this.declarations);
                    this.chk = ce;
                }
                catch (RuntimeException e) {
                    this.chkErr = e;
                }
                catch (Exception e) {
                    this.chkErr = new RuntimeException(e);
                }
            }
        }
        if (this.chkErr != null) {
            Errors errs = new Errors(ast.getSource());
            errs.reportError(this.chkErr, Location.NoLocation, "%s", this.chkErr.toString());
            return new AstIssuesTuple(null, Issues.newIssues(errs));
        }
        Parser.ParseResult pr = new Parser.ParseResult(pe.getExpr(), new Errors(ast.getSource()), pe.getSourceInfo());
        Checker.CheckResult checkRes = Checker.Check(pr, ast.getSource(), this.chk);
        if (checkRes.hasErrors()) {
            return new AstIssuesTuple(null, Issues.newIssues(checkRes.getErrors()));
        }
        CheckedExpr ce = checkRes.getCheckedExpr();
        ast = new Ast(ce.getExpr(), ce.getSourceInfo(), ast.getSource(), ce.getReferenceMapMap(), ce.getTypeMapMap());
        return new AstIssuesTuple(ast, Issues.noIssues(ast.getSource()));
    }

    public AstIssuesTuple compile(String txt) {
        return this.compileSource(Source.newTextSource(txt));
    }

    public AstIssuesTuple compileSource(Source src) {
        AstIssuesTuple aiParse = this.parseSource(src);
        AstIssuesTuple aiCheck = this.check(aiParse.ast);
        Issues iss = aiParse.issues.append(aiCheck.issues);
        return new AstIssuesTuple(aiCheck.ast, iss);
    }

    public Env extend(List<EnvOption> opts) {
        if (this.chkErr != null) {
            throw this.chkErr;
        }
        ArrayList<Decl> decsCopy = new ArrayList<Decl>(this.declarations);
        ArrayList<Macro> macsCopy = new ArrayList<Macro>(this.macros);
        ArrayList<ProgramOption> progOptsCopy = new ArrayList<ProgramOption>(this.progOpts);
        TypeAdapter adapter = this.adapter;
        TypeProvider provider = this.provider;
        if (this.adapter instanceof TypeRegistry && this.provider instanceof TypeRegistry) {
            TypeRegistry adapterReg = (TypeRegistry)this.adapter;
            TypeRegistry providerReg = (TypeRegistry)this.provider;
            TypeRegistry reg = providerReg.copy();
            provider = reg;
            adapter = adapterReg.equals(providerReg) ? reg : adapterReg.copy();
        } else if (this.provider instanceof TypeRegistry) {
            provider = ((TypeRegistry)this.provider).copy();
        } else if (this.adapter instanceof TypeRegistry) {
            adapter = ((TypeRegistry)this.adapter).copy();
        }
        EnumSet<EnvOption.EnvFeature> featuresCopy = EnumSet.copyOf(this.features);
        Env ext = new Env(this.container, decsCopy, macsCopy, adapter, provider, featuresCopy, progOptsCopy);
        return ext.configure(opts);
    }

    public Env extend(EnvOption ... opts) {
        return this.extend(Arrays.asList(opts));
    }

    public boolean hasFeature(EnvOption.EnvFeature flag) {
        return this.features.contains((Object)flag);
    }

    public AstIssuesTuple parse(String txt) {
        Source src = Source.newTextSource(txt);
        return this.parseSource(src);
    }

    public AstIssuesTuple parseSource(Source src) {
        Parser.ParseResult res = Parser.parseWithMacros(src, this.macros);
        if (res.hasErrors()) {
            return new AstIssuesTuple(null, Issues.newIssues(res.getErrors()));
        }
        return new AstIssuesTuple(new Ast(res.getExpr(), res.getSourceInfo(), src), Issues.noIssues(src));
    }

    public Program program(Ast ast, ProgramOption ... opts) {
        List<ProgramOption> optSet = this.progOpts;
        if (opts.length > 0) {
            ArrayList<ProgramOption> mergedOpts = new ArrayList<ProgramOption>(this.progOpts);
            Collections.addAll(mergedOpts, opts);
            optSet = mergedOpts;
        }
        return CEL.newProgram(this, ast, optSet.toArray(new ProgramOption[0]));
    }

    public void setFeature(EnvOption.EnvFeature flag) {
        this.features.add(flag);
    }

    Container getContainer() {
        return this.container;
    }

    public TypeAdapter getTypeAdapter() {
        return this.adapter;
    }

    public TypeProvider getTypeProvider() {
        return this.provider;
    }

    public Activation.PartialActivation getUnknownVars() {
        ArrayList<AttributePattern> unknownPatterns = new ArrayList<AttributePattern>();
        for (Decl d : this.declarations) {
            if (d.getDeclKindCase() != Decl.DeclKindCase.IDENT) continue;
            unknownPatterns.add(AttributePattern.newAttributePattern(d.getName()));
        }
        return CEL.partialVars(Activation.emptyActivation(), unknownPatterns.toArray(new AttributePattern[0]));
    }

    public Ast residualAst(Ast a, EvalDetails details) {
        Expr pruned = AstPruner.pruneAst(a.getExpr(), details.getState());
        String expr = CEL.astToString(CEL.parsedExprToAst(ParsedExpr.newBuilder().setExpr(pruned).build()));
        AstIssuesTuple parsedIss = this.parse(expr);
        if (parsedIss.hasIssues()) {
            throw parsedIss.getIssues().err();
        }
        if (!a.isChecked()) {
            return parsedIss.ast;
        }
        AstIssuesTuple checkedIss = this.check(parsedIss.ast);
        if (checkedIss.hasIssues()) {
            throw checkedIss.getIssues().err();
        }
        return checkedIss.ast;
    }

    Env configure(List<EnvOption> opts) {
        Env e = this;
        for (EnvOption opt : opts) {
            e = opt.apply(e);
        }
        return e;
    }

    public String toString() {
        return "Env{container=" + this.container + "\n    , declarations=" + this.declarations + "\n    , macros=" + this.macros + "\n    , adapter=" + this.adapter + "\n    , provider=" + this.provider + "\n    , features=" + this.features + "\n    , progOpts=" + this.progOpts + "\n    , chk=" + this.chk + "\n    , chkErr=" + this.chkErr + "\n    , once=" + this.once + '}';
    }

    public static final class AstIssuesTuple {
        private final Ast ast;
        private final Issues issues;

        AstIssuesTuple(Ast ast, Issues issues) {
            this.ast = ast;
            this.issues = Objects.requireNonNull(issues);
        }

        public boolean hasIssues() {
            return this.issues.hasIssues();
        }

        public Ast getAst() {
            return this.ast;
        }

        public Issues getIssues() {
            return this.issues;
        }
    }
}

